/*
 *  example2.cpp : Defines the entry point for the console application.
 *
 *  An example program which create a new test table, 
 *  and adds new records to this table. Prints column 
 *  info and all inserted records.
 *
 *  This example program demonstrates the use classes, 
 *  which are exported from OCL DLL.
 *  
 *
 */

#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include "../oracall32.h"

int main(int argc, char* argv[])
{
	printf("Start connect...\n\n");

	// Create a new CConnection object and establish 
	// a connection to the given database. 
	CConnection con;
	con.connect("med", "med", "");
	
	// Create a new CStatement object and a test table.
	CStatement stm(&con);
	stm.executeUpdate("DROP TABLE test");
	stm.executeUpdate("CREATE TABLE test (ID_TEST INTEGER NOT NULL, Details CLOB DEFAULT EMPTY_CLOB() NULL, Name VARCHAR2(20) NULL, NDecimal DECIMAL(6,2) NULL, NFloat FLOAT DEFAULT 0 NULL, Datetime DATE DEFAULT SYSDATE NULL)");
	
	printf("Created the Test table.\n\n");
	
	tm time; 
	time.tm_sec = 1;
	time.tm_min = 50;
	time.tm_hour = 11;
	time.tm_mday = 24;
	time.tm_mon = 3;
	time.tm_year = 91;

	COCIDate date(&time);
	double ndec = 22.13;
	float  nfloat = 23.56;
	char str[] = "Name0";

	// adding new records to the table 
	stm.prepareStatement("INSERT INTO test (id_test, name, ndecimal, nfloat, datetime) VALUES(:1, :2, :3, :4, :5)");
	
	for(int i = 0; i < 5; i++)
	{
		str[4] = 0x30 + i;
		ndec = ndec + i;
		nfloat = nfloat + i;
		date.datetime[3] = 1 + i;
		
		stm.setInt(1, &i);
		stm.setString(2, str);
		stm.setDouble(3, &ndec);
		stm.setFloat(4, &nfloat);
		stm.setDate(5, &date);
		stm.executeUpdate();
		printf("Inserted %d row.\n\n", i);
	}

	CResultSet* rs = stm.executeQuery("SELECT * FROM test FOR UPDATE");
	
	short fields = rs->getFieldInfoCount();

	// Output column info
	for(i = 0; i < fields; i++)
	{
		CFieldInfo fi;
		rs->getFieldInfo(i, fi);
		printf("column=%s  dtype=%d  dsize=%d  precision=%d  scale=%d\n\n", fi.name, fi.dtype, fi.dsize, fi.precision, fi.scale);
		fflush(stdout);
	}

	printf("-------------------------------\n\n");
	fflush(stdout);
	
	int row = 0, out;
	char buff[256], bclob[18];

	// Output all rows from the test table
	while(!rs->next())
	{
		for(int j = 0; j < fields; j++)
		{
			rs->getString(j, buff, 256);
			
			printf("row=%d, column=%d, lob_lenth=%d, value=%s [%f]\n\n", row, j, rs->getLobLenth(j), buff, rs->getDouble(j));
			fflush(stdout);
		}	

		row++;
	}
	
	// disconnect from database
	con.disconnect();
	printf("End connect.\n\n", i);

	return 0;
}
