// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: leaktest.cpp 
// Compiler Used: MSVC 6.0 SR3
// File Creation Date: 11/09/2000 
// Date Last Modified: 06/27/2001
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Code used to monitor memory leaks within an MSVC application.
This program was taken from the Visual C++ Debug Routines
example program. The leak test functions will print an error
message to the console if the end of the application attempts to
overwrite the end of an allocated buffer or if any memory leaks
occur. To use this code the InitLeakTest() function must be called
in the program's main thread of execution. Additionally the
program must be compiled with the /MDd compiler flag the /MTd
compiler flag for multi-threaded applications.
*/
// ----------------------------------------------------------- //  
#include "leaktest.h"

void OutputHeading(const char * explanation)
// Debug output message heading function.
{
#if defined(__MSVC_DEBUG__)

  _RPT1(_CRT_WARN, "\n\n%s:\n**************************************\
************************************\n", explanation);
#endif // __MSVC_DEBUG__
}

void InitLeakTest()
// Initialize debug reporting functions to monitor memory leaks.
{
#if defined(__MSVC_DEBUG__)
  // Send all reports to STDOUT
  // NOTE: The _CrtSetReportMode() function is used to define the
  // destination(s) for a specific report type generated by the
  // _CrtDbgReport() function:
  // _CRTDBG_MODE_DEBUG - Writes the message to an output debug string. 
  // _CRTDBG_MODE_FILE - Writes the message to a user-supplied file handle.
  // _CRTDBG_MODE_WNDW - Creates a message box to display the message.
  _CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
  _CrtSetReportFile(_CRT_WARN, _CRTDBG_FILE_STDOUT);
  _CrtSetReportMode(_CRT_ERROR, _CRTDBG_MODE_FILE);
  _CrtSetReportFile(_CRT_ERROR, _CRTDBG_FILE_STDOUT);
  _CrtSetReportMode(_CRT_ASSERT, _CRTDBG_MODE_FILE);
  _CrtSetReportFile(_CRT_ASSERT, _CRTDBG_FILE_STDOUT);

  // NOTE: The follow code can be used to send the failures to to both a
  // debug message window and to the stdout or stderr:
  // _CrtSetReportMode(_CRT_ASSERT, _CRTDBG_MODE_FILE | _CRTDBG_MODE_WNDW);
  // _CrtSetReportFile(_CRT_ASSERT, _CRTDBG_FILE_STDERR);

  // Retrive the current debug flag settings.
  int debug_flag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);

  // Set the debug flags
  // _CRTDBG_CHECK_ALWAYS_DF - On: Call _CrtCheckMemory at every allocation and
  // deallocation request.
  // _CRTDBG_LEAK_CHECK_DF - On: Perform automatic leak checking at program
  // exit via a call to _CrtDumpMemoryLeaks
  // _CRTDBG_DELAY_FREE_MEM_DF - On: Keep freed memory blocks in the heap's
  // linked list, assign them the _FREE_BLOCK type, and fill them with the
  // byte value 0xDD
  debug_flag |= _CRTDBG_CHECK_ALWAYS_DF;   // ON
  debug_flag |= _CRTDBG_LEAK_CHECK_DF;     // ON
  debug_flag |= _CRTDBG_DELAY_FREE_MEM_DF; // ON

  // NOTE: Use the following code to turn a debug flag off:
  // debug_flag &= ~_CRTDBG_CHECK_ALWAYS_DF;
  
  _CrtSetDbgFlag(debug_flag);
#endif // __MSVC_DEBUG__
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

