// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gxheader.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This include file contains type definitions, constants,
enumerations, and data structures needed to create 32-bit
and 64-bit database files. 
*/
// ----------------------------------------------------------- //   
#ifndef __GX_BLOCK_HEADER_HPP__
#define __GX_BLOCK_HEADER_HPP__

// --------------------------------------------------------------
// Include files
// --------------------------------------------------------------
#include "gxdtypes.h"
#include "gxint32.h"
#include "gxuint32.h"
#include "gxd_ver.h"

#if defined (__64_BIT_DATABASE_ENGINE__)
#include "gxint64.h"
#include "gxuint64.h"
#endif
// --------------------------------------------------------------

// --------------------------------------------------------------
// Type definitions 
// --------------------------------------------------------------
// typedefs for 64-bit and 32-bit file operations and stream position
#if defined (__64_BIT_DATABASE_ENGINE__)
typedef gxINT64 FAU; // 64-bit File Address Unit, physical file address type
typedef __LLWORD__ FAU_t;    // Native 64-bit FAU type
typedef gxINT64 gxStreamPos; // 64-bit stream position
#else // Use the 32-bit version by default
typedef gxINT32 FAU; // 32-bit File Address Unit, physical file address type
typedef __LWORD__ FAU_t;     // Native 64-bit FAU type
typedef gxINT32 gxStreamPos; // 32-bit stream position
#endif

// CRC-32 checksum used to detect bit errors
typedef gxUINT32 gxChecksum;
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants
// --------------------------------------------------------------
// Constants for dynamic data attributes used by the first byte of the
// block header block_status member.
const __SBYTE__ gxBadBlock     = 'B'; // Bad Block
const __SBYTE__ gxDeletedBlock = 'D'; // Deleted Block 
const __SBYTE__ gxNormalBlock  = 'N'; // Normal Read/Write attribute 
const __SBYTE__ gxRemovedBlock = 'R'; // Removed Block

// This block was received from a remote device. Added in revision C
const __SBYTE__ gxRemoteDeviceBlock = 'V'; 

// Constants for block control characters used by the second byte of the
// block header "block_status" member for device control commands.
const __SBYTE__ gxAddRemoteBlock    = 'A'; // Add a remote block
const __SBYTE__ gxChangeRemoteBlock = 'C'; // Change a remote block
const __SBYTE__ gxDeleteRemoteBlock = 'D'; // Delete a remote block
const __SBYTE__ gxRequestFailed     = 'F'; // The client request failed
const __SBYTE__ gxCloseConnection   = 'L'; // Close Client/Server connection
const __SBYTE__ gxKillServer        = 'K'; // Shutdown Client/Server
const __SBYTE__ gxRequestBlock      = 'R'; // Requesting a block
const __SBYTE__ gxSendBlock         = 'S'; // Sending raw data block
const __SBYTE__ gxAcknowledgeBlock  = 'W'; // Acknowledge a data block

// Constants for file operations and stream position 
const int gxMaxNameLength     = 255;        // Max length of names buffers
const gxUINT32 gxCheckWord    = 0xfefe;     // Default synchronization word
const FAU gxStartOfFile       = (FAU)0;     // First byte in the file
const FAU gxCurrAddress       = (FAU)-1;    // Indicates current location
const FAU gxFSListCorrupt = (FAU)-1;        // Free space list is corrupt

// Constants used to determine the 32-bit and 64-bit signature sizes
#if defined (__64_BIT_DATABASE_ENGINE__)
const int gxSignatureSize = 10;
#else // Use the 32-bit version by default
const int gxSignatureSize = 8; 
#endif
// --------------------------------------------------------------

// --------------------------------------------------------------
// Enumerations
// --------------------------------------------------------------
// gxDatabase access/open mode enumeration
enum gxDatabaseAccessMode { 
    gxDBASE_READONLY,   // Open file with read access only
    gxDABSE_WRITEONLY,  // Open file with write access only
    gxDBASE_READWRITE,  // Open file with read and write access
    gxDBASE_CREATE,     // Create the file if it does not exist
    gxDBASE_NO_CREATE,  // Do not create the file if it does not exist
    gxDBASE_TRUNCATE,   // Truncate the file  
    gxDBASE_APPEND,     // Append to the file
    gxDBASE_SHARE,      // Enable file sharing  (Platform specific)
    gxDBASE_EXCLUSIVE   // Disable file sharing (Platform specifiec)
  };

// gxDatabase I/O operation codes
enum gxDatabaseOperation{ 
  gxDBASE_READ,         // A read was performed
  gxDBASE_WRITE,        // A write operation was performed
  gxDBASE_REWIND,       // A rewind operation was performed
  gxDBASE_NO_OPERATION, // No operation was performed
  gxDBASE_SEEK          // A seek operation was preformed 
};

// gxDatabase seek mode enumeration
enum gxDatabaseSeekMode { 
  gxDBASE_SEEK_BEG, // Seek starting from the beginning of the file
  gxDBASE_SEEK_CUR, // Seek starting from the current location
  gxDBASE_SEEK_END  // Seek starting from the end of the file
};

// gxDatabase file/record lock enumeration
enum gxDatabaseLockType { 
  gxDBASE_READLOCK,
  gxDBASE_WRITELOCK
};

// gxDatabase Block reclamation methods
enum gxDatabaseReclaimMethod {
  gxDBASE_RECLAIM_NONE = 0, // Do not reclaim deleted blocks
  gxDBASE_RECLAIM_BESTFIT,  // Use the best fit reclamation method
  gxDBASE_RECLAIM_FIRSTFIT  // Use the first fit reclamation method
};
// --------------------------------------------------------------

// --------------------------------------------------------------
// Data Sturctures
// --------------------------------------------------------------
// Database File Header
struct gxFileHeader // Database file header information
{ 
  gxFileHeader() { 
    gxd_fs_fptr = gxd_eof = gxd_hs_fptr = gxd_hb_fptr = (FAU)0;
    gxd_ver = (FAU)0; gxd_sig[0] = 0;
  }
  ~gxFileHeader() { }

  FAU gxd_fs_fptr;      // Address to first block of free heap space
  FAU gxd_eof;          // Address of byte after end of file
  FAU gxd_hs_fptr;      // Address of the start of the heap space
  FAU gxd_hb_fptr;      // Highest allocated database block
  __SBYTE__ gxd_sig[gxSignatureSize]; // Signature used to ID a gxDatabase 
  FAU gxd_ver;          // Database engine version number
  
private: // Disallow copying and assignment
  gxFileHeader(const gxFileHeader &ob) { }
  void operator=(const gxFileHeader &ob) { }
};

// Database/Device Block Header 
struct gxBlockHeader // Marks each data block
{
  gxBlockHeader() {
    block_check_word = gxCheckWord;
    block_status = gxNormalBlock;
    block_length = (gxUINT32)0;
    block_nd_fptr = (FAU)0;
  }
  ~gxBlockHeader() { }
  gxBlockHeader(const gxBlockHeader &ob) {
    block_check_word = ob.block_check_word; 
    block_length = ob.block_length; 
    block_status = ob.block_status;
    block_nd_fptr = ob.block_nd_fptr;
  }
  gxBlockHeader& operator=(const gxBlockHeader &ob) {
    block_check_word = ob.block_check_word; 
    block_length = ob.block_length; 
    block_status = ob.block_status;
    block_nd_fptr = ob.block_nd_fptr;
    return *this;
  }

  gxUINT32 block_check_word; // Block synchronization marker
  gxUINT32 block_length;     // Block length (object length + overhead)  
  gxUINT32 block_status;     // First byte  = status of the block's data 
                             // Second byte = block control commands
                             // Third byte  = reserved for future use
                             // Fourth byte = reserved for future use
  FAU block_nd_fptr;         // Pointer to next deleted block
};

// File lock header added to allow applications to lock the entire file during
// a multi-threaded/multi-machine read or write operation. The advisory 
// file locking scheme includes a lock protect member required to protect the 
// lock values during multiple file access. NOTE: The lock protect member is 
// required in the platform interoperable locking scheme because file lock 
// headers operate independently of the I/O subsystem and are manipulated
// by the database engine in the same manner as database blocks.
struct gxFileLockHeader
{
  gxFileLockHeader() {
    file_lock_protect = (gxUINT32)0;
    file_read_lock = file_write_lock = (gxUINT32)0; 
  }
  ~gxFileLockHeader() { }
  gxFileLockHeader(const gxFileLockHeader &ob) {
    file_lock_protect = ob.file_lock_protect;
    file_read_lock = ob.file_read_lock;
    file_write_lock = ob.file_write_lock;
  }
  gxFileLockHeader& operator=(const gxFileLockHeader &ob) {
    file_lock_protect = ob.file_lock_protect;
    file_read_lock = ob.file_read_lock;
    file_write_lock = ob.file_write_lock;
    return *this;
  }

  // The lock protect is used to serialize access to the file lock
  // values. The locking scheme will allow a total of 2^32 or
  // 4,294,967,295 threads to read lock a file and a single
  // thread to write lock a file.
  gxUINT32 file_lock_protect; // Serialize access to the file lock members
  gxUINT32 file_read_lock;    // Shared (or read-only) file lock 
  gxUINT32 file_write_lock;   // Exclusive (or write-only) file lock
};

// Record lock header used by an application to lock a specific block during 
// a multi-threaded/multi-machine read or write operation. The advisory 
// record locking scheme includes a lock protect member required to protect 
// the lock values during multiple file access. NOTE: The lock protect member 
// is required in the platform interoperable locking scheme because record 
// lock headers operate independently of the I/O subsystem and are manipulated
// by the database engine in the same manner as database blocks.
struct gxRecordLockHeader // Lock a contiguous set of bytes
{
  gxRecordLockHeader() {
    record_lock_protect = (gxUINT32)0;
    record_read_lock = record_write_lock = (gxUINT32)0;
  }
  ~gxRecordLockHeader() { }
  gxRecordLockHeader(const gxRecordLockHeader &ob) {
    record_lock_protect = ob.record_lock_protect;
    record_read_lock = ob.record_read_lock;
    record_write_lock = ob.record_write_lock;
  }
  gxRecordLockHeader& operator=(const gxRecordLockHeader &ob) {
    record_lock_protect = ob.record_lock_protect;
    record_read_lock = ob.record_read_lock;
    record_write_lock = ob.record_write_lock;
    return *this;
  }

  // The lock protect is used to serialize access to each record 
  // lock. The locking scheme will allow a total of 2^32 or
  // 4,294,967,295 threads to read lock a record and a single
  // thread to write lock a record.
  gxUINT32 record_lock_protect; // Serialize access to the record lock
  gxUINT32 record_read_lock;    // Shared (or read-only) file lock 
  gxUINT32 record_write_lock;   // Exclusive (or write-only) file lock
};
// --------------------------------------------------------------

#endif // __GX_BLOCK_HEADER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
