// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gxdfptr.h 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxDatabase file pointer routines are a collection of classes 
and standalone functions used to define the underlying file system
used by the gxDatabase class. NOTE: None of the data structures
and functions defined here are intended to be used directly. They
are used by the gxDatabase class to call the correct native file
API function for each supported platform.
*/
// ----------------------------------------------------------- //  
#ifndef __GX_DATABASE_FILE_POINTER_HPP__
#define __GX_DATABASE_FILE_POINTER_HPP__

// Select the underlying file system used for the database engine
#if defined (__64_BIT_DATABASE_ENGINE__)
#include "gxdfp64.h"
typedef gxdFPTR64 gxdFPTR;

#else // Use the 32-bit version by default
// Non-platform specific 32-bit include files
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "gxdtypes.h"
#include "gxheader.h"

struct gxdFPTR { // gxDatabase file pointer type
  FILE *fptr;
};
#endif // gxDatabase file system type

// NOTE: Any underlying file system used must provide the basic
// functionallity defined here.
gxdFPTR *gxdFPTRCreate(const char *fname);
gxdFPTR *gxdFPTROpen(const char *fname, gxDatabaseAccessMode mode);
int gxdFPTRClose(gxdFPTR *stream);
int gxdFPTRFlush(gxdFPTR *stream);
int gxdFPTRRead(gxdFPTR *stream, void *buf, __UWORD__ bytes);
int gxdFPTRWrite(gxdFPTR *stream, const void *buf, __UWORD__ bytes);
FAU_t gxdFPTRSeek(gxdFPTR *stream, FAU_t, gxDatabaseSeekMode mode);
FAU_t gxdFPTRTell(gxdFPTR *stream);
int gxdFPTRExists(const char *fname);
FAU_t gxdFPTRFileSize(const char *fname);

#endif // __GX_DATABASE_FILE_POINTER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
