// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/21/1997
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

This is a test program for the gxMAC48 class. 
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxmac48.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main(int argc, char **argv)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  cout << "Testing gxMAC48 constructors..." << endl;
  gxMAC48 mac1(0x00,0x60,0xb0,0xf9,0xb8,0x95);
  gxMAC48 mac2;

  mac2.SetByte1(0x00); mac2.SetByte2(0x60); mac2.SetByte3(0xb0); 
  mac2.SetByte4(0xf9); mac2.SetByte5(0xb8); mac2.SetByte6(0x95);

  char sbuf[mac48MaxStrLen];
  cout << "MAC address 1 = " << mac1.c_str(sbuf) << endl;
  cout << "MAC address 2 = " << mac2.c_str(sbuf) << endl;

  PausePrg();

  cout << "Testing overloaded assignment operator..." << endl;
  gxMAC48 mac3;
  mac3 = mac1;
  cout << "MAC address 3 = " << mac3.c_str(sbuf) << endl;

  PausePrg();

  cout << "Testing copy constructors..." << endl;
  gxMAC48 mac4(mac2);
  gxMAC48 mac5("00:60:b0:f9:b8:95");

  cout << "MAC address 4 = " << mac4.c_str(sbuf) << endl;
  cout << "MAC address 5 = " << mac5.c_str(sbuf) << endl;

  PausePrg();

  cout << "Testing string input functions" << endl;
  mac5.SetMACAddress("00:60:b0:f9:b8:95", ':', 2);
  cout << "MAC input string = 00:60:b0:f9:b8:95 output = " 
       << mac5.c_str(sbuf) << endl;
  mac5.SetMACAddress("00-60-b0-f9-b8-95", '-', 2);
  cout << "MAC input string = 00-60-b0-f9-b8-95 output = " 
       << mac5.c_str(sbuf, '-') << endl;
  mac5.SetMACAddress("00.60.b0.f9.b8.95", '.', 2);
  cout << "MAC input string = 00.60.b0.f9.b8.95 output = " 
       << mac5.c_str(sbuf, '.') << endl;
  mac5.SetMACAddress("0060:b0f9:b895", ':', 4);
  cout << "MAC input string = 0060:b0f9:b895 output = " 
       << mac5.c_str(sbuf, ':', 4) << endl;
  mac5.SetMACAddress("0060-b0f9-b895", '-', 4);
  cout << "MAC input string = 0060-b0f9-b895 output = " 
       << mac5.c_str(sbuf, '-', 4) << endl;
  mac5.SetMACAddress("0060.b0f9.b895", '.', 4);
  cout << "MAC input string = 0060.b0f9.b895 output = " 
       << mac5.c_str(sbuf, '.', 4) << endl;

  PausePrg();
  cout << "Testing the vendor code functions" << endl;
  cout << "Vendor code = " << hex << mac5.GetVendorCode() << endl;
  cout << "Vendor code string = " << mac5.GetVendorCode(sbuf) << endl;

  // Find the vendor code if a MAC vendor text file is specified
  // on the command line
  if(argc == 2) {
    cout << endl;
    cout << "Searching for vendor info..." << endl;
    const char *fname = (const char *)argv[1];
    char name[255];
    char comment[255];
    if(FindVendor(fname, mac5, name, comment)) {
      cout << "Vendor name = " << name << endl;
      if(comment[0] != 0) 
	cout << "Comments    = " << comment << endl;
    }
    else {
      cout << "Could not obtain vendor info from the " 
	   << fname << " file" << endl;
    }
  }
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
