// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 03/25/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Test program demonstrating the basic operation of the gxThread
class using semaphores.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <stdlib.h>
#include "gxthread.h"
#include "gxsema.h"


#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Constants
const int NUM_THREADS = 3;

// Global semaphore object
gxSemaphore sema;

// Shared data 
int sharedData1 = 0;
int sharedData2 = 0;
 
// Class derived from the abstract gxThread base class 
class SimpleThread : public gxThread
{
public:
  SimpleThread() { }
  ~SimpleThread() { }
  
private: // Base class interface
  void *ThreadEntryRoutine(gxThread_t *thread);
};

void *SimpleThread::ThreadEntryRoutine(gxThread_t *thread)
{
  cout << "Entering thread" << endl;
  if(sema.SemaphoreWait() != 0) {
    cout << sema.SemaphoreExceptionMessage() << endl;
    return ExitThread(thread, 1);
  }

  // ********** Critical Section ******************* //
  cout << "Start critical section, holding semaphore" << endl;

  // Access to shared data goes here
  ++sharedData1; --sharedData2;
  cout << "sharedData1 = " << sharedData1 << ", sharedData2 = " << sharedData2
       << endl;

  cout << "End critical section, release semaphore" << endl;
  // ********** Critical Section ******************* //

  if(sema.SemaphorePost() != 0) {
    cout << sema.SemaphoreExceptionMessage() << endl;
    return ExitThread(thread, 1);
  }

  return 0;
}
 
int main(int argc, char **argv)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  SimpleThread t;
  gxThread_t *thread[NUM_THREADS];
  int i;
 
  cout << "Wait on semaphore to prevent access to shared data" << endl;
  cout << "sharedData1 = " << sharedData1 << ", sharedData2 = " << sharedData2
       << endl;

  if(sema.SemaphoreWait() != 0) {
    cout << sema.SemaphoreExceptionMessage() << endl;
    return 0;
  }

  cout << "Creating " << NUM_THREADS << " threads" << endl;
  for(i = 0; i < NUM_THREADS; ++i) thread[i] = t.CreateThread();
 
  cout << "Wait a bit until we are done with the shared data" << endl;
  t.sSleep(3);

  cout << "Unlock shared data" << endl;
  if(sema.SemaphorePost() != 0) {
    cout << sema.SemaphoreExceptionMessage() << endl;
    return 0;
  }

  cout << "Wait for the threads to complete, and release their resources"
       << endl;
  for(i = 0; i < NUM_THREADS; ++i) t.JoinThread(thread[i]);

  // Prevent memory leaks
  for(i = 0; i < NUM_THREADS; ++i) delete thread[i];
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
