// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: edscfg.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 10/15/1999 
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to test software registration program.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include "sreg101.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Test code starts here
void ClearInputStream(istream &s)
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void InputData(char *mesg, UString &sbuf)
{
  cout << "Input " << mesg << ": ";
  char buf[255];
  cin.getline(buf, sizeof(buf));
  sbuf = buf;
}

void Menu()
{
  cout << endl;
  cout << "(?)   Display this menu" << endl;
  cout << "(e)   Enter program name" << endl;
  cout << "(v)   Validate a registration code" << endl;
  cout << "(q)   Quit" << endl;
  cout << endl;
}

int Quit()
{
  return 0;
}

int main(int argc, char **argv)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  if(argc >= 3) { 
    srnGenerator auto_srn(argv[1], argv[2]);
    cout << endl;
    cout << "Your " << argv[1] << " user name and registration code."
	 << endl;
    cout << "Assigned User Name: " << argv[2] << endl;
    cout << "Registration Number: " << auto_srn.GetRegCode() << endl;
    cout << endl;
    return 0;
  }

  srnGenerator srn;
  int i, rv;
  char key;
  UString pname; UString user_name; UString reg_code;

  if(argc <= 2) Menu(); // Not processing a command
  
  rv = 1;
  while(rv) {
    if (!cin) { 
      ClearInputStream(cin);
      if (!cin) { 
	cout << "Input stream error" << endl;
	return 0;
      }
    }
    cout << endl;
    cout << '>';
    cin >> key;

    if (!cin) continue;
    switch(key) {
      case 'e' : case 'E' : 
	ClearInputStream(cin);
	InputData("Program Name", pname);
	InputData("User Name", user_name);
	srn.GenRegString(pname, user_name);
	cout << endl;
	cout << "Your " << pname.c_str() << " user name and registration code."
	     << endl;
	cout << "Assigned User Name: " << user_name.c_str() << endl;
	cout << "Registration Number: " << srn.GetRegCode() << endl;
	cout << endl;
	break;
      case 'v' : case 'V' : {
	ClearInputStream(cin);
	InputData("Program Name", pname);
	InputData("User Name", user_name);
	InputData("Registration Code", reg_code);
	srnGenerator ob1(srn);  // Test the copy constructor
	srnGenerator ob2 = ob1; // Test assignment operator
	i = ob2.Validate(reg_code, pname, user_name);
	cout << endl;
	if(!i) cout << reg_code.c_str() << " is not valid" << endl;
	else cout << "This code is valid" << endl;
	cout << endl;
	break;
      }
      case 'q' : case 'Q' :
	rv = Quit();
	break;
      case '?' :
	Menu();
	break;

      default:
        cout << "Unrecognized command" << endl;
	cout << endl;
    }
  }

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
