# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

# Build dependency rules
# ===============================================================
GXCRC32_DEP = $(INCLUDE_PATH)gxcrc32.h \
	$(INCLUDE_PATH)gxcrctab.h

GXDERROR_DEP = $(INCLUDE_PATH)gxderror.h

GXINT32_DEP = $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxint32.h

GXDFPTR_DEP = $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxdfptr.h \
	$(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h \
	$(INCLUDE_PATH)gxuint32.h

GXDBASE_DEP = $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdfptr.h \
	$(INCLUDE_PATH)gxderror.h \
	$(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h \
	$(INCLUDE_PATH)gxdbase.h \
	$(INCLUDE_PATH)gxcrc32.h \
	$(INCLUDE_PATH)gxuint32.h

GXUINT32_DEP = $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxuint32.h

GXDSTATS_DEP = $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdfptr.h \
	$(INCLUDE_PATH)gxderror.h \
	$(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h \
	$(INCLUDE_PATH)gxdbase.h \
	$(INCLUDE_PATH)gxuint32.h \
	$(INCLUDE_PATH)gxdstats.h \
	$(INCLUDE_PATH)gxcrc32.h

USTRING_DEP = $(INCLUDE_PATH)ustring.h

EDS101_DEP = $(INCLUDE_PATH)eds101.h \
	$(INCLUDE_PATH)edst101.h

EDSCFG_DEP = $(INCLUDE_PATH)eds101.h \
	$(INCLUDE_PATH)edscfg.h \
	$(INCLUDE_PATH)ustring.h \
	$(INCLUDE_PATH)gxlistb.h \
	$(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdfptr.h \
	$(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxderror.h \
	$(INCLUDE_PATH)gxint32.h \
	$(INCLUDE_PATH)gxdbase.h \
	$(INCLUDE_PATH)gxuint32.h \
	$(INCLUDE_PATH)gxdstats.h \
	$(INCLUDE_PATH)gxcrc32.h

PROJECT_DEP = $(INCLUDE_PATH)eds101.h \
	$(INCLUDE_PATH)edscfg.h \
	$(INCLUDE_PATH)ustring.h \
	$(INCLUDE_PATH)gxlistb.h \
	$(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdfptr.h \
	$(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxderror.h \
	$(INCLUDE_PATH)gxint32.h \
	$(INCLUDE_PATH)gxdbase.h \
	$(INCLUDE_PATH)gxuint32.h \
	$(INCLUDE_PATH)gxdstats.h \
	$(INCLUDE_PATH)gxcrc32.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

gxderror$(OBJ_EXT):	$(SRC_PATH)gxderror.cpp $(GXDERROR_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxderror.cpp

gxint32$(OBJ_EXT):	$(SRC_PATH)gxint32.cpp $(GXINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxint32.cpp

gxdfptr$(OBJ_EXT):    $(SRC_PATH)gxdfptr.cpp $(GXDFPTR_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxdfptr.cpp

gxdbase$(OBJ_EXT):    $(SRC_PATH)gxdbase.cpp $(GXDBASE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxdbase.cpp

gxuint32$(OBJ_EXT):	$(SRC_PATH)gxuint32.cpp $(GXUINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxuint32.cpp

gxcrc32$(OBJ_EXT):	$(SRC_PATH)gxcrc32.cpp $(GXCRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxcrc32.cpp

gxdstats$(OBJ_EXT):	$(SRC_PATH)gxdstats.cpp $(GXDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxdstats.cpp

ustring$(OBJ_EXT):	$(SRC_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)ustring.cpp

gxlistb$(OBJ_EXT):	$(SRC_PATH)gxlistb.cpp $(GXLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxlistb.cpp

eds101$(OBJ_EXT):	$(SRC_PATH)eds101.cpp $(EDS101_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)eds101.cpp

edscfg$(OBJ_EXT):	$(SRC_PATH)edscfg.cpp $(EDSCFG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)edscfg.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) leaktest$(OBJ_EXT) \
	gxderror$(OBJ_EXT) gxint32$(OBJ_EXT) edscfg$(OBJ_EXT)\
	gxcrc32$(OBJ_EXT) gxuint32$(OBJ_EXT) gxdbase$(OBJ_EXT) \
	gxdfptr$(OBJ_EXT) gxdstats$(OBJ_EXT) eds101$(OBJ_EXT) \
	ustring$(OBJ_EXT) gxlistb$(OBJ_EXT)
# ===============================================================
