// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997  
// Date Last Modified: 06/12/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Simple demo of the gxDatabase class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include "gxdbase.h"
#include "gxfloat.h"
#include "gxdstats.h"

const int name_length = 16;

class DatabaseObject
{ 
public:
  DatabaseObject() { name[0] = 0; oid = (gxINT32)0, cid = (gxFLOAT64)0; }
  DatabaseObject(const char *s, long i, double d);

public:
  void DisplayObject();
  
public: // Platform independent data members
  char name[name_length]; // Fixed string type
  gxINT32 oid;            // Integer type
  gxFLOAT64 cid;          // Floating point type
};

DatabaseObject::DatabaseObject(const char *s, long i, double d)
{
  for(int j = 0; j < name_length; j++) name[j] = 0; // Clear the name string
  strcpy(name, s);
  oid = i;  
  cid = d;
}

void DatabaseObject::DisplayObject()
{
  cout << "Database object name: " << name << endl;
  cout << "Database object OID:  " << oid << endl;
  cout.setf(ios::showpoint | ios::fixed);
  cout.precision(3);
  cout << "Database object CID:  " << cid << endl;
}

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  // Using pointer semantics to prevent copying
  gxDatabase *f = new gxDatabase; 

  cout << endl;
  cout << "Simple demo of the file manager class." << endl;
  EchoDatabaseVersion();

  const char *fname = "simple.gxd";
  
  cout << "Creating new file..." << endl;
  // f->Create(fname, FAU(0), '\0'); // Used for rev zero testing
  // f->Create(fname, FAU(0), 'A');  // Used for rev 'A' testing
  // f->Create(fname, FAU(0), 'B');  // Used for rev 'B' testing
  // f->Create(fname, FAU(0), 'C');  // Used for rev 'C' testing
  f->Create(fname); // Current database revision
  if(CheckError(f) != 0) return 1;
  
  PausePrg();
  DatabaseStats(f);
  PausePrg();
  
  cout << "Adding object to database file..." << endl;
  cout << "Size of object = " << sizeof(DatabaseObject) << endl;
  
  // Allocate a block to store the object
  FAU addr = f->Alloc(sizeof(DatabaseObject)); 
  if(CheckError(f) != 0) return 1;

  // Construct the datbase object
  DatabaseObject ob("Mouse", (long)addr, 2000.101);
  
  // Write the objects data
  f->Write(&ob, sizeof(DatabaseObject));
  if(CheckError(f) != 0) return 1;
  cout << "Block Address: " << (addr - f->BlockHeaderSize()) << endl;
  cout << "Writing object to FAU: " << addr << endl;
    
  PausePrg();
  BlockStats(f, addr);
  PausePrg();

  DatabaseObject buf;
  cout << "Reading the first object from the database file..." << endl;
  addr = f->FindFirstBlock();

  // Read the objects data
  if(addr) {
    f->Read(&buf, sizeof(buf), addr+f->BlockHeaderSize());
    if(CheckError(f) != 0) return 1;
    buf.DisplayObject();
  }
  
  PausePrg();
  DatabaseStats(f);
  PausePrg();

  cout << "Exiting..." << endl;

  // Close the file and check for any errors
  f->Close();
  if(CheckError(f) != 0) return 1;

  // Delete the object
  delete f; // The destructor call will close the file if it is open 
  
  return 0; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
