// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997  
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Demo of how to re-open a database file using the gxDatabase
manager.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include "gxdbase.h"
#include "gxdstats.h"
#include "gxfloat.h"

const int name_length = 16;

class DatabaseObject
{ 
public:
  DatabaseObject() { name[0] = 0; oid = (gxINT32)0, cid = (gxFLOAT64)0; }
  DatabaseObject(const char *s, long i, double d);

public:
  friend void *operator new(size_t n, char *s, int i, double d,
			    gxDatabase *f) {
    void *ptr = new DatabaseObject(s, i, d);
    f->Write(ptr, n, f->Alloc(n));
    return ptr;
  }
  
public: // Platform independent data members
  char name[name_length]; // Fixed string type
  gxINT32 oid;            // Integer type
  gxFLOAT64 cid;          // Floating point type
};

DatabaseObject::DatabaseObject(const char *s, long i, double d)
{
  for(int j = 0; j < name_length; j++) name[j] = 0; // Clear the name string
  strcpy(name, s);
  oid = i;  
  cid = d;
}

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  gxDatabase *f = new gxDatabase; 
  const char *fname1 = "cat.gxd";
  const char *fname2 = "dog.gxd";
  const char *fname3 = "mouse.gxd";
  
  cout << endl;

  cout << "Testing the gxDatabase::ReOpen() function." << endl;
  if(!gxDatabase::Exists(fname1)) f->Create(fname1);
  if(CheckError(f) != 0) return 1;
  if(!gxDatabase::Exists(fname2)) f->Create(fname2);
  if(CheckError(f) != 0) return 1;
  if(!gxDatabase::Exists(fname3)) f->Create(fname3);
  if(CheckError(f) != 0) return 1;

  // Variables for Part class objects
  int id = 17; double price = 42.97;

  cout << endl;
  cout << "Writing one object to: " << fname1 << endl;
  f->Open(fname1);
  if(CheckError(f) != 0) return 1;
  new("Cat", 0L, 2000.101, f) DatabaseObject;
  PausePrg();
  DatabaseStats(f);
  PausePrg();

  cout << "Writing two objects to: " << fname2 << endl;
  f->Open(fname2);
  if(CheckError(f) != 0) return 1;
  new("Cat", 0L, 2000.101, f) DatabaseObject;
  new("Dog", 0L, 2000.101, f) DatabaseObject;
  PausePrg();
  DatabaseStats(f);
  PausePrg();

  cout << "Writing three objects to: " << fname3 << endl;
  f->Open(fname3);
  if(CheckError(f) != 0) return 1;
  new("Cat", 0L, 2000.101, f) DatabaseObject;
  new("Dog", 0L, 2000.101, f) DatabaseObject;
  new("Mouse", 0L, 2000.101, f) DatabaseObject;
  PausePrg();
  DatabaseStats(f);
  PausePrg();

  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return 1;
  delete f;
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
