// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997  
// Date Last Modified: 06/12/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Test program used to compare the features of the 64-bit database
engine to the 32-bit database engine..

NOTE: Currently 64-bit support is limited in the database library 
to Windows NT (NTFS), RedHat 6.2/7.2, HPUX 11.0 and Solaris 2.8 
platforms. As large file support and 64-bit operating systems 
become more prevalent support will included for all the platforms 
supported by the 32-bit database engine.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include "gxfloat.h"
#include "gxdbase.h"
#include "gxdstats.h"

// Various static data area sizes used to test large files
const __LLWORD__ STATIC_AREA_SIZE = (__LLWORD__)0;

// 2 GIG file test                              
// WARNING: This test requires 2.3 GIG of free disk space
// const __LLWORD__ STATIC_AREA_SIZE = (__LLWORD__)2147483647;

// 4 GIG file test
// WARNING: This test requires 4.3 GIG of free disk space
// const __LLWORD__ STATIC_AREA_SIZE = (__LLWORD__)4294967290;

const int NUM_OBJECTS = 10;
const int NAME_LENGTH = 128;

class DatabaseObject
{ 
public:
  DatabaseObject() { name[0] = 0; oid = (FAU)0, cid = (gxFLOAT64)0; }
  DatabaseObject(const char *s, __LLWORD__ i, double d);

public:
  void DisplayObject();
  
public: // Platform independent data members
  char name[NAME_LENGTH]; // Fixed string type
  FAU oid;                // Integer type
  gxFLOAT64 cid;          // Floating point type
};

DatabaseObject::DatabaseObject(const char *s, __LLWORD__ i, double d)
{
  for(int j = 0; j < NAME_LENGTH; j++) name[j] = 0; // Clear the name string
  strcpy(name, s);
  oid = i;  
  cid = d;
}

void DatabaseObject::DisplayObject()
{
  cout << "Database object name: " << name << endl;
  cout << "Database object OID:  " << oid << endl;
  cout.setf(ios::showpoint | ios::fixed);
  cout.precision(3);
  cout << "Database object CID:  " << cid << endl;
}

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  gxDatabase *f = new gxDatabase; 
  const char *fname = "simple.gxd";
  int i;
  FAU index[NUM_OBJECTS];
  FAU static_area_size(STATIC_AREA_SIZE);
  FAU addr;
  DatabaseObject buf;
  int exists = 0;

  cout << endl;
  cout << "Simple demo of the file manager class." << endl;
  
  if(!gxDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl;
    f->Create(fname, static_area_size);
    if(CheckError(f) != 0) return 1;
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(fname);
    if(CheckError(f) != 0) return 1;
    exists = 1;
  }

  PausePrg();
  DatabaseStats(f);
  PausePrg();

  if(exists == 1) {
    // Used for big and little endian cross-platform testing
    cout << "Reading the first object..." << endl;
    addr = f->FindFirstBlock();
    f->Read(&buf, sizeof(buf), addr+f->BlockHeaderSize());
    if(CheckError(f) != 0) return 1;
    buf.DisplayObject();
    PausePrg();
    cout << "Reading the last object..." << endl;
    f->Read(&buf, sizeof(buf), f->GetHighestBlock()+f->BlockHeaderSize());
    if(CheckError(f) != 0) return 1;
    buf.DisplayObject();
    PausePrg();
  }

  cout << "Adding " << NUM_OBJECTS << " objects to database file..." << endl;
  cout << "Size of each object = " << sizeof(DatabaseObject) << endl;
  PausePrg();
  
  for(i = 0; i < NUM_OBJECTS; i++) {
    // Allocate a block to store the object
    addr = f->Alloc(sizeof(DatabaseObject)); 
    if(CheckError(f) != 0) return 1;
    
    // Index the object
    index[i] = addr;
    
    // Construct the datbase object
    char name[NAME_LENGTH];
    char sbuf[NAME_LENGTH];
    sprintf(name, "Mouse %s", addr.c_str(sbuf));
    DatabaseObject ob(name, addr, 2000.101);
    
    // Write the object data
    f->Write(&ob, sizeof(DatabaseObject));
    if(CheckError(f) != 0) return 1;
    cout << "Block Address: " << (FAU)(addr - f->BlockHeaderSize()) << endl;
    cout << "Writing object " << i << " to FAU: " << addr << endl;
  }
    
  cout << "Wrote " << i << " to the database file" << endl;
  PausePrg();
  
  cout << "Reading " << NUM_OBJECTS << " objects from the database file..." 
       << endl;
  PausePrg();
  
  for(i = 0; i < NUM_OBJECTS; i++) {
    f->Read(&buf, sizeof(buf), index[i]);
    if(CheckError(f) != 0) return 1;
    buf.DisplayObject();
  }
  
  PausePrg();
  DatabaseStats(f);
  PausePrg();

  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return 1;

  delete f;
  return 0; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
