import Sav.Z.*;
import java.io.*;
/**
 * The code prints Statements of a Script and
 * marks the failure Statements.
 */
public class StatementDemo {
  public static void main(String arg[]) throws IOException {
    String text =
      "= $base Users;\n" +
      "User:ann1 =;\n" +
      "= User:ann1;\n"
    ;
    /*Demo1*****************/
    Session ss = new Session();
    Script scr = new Script(text);
    ss.analyse(scr);
    Statement[] stmArray = scr.statements();
    if (ss.hasErrors()) {
     /***********************/
      StringBuffer sb = new StringBuffer();
      for (int i = 0; i < stmArray.length; ++i) {
        System.out.print(stmArray[i]);
        if (stmArray[i].hasErrors())
          System.out.println(" - ERROR");
        else 
          System.out.println();
        sb.append(stmArray[i].rightExpression()).append(";\n");
      }
      scr = new Script(sb.toString());
      ss.analyse(scr);
      stmArray = scr.statements();
     /*Demo2*****************/
    }
    Statement stm = null;
    try {
      ss.execute(scr);
    } catch (ZException exc) {
      System.out.print(exc.toString());
      stm = ss.curStatement();
    }
    System.out.println("EXECUTION TRACE");
    for (int i = 0; i < stmArray.length; ++i) {
      System.out.print(stmArray[i]);
      if (stmArray[i].hasFailures())
        System.out.println(" - FAILURE");
      else
        System.out.println();
      if (stmArray[i] == stm) {
        System.out.print("INTERRUPTION LINE: " + stm.getLineNumber());
        break;
      }
    }
  }
}