<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<xsl:template match="/">

<html>
 <head>
  <title><xsl:value-of select="/CasualWriter/REPORT"/></title>
 </head>
 <style>
   table {font-family:Arial;font-size:12px;}
 </style>
<body>
  <table border="0" width="100%" bgcolor="#DDDDDD">
  <tr>
    <td><b>Company: <xsl:value-of select="/CasualWriter/COMPANY"/></b></td>
    <td align="right"><i>Generated by <xsl:value-of select="/CasualWriter/GENERATED_BY"/>
           on <xsl:value-of select="/CasualWriter/EXPORT_DATE"/></i>
    </td>
  </tr>
  </table><br/>

  <center><p><font size="4" color="blue">
   <b><xsl:value-of select="/CasualWriter/REPORT"/></b>
  </font></p>
  </center>
  
  <p>
  <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
         bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
    <tr><td><b><xsl:value-of select="/CasualWriter/ENTRY"/></b></td></tr>
    <tr><td><b><xsl:value-of select="/CasualWriter/DESCRIPTION"/></b></td></tr>
    <tr><td><xsl:value-of select="/CasualWriter/OBJECT_SIZE"/>
                 <xsl:value-of select="/CasualWriter/OBJECT_DATE"/>
    </td></tr>
  </table>
  </p>
  
  <xsl:for-each select="/CasualWriter/MENU_ITEM">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr><td colspan="6" align="left"><font size="3"><b>MENU ITEM</b></font></td></tr>     
      <tr>
        <td width="10%"><b>Menu Item</b></td>
        <td width="10%"><b>Menu Name</b></td>
        <td width="30%"><b>Menu Text</b></td>
        <td width="5%"><b>Byte</b></td>
        <td width="5%"><b>Line</b></td>
        <td width="40%"><b>&#160;Remarks</b></td>
      </tr>
      <xsl:for-each select="ITEM">
        <tr>
           <td><xsl:value-of select="PARENT"/></td>
           <td><xsl:value-of select="MENU_ITEM"/></td>
           <td><xsl:value-of select="MENU_TEXT"/></td>
           <td><xsl:value-of select="BYTES"/></td>
           <td><xsl:value-of select="LINE"/></td>
           <td>&#160;<xsl:value-of select="REMARKS"/></td>
        </tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>
  
  <xsl:for-each select="/CasualWriter/STRUCTURE">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr><td colspan="3" align="left"><font size="3"><b>Structure</b></font></td></tr>     
      <tr>
        <td width="30%"><b>Structure</b></td>
        <td width="30%"><b>Type</b></td>
        <td width="50%"><b>Variable</b></td>
      </tr>
      <xsl:for-each select="ITEM">
        <tr>
          <td><xsl:value-of select="STRUCTURE_NAME"/></td>
          <td><xsl:value-of select="VARIABLE_TYPE"/></td>
          <td><xsl:value-of select="VARIABLE_NAME"/></td>
        </tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>
  
  <xsl:for-each select="/CasualWriter/VARIABLES">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr><td colspan="2" align="left"><font size="3"><b>Variables</b></font></td></tr>     
      <tr>
        <td width="20%"><b>Type</b></td>
        <td width="80%"><b>Declaration</b></td>
      </tr>
      <xsl:for-each select="ITEM">
        <tr>
          <td><xsl:value-of select="TYPE"/></td>
          <td><xsl:value-of select="DECLARATION"/></td>
        </tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>
  
  <xsl:for-each select="/CasualWriter/SCRIPT_LIST">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr><td colspan="5" align="left"><font size="3"><b>Script List</b></font></td></tr>     
      <tr>
        <td width="20%"><b>Control</b></td>
        <td width="10%"><b>Type</b></td>
        <td width="60%"><b>Name</b></td>
        <td width="5%"><b>Bytes</b></td>
        <td width="5%"><b>Line</b></td>
      </tr>
      <xsl:for-each select="ITEM">
        <tr>
          <td><b><xsl:value-of select="CONTROL"/></b></td>
          <td><xsl:value-of select="TYPE"/></td>
          <td><xsl:value-of select="NAME"/></td>
          <td><xsl:value-of select="BYTES"/></td>
          <td><xsl:value-of select="LINE"/></td>
        </tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>
  
  <xsl:for-each select="/CasualWriter/SCRIPT_DETAILS">
    <xsl:for-each select="SCRIPT_ITEM">
      <p>
      <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
               bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr>
       <td>
			<b><xsl:value-of select="TYPE"/> <xsl:value-of select="NAME"/></b> 
       </td>
      </tr>     
      <tr><td style="font-family=Courier;font-size:9px;"><pre>
		<xsl:for-each select="CONTENT">
  			<xsl:value-of select=".//"/>
      </xsl:for-each>
      </pre></td></tr>
      </table>
      </p>
    </xsl:for-each>
  </xsl:for-each>

</body>
</html>

</xsl:template>

</xsl:stylesheet>