<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<xsl:template match="/">

<html>
 <head>
  <title><xsl:value-of select="/CasualWriter/REPORT"/></title>
 <script>
	function showtree(line, prefix, name, lib, upd, size, remarks) {
	    var ll='', i, c;
 		 var sp = unescape('%26nbsp;');
		 for (i=0; i!=line.length; i++)  
			ll += (line.charAt(i)=='1'? sp+'|'+sp : sp+sp+sp );
	    ll += (prefix=='1'? sp+'|-' : (prefix=='2'? sp+'\\-' : ''));
	    ll = '<tr><td nowrap="nowrap">' + ll + name + '</td>';
	    ll += '<td nowrap="nowrap">(' + lib + ', ' + upd.substring(0,10) + ', ' + size + ') ';
	    document.writeln( ll + remarks + '<br/></td></tr>' );
	} 
 </script>

</head>
<body>

  <table border="0" width="100%" bgcolor="#DDDDDD">
  <tr>
    <td><b>Company: <xsl:value-of select="/CasualWriter/COMPANY"/></b></td>
    <td align="right"><i>Generated by <xsl:value-of select="/CasualWriter/GENERATED_BY"/>
           on <xsl:value-of select="/CasualWriter/EXPORT_DATE"/></i>
    </td>
  </tr>
  </table><br/>

  <center><p><font size="4" color="blue">
   <b><xsl:value-of select="/CasualWriter/REPORT"/></b>
  </font></p>
  </center>
  
  <xsl:for-each select="/CasualWriter/HIERARCHY">
  <p>
  <table width="100%" align="center" border="0" bgcolor="#FFFFFF" cellspacing="0" 
    style="font-family=Courier;font-size:9px;line-height:1.1">

    <xsl:for-each select="/CasualWriter/HIERARCHY/ITEM">

    <script language="JavaScript1.2">
       showtree( '<xsl:value-of select="TREE_LINE"/>', 
					  '<xsl:value-of select="TREE_PREFIX"/>', 
					  '<xsl:value-of select="ENTRY"/>',
					  '<xsl:value-of select="LIBRARY"/>',
					  '<xsl:value-of select="UPDATE"/>',
					  '<xsl:value-of select="SIZE"/>',
					  '<xsl:value-of select="DESCRIPTION"/>'); 
    </script>
    </xsl:for-each>
  </table>
  </p>
  </xsl:for-each>

</body>
</html>

</xsl:template>

</xsl:stylesheet>