<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<xsl:template match="/">

<html>
 <head>
  <title><xsl:value-of select="/CasualWriter/REPORT"/></title>
 </head>
 <style>
   table {font-family:Arial;font-size:12px;}
 </style>
<body>

  <table border="0" width="100%" bgcolor="#DDDDDD">
  <tr>
    <td><b>Company: <xsl:value-of select="/CasualWriter/COMPANY"/></b></td>
    <td align="right"><i>Generated by <xsl:value-of select="/CasualWriter/GENERATED_BY"/>
           on <xsl:value-of select="/CasualWriter/EXPORT_DATE"/></i>
    </td>
  </tr>
  </table><br/>

  <center><p><font size="4" color="blue">
   <b><xsl:value-of select="/CasualWriter/REPORT"/></b>
  </font></p></center>
  
  <p>
  <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
         bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
    <tr><td width="20%"><b>Style:</b></td>
        <td width="80%">&#160;<xsl:value-of select="/CasualWriter/SUMMARY//STYLE"/></td>
    </tr>
    <tr><td><b>Storage:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//STORAGE"/> Bytes</td>
    </tr>
    <tr><td><b>Orientation:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//ORIENTATION"/></td>
    </tr>
    <tr><td><b>Paper:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//PAPER"/></td>
    </tr>
    <tr><td><b>Readonly:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//READONLY"/></td>
    </tr>
    <tr><td><b>RetrieveAsNeed:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//RETRIEVEASNEED"/></td>
    </tr>
    <tr><td><b>Sort:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//SORT"/></td>
    </tr>
    <tr><td><b>Filter:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//FILTER"/></td>
    </tr>
    <tr><td><b>Suppress Repeat:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//SUPPRESS_REPEAT"/></td>
    </tr>
    <tr><td><b>Update Table:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//UPDATE_TABLE"/></td>
    </tr>
    <tr><td><b>Update Method:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//UPDATE_METHOD"/></td>
    </tr>
    <tr><td><b>Update Where:</b></td>
        <td>&#160;<xsl:value-of select="/CasualWriter/SUMMARY//UPDATE_WHERE"/></td>
    </tr>
  </table>
  </p>

  <xsl:for-each select="/CasualWriter/SQL_SELECT">
	  <p>
	  <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
   	      bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
	    <tr><td><b>SQL Syntax</b></td></tr>
 	  	 <tr><td><pre><xsl:value-of select="/CasualWriter/SQL_SELECT//SQL_SYNTAX"/></pre>
       </td></tr>
     </table>
     </p>
  </xsl:for-each>

  <xsl:for-each select="/CasualWriter/COLUMN_SPECIFICATIONS">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr>
        <td width="03%"><b>No</b></td>
        <td width="25%"><b>&#160;Column Name</b></td>
        <td width="12%"><b>&#160;Type</b></td>
        <td width="25%"><b>&#160;DB Name</b></td>
        <td width="5%"><b>&#160;Key</b></td>
        <td width="05%"><b>&#160;Update</b></td>
        <td width="30%"><b>&#160;Validate</b></td>
      </tr>
      <xsl:for-each select="ITEM">
		  	<tr>
		  	<td><xsl:value-of select="NO"/></td>
		  	<td>&#160;<xsl:value-of select="COLUMN_NAME"/></td>
		  	<td>&#160;<xsl:value-of select="TYPE"/></td>
		  	<td>&#160;<xsl:value-of select="DBNAME"/></td>
		  	<td>&#160;<xsl:value-of select="KEY"/></td>
		  	<td>&#160;<xsl:value-of select="UPDATE"/></td>
		  	<td>&#160;<xsl:value-of select="VALIDATION"/></td>
		  	</tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>
  
  <xsl:for-each select="/CasualWriter/COLUMN_LAYOUT">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr>
        <td width="03%"><b>No</b></td>
        <td width="25%"><b>&#160;Column Name</b></td>
        <td width="30%"><b>&#160;Caption</b></td>
        <td width="05%"><b>&#160;TAB</b></td>
        <td width="20%"><b>&#160;Edit Style</b></td>
        <td width="20%"><b>&#160;Display Format</b></td>
      </tr>
      <xsl:for-each select="ITEM">
		  	<tr>
		  	<td><xsl:value-of select="NO"/></td>
		  	<td>&#160;<xsl:value-of select="COLUMN_NAME"/></td>
		  	<td>&#160;<xsl:value-of select="CAPTION"/></td>
		  	<td>&#160;<xsl:value-of select="TAB"/></td>
		  	<td>&#160;<xsl:value-of select="EDIT_STYLE"/></td>
		  	<td>&#160;<xsl:value-of select="DISPLAY_FORMAT"/></td>
		  	</tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>
  
  <xsl:for-each select="/CasualWriter/COMPUTE_COLUMN">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr>
        <td width="20%"><b>&#160;Compute Field</b></td>
        <td width="05%"><b>&#160;Type</b></td>
        <td width="55%"><b>&#160;Expression</b></td>
        <td width="20%"><b>&#160;Display Format</b></td>
      </tr>
      <xsl:for-each select="ITEM">
		  	<tr>
		  	<td>&#160;<xsl:value-of select="COMPUTE_FIELD"/></td>
		  	<td>&#160;<xsl:value-of select="TYPE"/></td>
		  	<td>&#160;<xsl:value-of select="EXPRESSION"/></td>
		  	<td>&#160;<xsl:value-of select="DISPLAY_FORMAT"/></td>
		  	</tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>

  <xsl:for-each select="/CasualWriter/NESTED_REPORT">
    <p>
    <table border="1" cellspacing="0" align="center" width="98%" bgcolor="#E4E4E4" 
           bordercolor="#000000" bordercolordark="#FFFFFF" bordercolorlight="#000000">
      <tr>
        <td width="20%"><b>&#160;Nested Report</b></td>
        <td width="15%"><b>&#160;Data Object</b></td>
        <td width="40%"><b>&#160;Retrieve Argument</b></td>
        <td width="30%"><b>&#160;Criteria</b></td>
      </tr>
      <xsl:for-each select="ITEM">
		  	<tr>
		  	<td>&#160;<xsl:value-of select="NAME"/></td>
		  	<td>&#160;<xsl:value-of select="DATA_OBJECT"/></td>
		  	<td>&#160;<xsl:value-of select="RETRIEVE_ARGUMENT"/></td>
		  	<td>&#160;<xsl:value-of select="CRITERIA"/></td>
		  	</tr>
      </xsl:for-each>
    </table>
    </p>
  </xsl:for-each>

</body>
</html>

</xsl:template>

</xsl:stylesheet>