package db1;
#===========================
# 1st Choice Perl Database
# (c)2000 Sabine Consulting
#===========================

use CGI qw(:standard :html);

sub new
{
	my $class = shift;
	my $self = ();
	my ($table_name) = @_;
	$self->{table_name} = $table_name;
	&ChangeFilename($self);

	bless $self, $class;
	return $self;
}
#===========================
# Read-Only Accessor Methods
#===========================
sub getfilename {$_[0]->{table_name}}
sub getrecordnumber {$_[0]->{recordnumber}+1}
sub getfieldnames {@{$_[0]->{FieldNames}}}
sub gettotalfields {$_[0]->{fields}}
sub gettotalrecords {$_[0]->{totalrecords}}
#===========================
# Name:		setfilename
# purpose:	set table_name
# input:	$self, $new_table_name
# output:	none
#===========================
sub setfilename
{
	my ($self, $new_table_name) = @_;
	$self->{table_name}= $new_table_name;
	&ChangeFilename($self)
}
#===========================
# Name:		getdescription
# purpose:	return an HTML string containing all datamembers
# input:	$self
# output:	$db_string
#===========================
sub getdescription
{
	my ($self) = @_;
	my ($i, $str1);

	$str1 = <<"EOP";
version = $self->{version}<br>
fields = $self->{fields}<br>
maxrecords = $self->{maxrecords}<br>
totalrecords = $self->{totalrecords}<br>
recordnumber = $self->{recordnumber}<br>
EOP
	for ($i = 0; $i < $self->{fields}; $i++) {	
		$str1 .= "FieldLengths[$i] = $self->{FieldLengths}[$i]<br>";
	}
	for ($i = 0; $i < $self->{fields}; $i++) {	
		$str1 .= "FieldNames[$i] = $self->{FieldNames}[$i]<br>";
	}
	for ($i = 0; $i < $self->{fields}; $i++) {	
		$str1 .= "ptrFieldStorage[$i] = $self->{ptrFieldStorage}[$i]<br>";
	}
	return ($str1);
}
#===========================
# Name:		select
# purpose:	set the WhereClause; reset recordnumber to 0.
# input:	$self, @where
# output:	none
#===========================
sub select
{
	my ($self, @where) = @_;
	$self->{recordnumber} = -1;	
	$self->{where} = \@where;
}
#===========================
# Name:		getrecord
# purpose:	return the current record (as an array)
# input:	$self
# output:	$aRecord
#===========================
sub getrecord
{
	my ($self) = @_;
	my ($a, $i, $j, $aRecord);

	&CheckForBOF($self);
	if (&eof($self)) {
		return;	
	}

	if (open (FH,$self->{table_name})) {
		for ($i = 0; $i < $self->{fields}; $i++) {
			seek(FH, $self->{ptrFieldStorage}[$i] + ($self->{FieldLengths}[$i] * $self->{recordnumber}), 0);
			read(FH, $j, $self->{FieldLengths}[$i]);
			@a=split(chr(0),$j);
			$aRecord[$i] = $a[0];
		}
	}
	close (FH);
	return (@aRecord);
}
#===========================
# Name:		append
# purpose:	add a new record
# input:	$self, @values
# output:	none
#===========================
sub append
{
	my ($cPtrRecords) = 12;
	my ($self, @values) = @_;
	my ($i);

	if ($self->{maxrecords}	== $self->{totalrecords}) {
		return;
	}
	if (open (FH,"+<$self->{table_name}")) {
		for ($i = 0; $i < $self->{fields}; $i++) {
			if (defined($values[$i])) {
				seek(FH, $self->{ptrFieldStorage}[$i] + ($self->{FieldLengths}[$i] * $self->{totalrecords}), 0);
				if (length($values[$i]) < $self->{FieldLengths}[$i]) {
					print FH $values[$i], chr(0);
				}
				else {
					print FH substr($values[$i], 0, $self->{FieldLengths}[$i]);
				}
			}		
		}	
		$self->{totalrecords}++;
		seek(FH, $cPtrRecords, 0);
		print FH pack("I1",$self->{totalrecords});
	}
	close (FH);
}
#===========================
# Name:		update
# purpose:	update the current record
# input:	$self, @values
# output:	none
#===========================
sub update
{
	my ($self, @values) = @_;
	my ($recordnumber) = $self->{recordnumber};
	
	&CheckForBOF($self);	
	if (&eof($self)) {
		return;	
	}
	if (open (FH,"+<$self->{table_name}")) {
		for ($i = 0; $i < $self->{fields}; $i++) {
			if (defined($values[$i])) {
				seek(FH, $self->{ptrFieldStorage}[$i] + ($self->{FieldLengths}[$i] * $recordnumber), 0);
				if (length($values[$i]) < $self->{FieldLengths}[$i]) {
					print FH $values[$i], chr(0);
				}
				else {
					print FH substr($values[$i], 0, $self->{FieldLengths}[$i]);
				}
			}		
		}	
	}
	close (FH);
}
#===========================
# Name:		find
# purpose:	find the next record that meets the 'where' criteria
# input:	$self
# output:	none
#===========================
sub find
{
	my ($self) = @_;
	my ($a, $i, $j, $where, $cont);
	my ($recordnumber) = $self->{recordnumber};
	if (&eof($self)) {
		return;	
	}
	$recordnumber++;
	@where = @{$self->{where}};
	if (open (FH,$self->{table_name})) {
		$cont = 1;
		while ($cont && $recordnumber != $self->{totalrecords}) {
			$cont = 0;
			for ($i = 0; $i < $self->{fields}; $i++) {
				if (defined($where[$i])) {
					seek(FH, $self->{ptrFieldStorage}[$i] + ($self->{FieldLengths}[$i] * $recordnumber), 0);
					read(FH, $j, $self->{FieldLengths}[$i]);
					@a=split(chr(0),$j);
					if ($where[$i] ne $a[0]) {
						$recordnumber++;
						$cont=1;
						last;
					}
				}
			}
		}
	}
	close (FH);
	$self->{recordnumber} = $recordnumber;
}
#===========================
# Name:		setrecordnumber
# purpose:	set the [recordnumber] member
# input:	$self, $recordnumber
# output:	none
#===========================
sub setrecordnumber
{
	my ($self, $recordnumber) = @_;
	if ($recordnumber >= 0 && $recordnumber < $self->{totalrecords}) {
		$self->{recordnumber} = $recordnumber;
	}
}
#===========================
# Name:		eof
# purpose:	determine if end-of-file has been reached
# input:	$self
# output:	1 if eof, otherwise 0
#===========================
sub eof
{
	my ($self) = @_;
	if ($self->{recordnumber} == $self->{totalrecords}) {
		return 1;	
	}
	return 0;
}
#===========================
# Name:		deleteall
# purpose:	delete all records which meets criteria
# input:	$self, @where
# output:	none
#===========================
sub deleteall
{
	my ($self, @where) = @_;
	my ($a, $i, $j, $nomatch);

	my ($recordnumber) = 0;
	if (open (FH,"+<$self->{table_name}")) {
		while ($recordnumber != $self->{totalrecords}) {
			$nomatch = 0;
			for ($i = 0; $i < $self->{fields}; $i++) {
				if (defined($where[$i])) {
					seek(FH, $self->{ptrFieldStorage}[$i] + ($self->{FieldLengths}[$i] * $recordnumber), 0);
					read(FH, $j, $self->{FieldLengths}[$i]);
					@a=split(chr(0),$j);
					if ($where[$i] ne $a[0]) {
						$nomatch=1;
						last;
					}
				}
			}
			if (!$nomatch) {
# Delete Record
				seek(FH, $self->{ptrFieldStorage}[0] + ($self->{FieldLengths}[0] * $recordnumber), 0);
				print FH chr(0);
			}
			$recordnumber++;
		}
	}
	close (FH);
}
#===========================
# Name:		insert
# purpose:	If a Deleted record exists, then Update. Otherwise, Append
# input:	$self, @values
# output:	none
#===========================
sub insert
{
	my ($self, @values) = @_;
	my ($j, $recordnumber, $found, $rn_saved);
	
	$recordnumber = 0;
	if (open (FH,$self->{table_name})) {
		$found = 0;
		while ($recordnumber != $self->{totalrecords}) {
			seek(FH, $self->{ptrFieldStorage}[0] + ($self->{FieldLengths}[0] * $recordnumber), 0);
			read(FH, $j, 1);
			if ($j == chr(0)) {
# Update Deleted Record
				$rn_saved = $self->{recordnumber};
				$self->{recordnumber} = $recordnumber;
				update($self, @values);
				$self->{recordnumber} = $rn_saved;
				$found = 1;
				last;
			}
			$recordnumber++;
		}
		if (!$found) {
# Append Record		
			append($self, @values);
		}
	}
	close (FH);
}
#*** INTERNAL ROUTINES ***
#===========================
# Name:		ChangeFilename
# purpose:	change table_name; reset all data members
# input:	$self
# output:	none
#===========================
sub ChangeFilename
{
	my ($buffer, $aNum1, $aNum2, $i, $fields, $str1, $adrFieldStorage);
	my ($cHeaderSize) = 16;
	my ($cFieldNameLength) = 64;

	my ($self) = @_;
	$self->{recordnumber} = -1;
	undef($self->{where});
	
	if (open (FH,$self->{table_name})) {
		read(FH,$buffer,$cHeaderSize);
		($self->{version}, $fields, $self->{maxrecords}, $self->{totalrecords})	 = unpack("I4",$buffer);
# Populate FieldLengths Arrays
		read(FH,$buffer,$fields * 4);
		for ($i = 0; $i < $fields; $i++) {
			$aNum1 = substr($buffer,$i*4, 4);
			$aNum2 = unpack("I1",$aNum1);
			$self->{FieldLengths}[$i] = $aNum2;
		}
# Populate FieldNames Array
		read(FH,$buffer,$fields * $cFieldNameLength);
		for ($i = 0; $i < $fields; $i++) {
			$self->{FieldNames}[$i] = substr($buffer,$i*$cFieldNameLength, $cFieldNameLength);
		}
# Populate ptrFieldStorage
		$adrFieldStorage = $cHeaderSize + ($fields * 4) + ($fields * $cFieldNameLength);
		for ($i = 0; $i < $fields; $i++) {
			$self->{ptrFieldStorage}[$i] = $adrFieldStorage;
			$adrFieldStorage += $self->{maxrecords} * $self->{FieldLengths}[$i];
		}
# Done reading fields
		$self->{fields} = $fields;
		&select($self);
		close (FH);
	}
}
#===========================
# Name:		CheckForBOF
# purpose:	If RecordNumber = -1, then change to 0
# input:	$self
# output:	none
#===========================
sub CheckForBOF() {
	my ($self) = @_;
	if ($self->{recordnumber} == -1) {
		$self->{recordnumber} = 0;
	}
}
;1
