// ------------------------------- //
// -------- start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: ustring.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 11/29/1996
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The UString class is a user-defined string class used to create
and manipulate null-terminated resizable character strings.
*/
// ----------------------------------------------------------- // 
#include <ctype.h>
#include "ustring.h"

UString &UString::operator=(const UString &s)
{
  if(this != &s) { // Prevent self assignment 
    SetString(s.sptr, s.s_length);
  }
  return *this;
}

UString::UString(unsigned bytes)
{
  sptr = new char[bytes+1];
  s_length = d_length = bytes;
  sptr[0] = 0;
}

void UString::Clear()
// Clear this string without freeing its memory segment.
{
  if(!sptr) return;
  s_length = 0;
  sptr[0] = 0;
}

int UString::SetString(const char *s, unsigned bytes)
// Set the string value for this object. This function will try to
// re-use the current memory segment allocated for this string before
// re-allocating memory for the string. Returns true if successful or
// false if an error occurs. NOTE: The UString class guarantees that
// each object is unique by storing a unique copy of the string with
// each object. This ensures that UString objects can be safely copy
// constructed, assigned, resized, and deleted by multiple threads.
// Multiple threads accessing shared memory segments must be handled
// by the application.
{
  // Calculate the length of this string if no bytes size is specified
  if(bytes == 0) bytes = strlen(s);
  
  if(sptr) { // Memory was previously allocated for this object
    if(d_length >= bytes) { // Try to reuse this space
      s_length = bytes;
      memmove(sptr, s, s_length);
      sptr[s_length] = '\0'; // Null terminate the string
      return 1;
    }
    else { // Must resize the string
      delete sptr; // Delete the previous copy and re-allocate memory
      s_length = d_length = 0;
    }
  }

  // Allocate memory for the string plus a null-terminator
  sptr = new char[bytes+1]; 
  if(!sptr) return 0; // Memory allocation error
  s_length = d_length = bytes;
  memmove(sptr, s, s_length); // Create a unique copy of this string 
  sptr[s_length] = '\0';      // Null terminate the string
  return 1;
}

int UString::resize(unsigned bytes, int keep)
// Resize the logical length of the buffer. If the
// "keep" variable is true the old data will be
// copied into the new space. By default the old
// data will not be deleted. Returns true if
// successful or false if an error occurs.
{
  // No additional memory has to be re-allocated
  if(d_length >= bytes) {
    s_length = bytes;
    return 1;
  }
  
  char *nsptr = new char[bytes+1];
  if(!nsptr) return 0;

  if((keep == 1) && (sptr != 0)) { // Copy old data into the new memory segment
    if(bytes < s_length) s_length = bytes;
    memmove(nsptr, sptr, s_length);
    nsptr[s_length] = 0; // Null terminate the string
  }

  if(sptr) delete sptr;        // Free the previously allocated memory
  sptr = nsptr;                // Point to new string
  s_length = d_length = bytes; // Record new allocated length
  return 1;
}
      
UString *UString::strdup()
// Returns a duplicate string object or a null value if an error
// occurs.
{
  return (UString *)new UString(sptr);
}

UString *UString::strdup() const
// Returns a duplicate string object or a null value if an error
// occurs.
{
  return (UString *)new UString(sptr);
}
  
unsigned UString::ReplaceString(const char *s, const char *replacement,
                                unsigned offset)
// Replace the specified string. Returns the number of strings
// replaced.
{
  if(!sptr) return 0;
  unsigned num_replaced = 0;
  
  while(1) {
    offset = Find(s, offset);
    if (offset == -1) break;
    DeleteAt(offset, strlen(s));
    InsertAt(offset, replacement);
    num_replaced++;
    offset += strlen(replacement);
  }
  return num_replaced;
}

unsigned UString::ReplaceString(char *s, char *replacement, unsigned offset)
{
  return ReplaceString((const char *)s, (const char *)replacement, offset);
}

unsigned UString::ReplaceChar(const char c, const char replacement,
                              unsigned offset)
// Replace the specified character. Returns the number of characters
// replaced in the string.
{
  if(!sptr) return 0;
  unsigned num_replaced = 0;
  unsigned i;
  char *start = sptr + offset;

  for(i = 0; i < s_length; i++) {
    if(start[i] == c) {
      start[i] = replacement;
      num_replaced++;
    }
  }

  return num_replaced;
}

int UString::ToUpper()
// Change all characters in the string to upper case.
// Returns true if successful.
{
  if(!sptr) return 0;
  unsigned bytes = s_length;
  char *start = sptr;
  
  while(bytes--) {
    *start = toupper(*start);
    start++;
  }

  return 1;
}

int UString::ToLower()
// Change all characters in the string to lower case.
// Returns true if successful.
{
  if(!sptr) return 0;
  unsigned bytes = s_length;
  char *start = sptr;
  
 while(bytes--) {
    *start = tolower(*start);
    start++;
  }

  return 1;
}

unsigned UString::FilterString(const char *s, unsigned offset)
// Filter the specified string from the object. Returns
// the number of strings filtered from the string.
{
  if(!sptr) return 0;
  unsigned num_replaced = 0;
  
  while(1) {
    offset = Find(s, offset);
    if (offset == -1) break;
    DeleteAt(offset, strlen(s));
    num_replaced++;
    offset++;
  }
  return num_replaced;
}

unsigned UString::FilterString(char *s, unsigned offset)
// Filter the specified string from the object. Returns
// the number of strings filtered from the string.
{
  return FilterString((const char *)s, offset);
}

unsigned UString::FilterChar(const char c, unsigned offset)
// Filter the specified character from the object. Returns
// the number of characters filtered from the string.
{
  char s[2]; // Define a two byte array (char + null terminator)
  s[0] = c;  // Character to be filtered
  s[1] = 0;  // Null-terminate the string so the strlen() function will work
  return FilterString((const char *)s, offset);
}

unsigned UString::TrimLeadingSpaces()
// Filter all leading spaces from a string.
// Returns the number of characters filtered.
{
  if(!sptr) return 0;
  unsigned i, num_l_spaces = 0;
  char *start = sptr;

  for(i = 0; i < s_length; i++) {
    if(!isspace(start[i])) break;
    num_l_spaces++;
  }

  if(num_l_spaces > 0) DeleteAt(0, num_l_spaces);

  return num_l_spaces;
}

unsigned UString::TrimTrailingSpaces()
// Filter all Trailing spaces from a string.
// Returns the number of characters filtered.
{
  if(!sptr) return 0;
  char *start = sptr;
  unsigned i, num_t_spaces = 0;
  
  for(i = (s_length - 1); i != 0; i--) {
    if(!isspace(start[i])) break;
    num_t_spaces++;
  }

  if(num_t_spaces > 0) DeleteAt((s_length - num_t_spaces), num_t_spaces);
  return num_t_spaces;
}

int UString::DeleteAfter(const char *s)
// Delete everything after the specified string.
// Returns true if successful.
{
  if(!sptr) return 0;
  unsigned bytes = s_length;

  unsigned offset = Find(s);
  if(offset == -1) return 0;
  offset += strlen(s); // Keep the delimiting string
  DeleteAt(offset, (bytes - offset));
  return 1;
}

int UString::DeleteBefore(const char *s)
// Delete everything before the specified string.
// Returns true if successful.
{
  if(!sptr) return 0;

  unsigned offset = Find(s);
  if(offset == -1) return 0;
  DeleteAt(0, offset);
  return 1;
}

int UString::DeleteAfterIncluding(const char *s)
// Delete everything after the specified string
// including the string. Returns true if successful.
{
  if(!sptr) return 0;
  unsigned bytes = s_length;

  unsigned offset = Find(s);
  if(offset == -1) return 0;
  DeleteAt(offset, (bytes - offset));
  return 1;
}

int UString::DeleteBeforeIncluding(const char *s)
// Delete everything before the specified string
// including the string. Returns true if successful.
{
  if(!sptr) return 0;

  unsigned offset = Find(s);
  if(offset == -1) return 0;
  DeleteAt(0, offset+strlen(s));
  return 1;
}

int UString::DeleteAfterLast(const char *s)
// Deletes everything after the last occurrence
// of the specified string. Return true if the
// any characters were deleted.
{
  if(!sptr) return 0;
  unsigned offset = 0;
  unsigned index = 0;
  unsigned bytes = s_length;
  
  while(1) { 
    offset = Find(s, offset);
    if(offset != -1) index = offset;
    if(offset == -1) break;
    offset++;
  }
  if(index > 0) {
    index += strlen(s); // Keep the specified string
    DeleteAt(index, (bytes - index));
  }
  return 1;
}

int UString::DeleteAfterLastIncluding(const char *s)
// Deletes everything after the last occurrence
// of the specified string. Return true if the
// any characters were deleted.
{
  if(!sptr) return 0;
  unsigned offset = 0;
  unsigned index = 0;
  unsigned bytes = s_length;
  
  while(1) { 
    offset = Find(s, offset);
    if(offset != -1) index = offset;
    if(offset == -1) break;
    offset++;
  }
  if(index > 0) DeleteAt(index, (bytes - index)); 
  return 1;
}

int UString::DeleteBeforeLast(const char *s)
// Deletes everything before the last occurrence
// of the specified string. Return true if the
// any characters were deleted.
{
  if(!sptr) return 0;
  unsigned offset = 0;
  unsigned index = 0;
  
  while(1) { 
    offset = Find(s, offset);
    if(offset != -1) index = offset;
    if(offset == -1) break;
    offset++;
  }

  if(index > 0) DeleteAt(0, index);
  return 1;
}

int UString::DeleteBeforeLastIncluding(const char *s)
// Deletes everything before the last occurrence
// of the specified string. Return true if the
// any characters were deleted.
{
  if(!sptr) return 0;
  unsigned offset = 0;
  unsigned index = 0;
  
  while(1) { 
    offset = Find(s, offset);
    if(offset != -1) index = offset;
    if(offset == -1) break;
    offset++;
  }
  if(index > 0) DeleteAt(0, (index + strlen(s)));
  return 1;
}

unsigned UString::FindLast(const char *s)
// Returns index of the last occurrence of string char *s   
// Returns -1 if the pattern is not found
{
  if(!sptr) return 0;
  unsigned i;
  char *end = sptr + s_length;
  char *pattern = (char *)s; 
  pattern += (strlen(s) - 1);
  
  for(i = s_length; i != 0; i--) {
    if(*end == 0) end--;         // Skip over the null terminator
    if (*end == *pattern) {
      pattern--;
      if(*pattern == 0) return i; // pattern was found
    }
    else {
      pattern = (char *)s;
      pattern += (strlen(s) - 1);
    }

    end--;
  }

  return -1; // No match was found
}

unsigned UString::FindLast(char *s)
// Returns index of the last occurrence of string char *s   
// Returns -1 if the pattern is not found
{
  if(!sptr) return 0;
  unsigned i;
  char *end = sptr + s_length;
  char *pattern = s; 
  pattern += (strlen(s) - 1);
  
  for(i = s_length; i != 0; i--) {
    if(*end == 0) end--;         // Skip over the null terminator
    if (*end == *pattern) {
      pattern--;
      if(*pattern == 0) return i; // pattern was found
    }
    else {
      pattern = s;
      pattern += (strlen(s) - 1);
    }

    end--;
  }

  return -1; // No match was found
}

unsigned UString::Find(char *s, unsigned offset)
// Returns index of first occurrence of pattern char *s   
// Returns -1 if the pattern is not found.
{
  char *start = sptr + offset; // start of string data
  char *next = start;          // next string element
  char *pattern = s;           // next pattern element
  unsigned i = offset;         // next string element index
  
  while(i < s_length && *pattern) {
    if(*next == *pattern) {
      pattern++;
      if(*pattern == 0) return i; // pattern was found
      next++;
    }
    else {
      i++;
      start++;
      next = start;
      pattern = s;
    }
  }
  return -1; // No match was found
}

unsigned UString::IFind(char *s, unsigned offset)
// Returns index of first occurrence of pattern char *s
// starting at specified offset using a case insensitive
// compare. Returns -1 if the pattern is not found.
{
  char *start = sptr + offset; // start of string data
  char *next = start;          // next string element
  char *pattern = s;           // next pattern element
  unsigned i = offset;         // next string element index
  
  while(i < s_length && *pattern) {
    if (tolower(*next) == tolower(*pattern)) {
      pattern++;
      if(*pattern == 0) return i; // pattern was found
      next++;
    }
    else {
      i++;
      start++;
      next = start;
      pattern = s;
    }
  }
  return -1; // No match was found
}

unsigned UString::Find(char *s, unsigned bytes, unsigned offset) const
// Returns index of first occurrence of pattern char *s   
// Returns -1 if the pattern is not found
{
  char *start = sptr + offset; // start of string data
  char *next = start;          // next string element
  char *pattern = s;           // next pattern element
  unsigned i = offset, j = 1;  // String and pattern indexes
  
  while(i < s_length && j <= bytes) {
    if (*next == *pattern) { // Matching character
      if(j == bytes) return i; // Entire match was found
      next++; pattern++; j++;
    }
    else { // Try next spot in string
      i++;
      start++;
      next = start;
      pattern = s; j = 1;
    }
  }
  return -1; // No match was found
}

unsigned UString::IFind(char *s, unsigned bytes, unsigned offset) const
// Returns index of first occurrence of pattern char *s starting at 
// specified offset using a case insensitive compare. Returns -1
// if the pattern is not found.
{
  char *start = sptr + offset; // start of string data
  char *next = start;          // next string element
  char *pattern = s;           // next pattern element
  unsigned i = offset, j = 1;  // String and pattern indexes
  
  while(i < s_length && j <= bytes) {
    if (tolower(*next) == tolower(*pattern)) {
      if(j == bytes) return i; // Entire match was found
      next++; pattern++; j++;
    }
    else { // Try next spot in string
      i++;
      start++;
      next = start;
      pattern = s; j = 1;
    }
  }
  return -1; // No match was found
}

unsigned UString::DeleteAt(unsigned position, unsigned bytes)
// Deletes a specifed number of bytes starting at the
// specified position. Returns the total number of bytes
// deleted or zero if an error occurs.
{
  unsigned end;
  
  if((position < s_length) && (bytes != 0)) {
    end = position + bytes;
    if(end > s_length) end = s_length;
    bytes = end - position;
    // Move the elements up to take their place
    memmove(sptr+position, sptr+end, s_length-end);
    s_length -= bytes;
    sptr[s_length] = 0; // Ensure null termination
  }
  else
    bytes = 0;

  return bytes;
}

unsigned UString::InsertAt(unsigned position, const char *s, unsigned bytes)
// Insert a specified number of bytes a the current position, keeping
// the current string intact. Returns the number of bytes inserted or
// zero if an error occurs.
{
  unsigned old_length = s_length; // Record the current string length
  
  // Ensure that there are enough bytes to hold the insertion
  if(!resize(bytes+s_length)) return 0;

  if(position < old_length) { // Move the data in the middle of the string
    memmove(sptr+position+bytes, sptr+position, old_length-position);
  }
  
  if(position > s_length) position = s_length; // Stay in bounds
  memmove(sptr+position, s, bytes);
  sptr[s_length] = 0; // Ensure null termination
  return bytes;
}

unsigned UString::ReplaceAt(unsigned position, const char *s, unsigned bytes)
// Replace a specified number of bytes at the specified position. Returns
// the number of bytes replaced of zero if an error occurs.
{
  if(position > s_length) position = s_length; // Stay in bounds
  unsigned end = s_length-position;
  if(bytes > end) { // There are not enough bytes to hold the replacement
    unsigned needed = bytes-end;
    if(!resize(s_length + needed)) return 0;
  }
  memmove(sptr+position, s , bytes);
  sptr[s_length] = 0; // Ensure null termination
  return bytes;
}

ostream &operator<<(ostream &os, const UString &s)
{
  if(!s.sptr) return os; // No memory has been allocated for this string
  return os.write(s.sptr, s.s_length);
}

istream &operator>>(istream &os, UString &s)
{
  if(!s.sptr) {
    // No memory has been allocated for this string so allocate memory for
    // the characters extracted from the input stream
    s.sptr = new char[81];
    if(!s.sptr) return os; // Memory allocation error
    s.s_length = 0; s.d_length = 81;
    s.sptr[0] = 0;
  }

  os >> setw(s.d_length) >> s.sptr;
  s.s_length = strlen(s.sptr);
  return os;
}

void UString::operator+=(const char c)
{
  Cat((const char *)&c, 1);
}

int StringCompare(const UString &a, const UString &b)
// Returns -1 if a < b, 0 if a == b, and 1 if a > b
{
  unsigned an = a.s_length;
  unsigned bn = b.s_length;
  unsigned sn = (an < bn) ? an : bn;
  unsigned char *ap = (unsigned char *)a.sptr;
  unsigned char *bp = (unsigned char *)b.sptr;

  for(unsigned i = 0; i < sn; i++) {
    if(*ap < *bp) return -1;
    if(*ap++ > *bp++) return 1;
  }

  if(an == bn) return 0;
  if(an < bn) return -1;
  return 1;
}

UString operator+(const UString &a, const UString &b) 
{
  UString buf(a);
  buf += b;
  return buf;
}

UString operator+(const char *s, const UString &b) 
{
  UString buf(s);
  buf += b;
  return buf;
}

UString operator+(const UString &a, const char *s) 
{
  UString buf(s);
  buf += a;
  return buf;
}

char &UString::operator[](unsigned i) 
{
  if(i >= s_length) i = s_length; // If not in bounds truncate to s_length
  return sptr[i];
}

char &UString::operator[](unsigned i) const
{
  if(i >= s_length) i = s_length; // If not in bounds truncate to s_length
  return sptr[i];
}

int operator==(const UString &a, const UString &b) 
{
  return StringCompare(a, b) == 0;
}

int operator==(const char *s, const UString &b) 
{
  UString a(s);
  return StringCompare(a, b) == 0;
}

int operator==(const UString &a, const char *s) 
{
  UString b(s);
  return StringCompare(a, b) == 0;
}

int operator!=(const UString &a, const UString &b) 
{
  return StringCompare(a, b) != 0;
}

int operator!=(const char *s, const UString &b) 
{
  UString a(s);
  return StringCompare(a, b) != 0;
}

int operator!=(const UString &a, const char *s) 
{
  UString b(s);
  return StringCompare(a, b) != 0;
}

int operator>(const UString &a, const UString &b) 
{
  return StringCompare(a, b) > 0;
}

int operator>(const char *s , const UString &b) 
{
  UString a(s);
  return StringCompare(a, b) > 0;
}

int operator>(const UString &a, const char *s) 
{
  UString b(s);
  return StringCompare(a, b) > 0;
}

int operator>=(const UString &a, const UString &b) 
{
  return StringCompare(a, b) >= 0;
}
  
int operator>=(const char *s, const UString &b) 
{
  UString a(s);
  return StringCompare(a, b) >= 0;
}

int operator>=(const UString &a, const char *s) 
{
  UString b(s);
  return StringCompare(a, b) >= 0;
}

int operator<(const UString &a, const UString &b) 
{
  return StringCompare(a, b) < 0;
}

int operator<(const char *s, const UString &b) 
{
  UString a(s);
  return StringCompare(a, b) < 0;
}

int operator<(const UString &a, const char *s) 
{
  UString b(s);
  return StringCompare(a, b) < 0;
}

int operator<=(const UString &a, const UString &b) 
{
  return StringCompare(a, b) <= 0;
}

int operator<=(const char *s, const UString &b) 
{
  UString a(s);
  return StringCompare(a, b) <= 0;
}

int operator<=(const UString &a, const char *s) 
{
  UString b(s);
  return StringCompare(a, b) <= 0;
}

// General-purpose string routines that need to be ported from UNIX to DOS
// -----------------------------------------------------------------------
int CaseICmp(const UString &s1, const UString &s2)
// Compare two UString objects without regard to the case of the letters
{
#if defined (__DOS__) || defined (__WIN32__)
  // Case-insensitive compare for most DOS/Windows Compilers
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__VISUALC__) || ( defined(__MWERKS__) && defined(__INTEL__) )
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__SC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__SALFORDC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__BORLANDC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__WATCOMC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined (__UNIX__) || defined(__GNUWIN32__)
  // Case-insensitive compare for most UNIX Compilers
  return strcasecmp(s1.c_str(), s2.c_str());
#else
    register char c1, c2;
    const char *str1 = s1.c_str(); const char *str2 = s2.c_str();
    do {
      c1 = tolower(*str1++);
      c2 = tolower(*str2++);
    } while ( c1 && (c1 == c2) );

    return c1 - c2;
#endif 
}

int CaseICmp(UString &s1, UString &s2)
// Compare two UString objects without regard to the case of the letters
{
#if defined (__DOS__) || defined (__WIN32__) 
  // Case-insensitive compare for most DOS/Windows Compilers
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__VISUALC__) || ( defined(__MWERKS__) && defined(__INTEL__) )
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__SC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__SALFORDC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__BORLANDC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined(__WATCOMC__)
  return stricmp(s1.c_str(), s2.c_str());
#elif defined (__UNIX__) || defined(__GNUWIN32__)
  // Case-insensitive compare for most UNIX Compilers
  return strcasecmp(s1.c_str(), s2.c_str());
#else
    register char c1, c2;
    char *str1 = s1.c_str(); char *str2 = s2.c_str();
    do {
      c1 = tolower(*str1++);
      c2 = tolower(*str2++);
    } while ( c1 && (c1 == c2) );

    return c1 - c2;
#endif 
}

int CaseICmp(const UString &s1, const char *s)
{
  const UString s2(s);
  return CaseICmp(s1, s2);
}

int CaseICmp(const char *s, const UString &s2)
{
  const UString s1(s);
  return CaseICmp(s1, s2);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
