# Include file used for all project makefiles

# Build dependency rules
# ===============================================================
THELPERS_DEP = ../../include/thrtypes.h ../../include/thelpers.h

THRAPIW_DEP = ../../include/thrtypes.h ../../include/thrapiw.h \
	../../include/gthreadt.h ../../include/gxthread.h \
	../../include/thrpool.h ../../include/gxmutex.h \
	../../include/gxcond.h ../../include/thelpers.h

THRPOOL_DEP = ../../include/thrtypes.h ../../include/thrpool.h \
	../../include/gthreadt.h

GXCOND_DEP = ../../include/thrtypes.h ../../include/gxcond.h \
	../../include/thelpers.h ../../include/gxmutex.h

GXMUTEX_DEP = ../../include/thrtypes.h ../../include/gxmutex.h \
	../../include/thelpers.h

GXSEMA_DEP = ../../include/thrtypes.h ../../include/gxsema.h \
	../../include/thelpers.h

GXTHREAD_DEP = ../../include/thrtypes.h  ../../include/gxthread.h \
	../../include/gthreadt.h ../../include/thrapiw.h \
	../../include/thrpool.h

GTHREADT_DEP = ../../include/thrtypes.h ../../include/gthreadt.h \
	../../include/gxthread.h ../../include/thrpool.h \
	../../include/gxcond.h ../../include/gxmutex.h \
	../../include/thelpers.h

GXSOCKET_DEP = ../../include/gxsocket.h \
	../../include/gxstypes.h

HTTPSERV_DEP = httpserv.h \
	../../include/gxsocket.h \
	../../include/gxstypes.h \
	../../include/thrtypes.h ../../include/thelpers.h \
	../../include/gxthread.h ../../include/gthreadt.h \
	../../include/thrpool.h ../../include/gxmutex.h \
	../../include/gxcond.h ../../include/gxsema.h

SERVER_DEP = httpserv.h \
	../../include/gxsocket.h \
	../../include/gxstypes.h \
	../../include/thrtypes.h ../../include/thelpers.h \
	../../include/gxthread.h ../../include/gthreadt.h \
	../../include/thrpool.h ../../include/gxmutex.h \
	../../include/gxcond.h ../../include/gxsema.h

LEAKTEST_DEP = ../../include/leaktest.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

thrapiw$(OBJ_EXT):	../../src/thrapiw.cpp $(THRAPIW_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/thrapiw.cpp

thelpers$(OBJ_EXT):	../../src/thelpers.cpp $(THELPERS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/thelpers.cpp

thrpool$(OBJ_EXT):	../../src/thrpool.cpp $(THRPOOL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/thrpool.cpp

gxthread$(OBJ_EXT):	../../src/gxthread.cpp $(GXTHREAD_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/gxthread.cpp

gthreadt$(OBJ_EXT):	../../src/gthreadt.cpp $(GTHREADT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/gthreadt.cpp

gxmutex$(OBJ_EXT):	../../src/gxmutex.cpp $(GXMUTEX_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/gxmutex.cpp

gxcond$(OBJ_EXT):	../../src/gxcond.cpp $(GXCOND_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/gxcond.cpp

gxsema$(OBJ_EXT):	../../src/gxsema.cpp $(GXSEMA_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/gxsema.cpp

gxsocket$(OBJ_EXT):	../../src/gxsocket.cpp $(GXSOCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	../../src/gxsocket.cpp

httpserv$(OBJ_EXT):	httpserv.cpp $(HTTPSERV_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) httpserv.cpp

server$(OBJ_EXT):	server.cpp $(SERVER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) server.cpp

leaktest$(OBJ_EXT):	../../src/leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) ../../src/leaktest.cpp

# Make the executable
OBJECTS = gxsocket$(OBJ_EXT) httpserv$(OBJ_EXT) server$(OBJ_EXT) \
	gxthread$(OBJ_EXT) gxmutex$(OBJ_EXT) thrpool$(OBJ_EXT) \
	gthreadt$(OBJ_EXT) gxcond$(OBJ_EXT) gxsema$(OBJ_EXT) \
	thrapiw$(OBJ_EXT) thelpers$(OBJ_EXT) leaktest$(OBJ_EXT)
# ===============================================================
