unit HBinary4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls, Buttons;

type
  TForm4 = class(TForm)
    Panel1: TPanel;
    Label3: TLabel;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    CheckBox2: TCheckBox;
    RadioGroup2: TRadioGroup;
    Edit1: TEdit;
    Button1: TButton;
    CheckBox3: TCheckBox;
    SpinEdit7: TSpinEdit;
    Panel5: TPanel;
    CheckBox5: TCheckBox;
    Panel6: TPanel;
    Panel7: TPanel;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    RadioGroup1: TRadioGroup;
    Button8: TButton;
    ColorDialog1: TColorDialog;
    OpenDialog1: TOpenDialog;
    CheckBox1: TCheckBox;
    procedure BitBtn1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Panel5Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure Panel7Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure SpinEdit7Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);  private
    procedure FontMe;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation

uses HBinary1, HBinary2, HBinary3;

{$R *.DFM}

procedure TForm4.BitBtn1Click(Sender: TObject);
begin
   Application.HelpFile := ExtractFilePath(Application.ExeName)+'BinaryClock3.hlp';
   Application.HelpJump('Contents');
end;

procedure TForm4.Button2Click(Sender: TObject);
begin
   {Color of ON led...}
   ColorDialog1.Color:=LEDOnIn;
   if (ColorDialog1.Execute) then LEDOnIn :=ColorDialog1.Color;
   Form1.RepaintForm;
end;

procedure TForm4.BitBtn2Click(Sender: TObject);  {Resets LED to default color and size}
begin
   Backgrnd:=clBlack;
   LedOnIn:=clRed;
   LedOnOut:=clMaroon;
   LedOffIn:=$00000055;
   LedOffOut:=$11111122;
   HighLightOn:=clWhite;
   HighLightOff:=clSilver;
   LEDSize:=16;
   Form4.SpinEdit7.Value:=LEDSize;
   Form1.RepaintForm;
end;


procedure TForm4.Panel5Click(Sender: TObject);
begin
  Halt;
end;

procedure TForm4.CheckBox3Click(Sender: TObject);
begin
   If (CheckBox3.Checked) then Moveable:=true
   else Moveable:=false;
end;


procedure TForm4.RadioGroup2Click(Sender: TObject);
begin
   If (RadioGroup2.ItemIndex=0) then Back:=0;
   If (RadioGroup2.ItemIndex=1) then Back:=1;
end;

procedure TForm4.Edit1Change(Sender: TObject);
begin
  PicStr:=Edit1.Text;
end;

procedure TForm4.FormCreate(Sender: TObject);
begin

  SpinEdit7.Value:=LEDSize;

  if (LeastTop) then CheckBox7.Checked:=true else CheckBox7.Checked:=false;
  if (HideIt) then CheckBox8.Checked:=true else CheckBox8.Checked:=false;

  if (Moveable) then CheckBox3.Checked:=true else CheckBox3.Checked:=false;
  if (Vertical) then CheckBox2.Checked:=true else CheckBox2.Checked:=false;
  if (Seconds) then CheckBox5.Checked:=true else CheckBox5.Checked:=false;
  if (SmallFont) then CheckBox1.Checked:=true else CheckBox1.Checked:=false;

  RadioGroup1.ItemIndex:=OnTop;

  if (Military=3) then Form4.CheckBox6.Checked:=false
  else Form4.CheckBox6.Checked:=true;

  if (Back=0) then Form4.RadioGroup2.ItemIndex:=0;
  if (Back=1) then
      begin
         Form4.RadioGroup2.ItemIndex:=1;
         Form4.Edit1.Text:=PicStr;
      end;
   Edit1.Text:=PicStr;

end;

procedure TForm4.CheckBox5Click(Sender: TObject);
begin
   if (CheckBox5.Checked) then Vertical:=true
   else Vertical:=false;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.Panel7Click(Sender: TObject);
var
   I,J : integer;
begin
   Form1.Timer1.Enabled:=false;
   OldBStr:='0000000000000000000000000';
   For I := 0 to 2 do
      For J := 0 to 5 do
         begin
            ImageOn[I,J]:=True;
            Form1.SwitchLights(I,J);
         end;
   Form1.Timer1.Enabled:=true;
   if (Form4.Visible) then Form1.RepaintForm;
end;



procedure TForm4.Button1Click(Sender: TObject);
begin
   if OpenDialog1.Execute then Edit1.Text:=OpenDialog1.Filename;
end;

procedure TForm4.CheckBox2Click(Sender: TObject);
begin
   if (CheckBox2.Checked) then Seconds:=true
   else Seconds:=false;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.CheckBox6Click(Sender: TObject);
begin
   If (CheckBox6.Checked) then Military:=4
   else Military:=3;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.CheckBox7Click(Sender: TObject);
begin
   if (CheckBox7.Checked) then LeastTop:=true else LeastTop:=false;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.CheckBox8Click(Sender: TObject);
begin
   if (CheckBox8.Checked) then
      begin
         HideIt:=true;
         ShowWindow(Application.Handle,SW_HIDE);
      end
   else
      begin
          HideIt:=false;
          ShowWindow(Application.Handle,SW_SHOW);
      end;
end;

procedure TForm4.Button3Click(Sender: TObject);
begin
   {Color of ON led...}
   ColorDialog1.Color:=LEDOffIn;
   if (ColorDialog1.Execute) then LEDOffIn:=ColorDialog1.Color;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.Button4Click(Sender: TObject);
begin
   {Color of ON led...}
   ColorDialog1.Color:=LEDOnOut;
   if (ColorDialog1.Execute) then LEDOnOut:=ColorDialog1.Color;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.Button5Click(Sender: TObject);
begin   {Color of ON led...}
   ColorDialog1.Color:=LEDOffOut;
   if (ColorDialog1.Execute) then LEDOffOut:=ColorDialog1.Color;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.Button6Click(Sender: TObject);
begin
   ColorDialog1.Color:=HighLightOn;
   if (ColorDialog1.Execute) then HighLightOn:=ColorDialog1.Color;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.Button7Click(Sender: TObject);
begin
   ColorDialog1.Color:=HighLightOff;
   if (ColorDialog1.Execute) then HighLightOff:=ColorDialog1.Color;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.SpinEdit7Change(Sender: TObject);
begin
   if (Form4.visible) then LedSize:=SpinEdit7.Value;
end;

procedure TForm4.RadioGroup1Click(Sender: TObject);
begin
   OnTop:=RadioGroup1.ItemIndex;
   if (OnTop=0) then
      begin
         SetWindowPos(Form1.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form2.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form3.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
      end;
   if (OnTop=1) then
      begin
         SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form2.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form3.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
      end;
   if (OnTop=2) then
      begin
         SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form2.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form3.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form1.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form2.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form3.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
      end;
end;

procedure TForm4.Button8Click(Sender: TObject);
begin
   {Color of background...}
   ColorDialog1.Color:=BackGrnd;
   if (ColorDialog1.Execute) then BackGrnd :=ColorDialog1.Color;
   if (Form4.Visible) then Form1.RepaintForm;
end;

procedure TForm4.FontMe;
var
   I : integer;
begin
   if (SmallFont) then
      begin
         for I := 0 to ComponentCount -1 do
            begin
               if Components[I] is TButton then
                  begin
                     TButton(Components[I]).Font.Name:='SERIFE.FON';
                     TButton(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TPanel then
                  begin
                     TPanel(Components[I]).Font.Name:='SERIFE.FON';
                     TPanel(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TLabel then
                  begin
                     TLabel(Components[I]).Font.Name:='SERIFE.FON';
                     TLabel(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TBitBtn then
                  begin
                     TBitBtn(Components[I]).Font.Name:='SERIFE.FON';
                     TBitBtn(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TCheckBox then
                  begin
                     TCheckBox(Components[I]).Font.Name:='SERIFE.FON';
                     TCheckBox(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TRadioGroup then
                  begin
                     TRadioGroup(Components[I]).Font.Name:='SERIFE.FON';
                     TRadioGroup(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TEdit then
                  begin
                     TEdit(Components[I]).Font.Name:='SERIFE.FON';
                     TEdit(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TButton then
                  begin
                     TButton(Components[I]).Font.Name:='SERIFE.FON';
                     TButton(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TSpinEdit then
                  begin
                     TSpinEdit(Components[I]).Font.Name:='SERIFE.FON';
                     TSpinEdit(Components[I]).Font.Size:=6;
                  end;
               if Components[I] is TGroupBox then
                  begin
                     TGroupBox(Components[I]).Font.Name:='SERIFE.FON';
                     TGroupBox(Components[I]).Font.Size:=6;
                  end;
            end;
      end
   else
      begin
         for I := 0 to ComponentCount -1 do
            begin
               if Components[I] is TButton then
                  begin
                     TButton(Components[I]).Font.Name:='SSERIFE.FON';
                     TButton(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TPanel then
                  begin
                     TPanel(Components[I]).Font.Name:='SSERIFE.FON';
                     TPanel(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TLabel then
                  begin
                     TLabel(Components[I]).Font.Name:='SSERIFE.FON';
                     TLabel(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TBitBtn then
                  begin
                     TBitBtn(Components[I]).Font.Name:='SSERIFE.FON';
                     TBitBtn(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TCheckBox then
                  begin
                     TCheckBox(Components[I]).Font.Name:='SSERIFE.FON';
                     TCheckBox(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TRadioGroup then
                  begin
                     TRadioGroup(Components[I]).Font.Name:='SSERIFE.FON';
                     TRadioGroup(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TEdit then
                  begin
                     TEdit(Components[I]).Font.Name:='SSERIFE.FON';
                     TEdit(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TButton then
                  begin
                     TButton(Components[I]).Font.Name:='SSERIFE.FON';
                     TButton(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TSpinEdit then
                  begin
                     TSpinEdit(Components[I]).Font.Name:='SSERIFE.FON';
                     TSpinEdit(Components[I]).Font.Size:=8;
                  end;
               if Components[I] is TGroupBox then
                  begin
                     TGroupBox(Components[I]).Font.Name:='SSERIFE.FON';
                     TGroupBox(Components[I]).Font.Size:=8;
                  end;
            end;
      end;
end;

procedure TForm4.CheckBox1Click(Sender: TObject);
begin
   if (CheckBox1.Checked) then SmallFont:=true else SmallFont:=false;
   FontMe;
   if (Form4.Visible) then Form4.Refresh;
end;

procedure TForm4.FormActivate(Sender: TObject);
begin
   FontMe;
end;

end.
