/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicencePanel
extends IzPanel
implements ActionListener {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private String licence;
    private JLabel infoLabel;
    private JTextArea textArea;
    private JLabel agreeLabel;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;
    private JScrollPane scroller;

    private void loadLicence() {
        try {
            int n;
            InputStream inputStream = this.parent.getResource("LicencePanel.licence");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[5120];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.licence = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            this.licence = "Error : could not load the licence text !";
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }

    public LicencePanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setLayout(this.layout);
        this.loadLicence();
        this.infoLabel = new JLabel(installerFrame.langpack.getString("LicencePanel.info"), installerFrame.icons.getImageIcon("history"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 0, 2, 1, 1.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        this.textArea = new JTextArea(this.licence);
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
        this.scroller = new JScrollPane(this.textArea);
        installerFrame.buildConstraints(this.gbConstraints, 0, 1, 2, 1, 1.0, 1.0);
        this.gbConstraints.anchor = 10;
        this.gbConstraints.fill = 1;
        this.layout.addLayoutComponent(this.scroller, this.gbConstraints);
        this.add(this.scroller);
        this.agreeLabel = new JLabel(installerFrame.langpack.getString("LicencePanel.agree"), installerFrame.icons.getImageIcon("help"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 2, 2, 1, 1.0, 0.0);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.agreeLabel, this.gbConstraints);
        this.add(this.agreeLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.yesRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.yes"), false);
        buttonGroup.add(this.yesRadio);
        installerFrame.buildConstraints(this.gbConstraints, 0, 3, 1, 1, 0.5, 0.0);
        this.gbConstraints.anchor = 18;
        this.layout.addLayoutComponent(this.yesRadio, this.gbConstraints);
        this.add(this.yesRadio);
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.no"), false);
        buttonGroup.add(this.noRadio);
        installerFrame.buildConstraints(this.gbConstraints, 1, 3, 1, 1, 0.5, 0.0);
        this.gbConstraints.anchor = 12;
        this.layout.addLayoutComponent(this.noRadio, this.gbConstraints);
        this.add(this.noRadio);
        this.noRadio.addActionListener(this);
    }
}

