<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
     <TITLE>Edit Suppliers</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[


function loadPO(LINK, PO) {
  var features = "scrollbars=yes,resizable=yes";
  var newlink = LINK + "?disValue=811&PONUMBER=" + PO; // SINGLE.PONumber; 
  var newLayer = open(newlink,"PO",features);
}

]]>
</xsl:comment>
</SCRIPT>


<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>


<CENTER><H1>Lookup PO</H1></CENTER><P></P>
<P></P>

<FORM NAME="SINGLE">
<!-- <xsl:attribute name="ACTION">javascript:loadPO(&quot;<xsl:value-of select="MSI/LAYOUT/SERVLET"/>&quot;,document.SINGLE.PONumber.value);</xsl:attribute>	-->

<TABLE CELLPADDING="2" WIDTH="100%">
<TR><TD WIDTH="30%" VALIGN="TOP">Please Enter PO: </TD>
<TD WIDTH="70%" VALIGN="TOP">
<INPUT TYPE="text" NAME="PONumber" VALUE=""></INPUT>
</TD></TR>

<INPUT TYPE="HIDDEN" NAME="golink"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute></INPUT>

<TR><TD COLSPAN="2">
<INPUT TYPE="BUTTON" NAME="Lookup PO" VALUE="Lookup PO">
    <xsl:attribute name="onClick">loadPO(
        '<xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/SERVLET"/>', 
        PONumber.value)
    </xsl:attribute>
</INPUT>

</TD></TR></TABLE>
</FORM>

<FORM NAME="QUERY">
<P/>
<H1>Lookup PO with Query:</H1>

<TABLE>
<TR>
	 <xsl:choose>
	 <xsl:when test="MSI/REPLIST/REP[.!='']">
	<TH>Select Rep</TH>
	 </xsl:when>
	 </xsl:choose>			
	
	<TH>Select Supplier</TH>
	<TH>Select Customer</TH>
</TR>

<TR>

<xsl:choose>
<xsl:when test="MSI/REPLIST/REP[.!='']">

<TD> 
<SELECT NAME="REP">

<OPTION VALUE="all">
Search All Reps 
</OPTION>

<xsl:for-each select="MSI/REPLIST/REP">
<xsl:sort select="FIRSTNAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="USERID"/></xsl:attribute><xsl:value-of select="FIRSTNAME"/><BR/><xsl:value-of select="LASTNAME"/>
</OPTION>
</xsl:for-each>
</SELECT>

</TD>
</xsl:when>
</xsl:choose>			


<TD> 
<SELECT NAME="SUPPLIER">

<OPTION VALUE="all">
Search All Suppliers 
</OPTION>

<xsl:for-each select="MSI/SUPLIST/SUP">
<xsl:sort select="SUPNAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="c"/>~<xsl:value-of select="SUPID"/></xsl:attribute><xsl:value-of select="SUPNAME"/>
</OPTION>
</xsl:for-each>
</SELECT>
</TD>


<TD> 
<SELECT NAME="CUSTOMER">

<OPTION VALUE="all">
Search All Customers 
</OPTION>

<xsl:for-each select="MSI/CUSTLIST/CUST">
<xsl:sort select="CUSTNAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="CUSTID"/></xsl:attribute><xsl:value-of select="CUSTNAME"/>
</OPTION>
</xsl:for-each>
</SELECT>
</TD>








</TR>

<TR>
	<TH>Select Begin Date</TH>
	<TH>Select End Date</TH>
</TR>

<TR>
	<TD ALIGN="CENTER">
	<INPUT NAME="BEGINDATE" SIZE="10">
		<xsl:attribute name="VALUE"><xsl:value-of select="MSI/BEGINDATE"/></xsl:attribute>    
	</INPUT>
	</TD>	
	
	<TD ALIGN="CENTER">
	<INPUT NAME="ENDDATE" SIZE="10">
		<xsl:attribute name="VALUE"><xsl:value-of select="MSI/ENDDATE"/></xsl:attribute>    
	</INPUT>
	</TD>	
</TR>


<TR>
<TD>
<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="810" ></INPUT>
<INPUT TYPE="SUBMIT" NAME="DOQUERY" VALUE="Perform Query"></INPUT>
</TD>
</TR>

</TABLE>



</FORM>
<P></P>


</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
