<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
     <TITLE>Add Customers to Area</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<BODY>


<CENTER><H1>Current Customers not assigned to <xsl:value-of select="MSI/ADDAREACUST/AREANAME"/></H1></CENTER>
<FORM>
<TABLE>

<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="1797"/>

<xsl:choose>
<xsl:when test="MSI/ADDAREACUST/CUSTLIST/CUST[.!='']">
	
		<TR>
			<TH/>
			<TH>Name</TH>
			<TH>Areas</TH>
		</TR>
</xsl:when>
</xsl:choose>
		
		<xsl:for-each select="MSI/ADDAREACUST/CUSTLIST/CUST">
   	<xsl:sort select="CUSTNAME" data-type="text" order="ascending"/>
   
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			
				
				
				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="CUSTID"/>~<xsl:value-of select="CUSTNAME"/></xsl:attribute>
				     </INPUT></TD>
				<TD><xsl:value-of select="CUSTNAME"/></TD>
				<TD>
					<xsl:for-each select="AREAINFO/AREA">
					<xsl:value-of select="AREANAME"/>
					</xsl:for-each>
			  </TD>
			</TR>
		</xsl:for-each>

<INPUT TYPE="HIDDEN" NAME="TOTALCOUNT">
	 <xsl:attribute name="VALUE"><xsl:value-of select="MSI/ADDAREACUST/CUSTLIST/FOOTER/TOTALCOUNT"/></xsl:attribute>
	 </INPUT>
</TABLE>
<INPUT TYPE="SUBMIT" NAME="NEWCUST" VALUE="Add Selected Customers"/>
</FORM>
</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
