<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Add Commission</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function setTab(focusItem) {
    focusItem.focus();
}

function validate(form) {
   var field = form.CHECKNUM;  
      //var fieldval = parseInt(field.value);   
   
   if (field.value == '') {
      alert("You must enter a Check Number.");
      return false;
   }

   
   field = form.SUPPLIER;		
   if (field.value == '') {
      alert("You need to select a Supplier.");
      return false;
   }
   else {
      return true;
   }
}
]]>
</xsl:comment>
</SCRIPT>

<BODY onLoad="setTab(FORM1.SUPPLIER)">

<xsl:choose>
<xsl:when test="MSI/SUPPLIERLIST/SupplierTable[.!='']">

<CENTER><H1>Add Commission Check</H1></CENTER><P></P>

<P><SPAN CLASS="REQUIRED">Red Field</SPAN>- denotes a required field (cannot be blank)</P>

<FORM METHOD="POST" NAME="FORM1" onSubmit="return validate(this)">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<input type="hidden" name="disValue" value="801"></input>

<TABLE>

<TR><TD CLASS="REQUIRED">Select Supplier</TD><TD></TD><TD><SELECT NAME="SUPPLIER">
<xsl:for-each select="MSI/SUPPLIERLIST/SupplierTable">
<xsl:sort select="supplier_name" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="supplier_id"/>~<xsl:value-of select="supplier_name"/></xsl:attribute><xsl:value-of select="supplier_name"/>
</OPTION>
</xsl:for-each>
</SELECT></TD></TR>



<TR><TD CLASS="REQUIRED">Check Number</TD><TD></TD><TD><INPUT NAME="CHECKNUM" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD>Date Received</TD><TD></TD><TD><INPUT NAME="DATERECV" SIZE="15"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/TODAY"/></xsl:attribute></INPUT></TD></TR>



<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Enter"><INPUT TYPE="RESET" VALUE="Undo Changes"></INPUT></INPUT></TD>

</TR>

</TABLE></FORM>
</xsl:when>

<xsl:otherwise>
<H2>You need to enter and own a supplier line in order to add commissions!</H2>
</xsl:otherwise>
</xsl:choose>


</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

