/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.net.FileNameMap;
import java.util.Enumeration;
import java.util.Hashtable;

public class MimeMap
implements FileNameMap {
    private Hashtable map = new Hashtable();

    public void addContentType(String extn, String type) {
        this.map.put(extn, type.toLowerCase());
    }

    public String getContentType(String extn) {
        String type = (String)this.map.get(extn.toLowerCase());
        return type;
    }

    public String getContentTypeFor(String fileName) {
        String extn = MimeMap.getExtension(fileName);
        if (extn != null) {
            return this.getContentType(extn.toLowerCase());
        }
        return null;
    }

    public static String getExtension(String fileName) {
        int i;
        int length = fileName.length();
        int newEnd = fileName.lastIndexOf(35);
        if (newEnd == -1) {
            newEnd = length;
        }
        if ((i = fileName.lastIndexOf(46, newEnd)) != -1) {
            return fileName.substring(i + 1, newEnd);
        }
        return null;
    }

    public Enumeration getExtensions() {
        return this.map.keys();
    }

    public void removeContentType(String extn) {
        this.map.remove(extn.toLowerCase());
    }
}

