/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.tomcat.util.Ascii;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.StringManager;

public class MessageBytes
extends Ascii {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    protected byte[] bytes;
    protected int offset;
    protected int length;

    public MessageBytes() {
    }

    public MessageBytes(byte[] b, int off, int len) {
        this.setBytes(b, off, len);
    }

    public boolean equals(String s) {
        byte[] b = this.bytes;
        int len = this.length;
        if (b == null || len != s.length()) {
            return false;
        }
        int off = this.offset;
        int i = 0;
        while (i < len) {
            if (b[off++] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(byte[] b, int off, int len) {
        byte[] b1 = this.bytes;
        if (b1 == null || len != this.length) {
            return false;
        }
        int off1 = this.offset;
        while (len-- > 0) {
            if (b[off++] == b1[off1++]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        byte[] b = this.bytes;
        int len = this.length;
        if (b == null || len != s.length()) {
            return false;
        }
        int off = this.offset;
        int i = 0;
        while (i < len) {
            if (Ascii.toLower(b[off++]) != Ascii.toLower((byte)s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] b, int off, int len) {
        byte[] b1 = this.bytes;
        if (b1 == null || len != this.length) {
            return false;
        }
        int off1 = this.offset;
        while (len-- > 0) {
            if (Ascii.toLower(b[off++]) == Ascii.toLower(b1[off1++])) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBytes(byte[] buf, int buf_offset) {
        if (this.bytes != null) {
            System.arraycopy(this.bytes, this.offset, buf, buf_offset, this.length);
        }
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isSet() {
        return this.bytes != null;
    }

    public int length() {
        return this.bytes != null ? this.length : 0;
    }

    public void reset() {
        this.bytes = null;
    }

    public void setBytes(byte[] b, int off, int len) {
        this.bytes = b;
        this.offset = off;
        this.length = len;
    }

    public boolean startsWith(String s) {
        byte[] b = this.bytes;
        int len = s.length();
        if (b == null || len > this.length) {
            return false;
        }
        int off = this.offset;
        int i = 0;
        while (i < len) {
            if (b[off++] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public long toDate(HttpDate d) throws IllegalArgumentException {
        if (this.bytes != null) {
            d.parse(this.bytes, this.offset, this.length);
            return d.getTime();
        }
        String msg = this.sm.getString("messageBytes.iae", (Object)this.bytes);
        throw new IllegalArgumentException(msg);
    }

    public int toInteger() throws NumberFormatException {
        return Ascii.parseInt(this.bytes, this.offset, this.length);
    }

    public String toString() {
        if (this.bytes == null) {
            return null;
        }
        try {
            return new String(this.bytes, this.offset, this.length, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public void write(OutputStream out) throws IOException {
        if (this.bytes != null) {
            out.write(this.bytes, this.offset, this.length);
        }
    }
}

