/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.shell.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.tomcat.shell.Constants;
import org.apache.tomcat.shell.StartupException;
import org.apache.tomcat.shell.deployment.ServerConfig;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.URLUtil;
import org.apache.tomcat.util.XMLParser;
import org.apache.tomcat.util.XMLTree;

public class Config {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.shell");
    private String[] args;
    private URL configURL = null;
    private XMLTree config = null;
    private ServerConfig serverConfig = null;

    public Config() throws StartupException {
        this(null);
    }

    public Config(String[] args) throws StartupException {
        this.args = args;
    }

    private void createConfigFile(String configFile) throws StartupException {
        try {
            InputStream is = this.getClass().getResourceAsStream(configFile);
            FileOutputStream out = new FileOutputStream(configFile);
            byte[] buf = new byte[1024];
            int read = 0;
            do {
                out.write(buf, 0, read);
            } while ((read = is.read(buf, 0, buf.length)) > -1);
            is.close();
            out.close();
        }
        catch (IOException iOException) {
            String msg = this.sm.getString("startup.loadconfig.ioe", configFile);
            throw new StartupException(msg);
        }
    }

    public String getArg(String arg) {
        String value = null;
        int i = 0;
        while (i < this.args.length) {
            if (this.args[i].equalsIgnoreCase("-" + arg) && i < this.args.length - 1) {
                value = this.args[i + 1];
                break;
            }
            ++i;
        }
        return value;
    }

    public XMLTree getConfig() {
        return this.config;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public boolean isArg(String arg) {
        boolean searchResults = false;
        int i = 0;
        while (i < this.args.length) {
            if (this.args[i].equalsIgnoreCase("-" + arg)) {
                searchResults = true;
                break;
            }
            ++i;
        }
        return searchResults;
    }

    public void loadConfig(InputStream is, boolean validate) throws StartupException {
        XMLParser parser = new XMLParser();
        try {
            this.config = parser.process(is, validate);
        }
        catch (Exception e) {
            throw new StartupException(e.getMessage());
        }
        this.processArgs(this.config);
    }

    public void loadConfig(String configFile) throws StartupException {
        this.loadConfig(configFile, true);
    }

    public void loadConfig(String configFile, boolean validate) throws StartupException {
        File f = new File(configFile);
        if (!f.exists() && !this.isArg("noconfig")) {
            System.out.println("No config file found " + configFile);
            throw new StartupException("No config file found " + configFile);
        }
        try {
            this.configURL = URLUtil.resolve(configFile);
        }
        catch (MalformedURLException malformedURLException) {
            String msg = this.sm.getString("startup.loadconfig.mue", configFile);
            throw new StartupException(msg);
        }
        this.loadConfig(this.configURL, validate);
    }

    public void loadConfig(URL configURL) throws StartupException {
        this.loadConfig(configURL, true);
    }

    public void loadConfig(URL configURL, boolean validate) throws StartupException {
        if (this.isArg("validate")) {
            String validateStr = this.getArg("validate");
            validate = Boolean.valueOf(validateStr);
        }
        System.out.println(this.sm.getString("startup.loadconfig.msg", configURL));
        XMLParser parser = new XMLParser();
        try {
            this.config = parser.process(configURL, validate);
        }
        catch (Exception e) {
            throw new StartupException(e.getMessage());
        }
        this.processArgs(this.config);
    }

    public static void main(String[] args) {
        try {
            new Config(args);
        }
        catch (StartupException e) {
            System.out.println(e.getMessage());
        }
    }

    private void processArgs(XMLTree config) {
        String adminPortStr = (String)config.getAttribute("adminPort");
        int i = 0;
        while (i < Constants.WEBSERVER_ATTRIBUTES.length) {
            String key = Constants.WEBSERVER_ATTRIBUTES[i];
            if (this.isArg(key)) {
                config.addAttribute(key, this.getArg(key));
            }
            ++i;
        }
        Enumeration enumeration = config.elements();
        while (enumeration.hasMoreElements()) {
            XMLTree configElement = (XMLTree)enumeration.nextElement();
            String id = (String)configElement.getAttribute("id");
            int i2 = 0;
            while (i2 < Constants.SERVICE_ATTRIBUTES.length) {
                String key = Constants.SERVICE_ATTRIBUTES[i2];
                if (this.isArg(String.valueOf(key) + ":" + id)) {
                    configElement.addAttribute(key, this.getArg(String.valueOf(key) + ":" + id));
                } else if (this.isArg(String.valueOf(key) + ":*")) {
                    configElement.addAttribute(key, this.getArg(String.valueOf(key) + ":*"));
                } else if (this.isArg(key) && (config.getElements().size() == 1 || id.equals(this.getArg("serviceid")))) {
                    configElement.addAttribute(key, this.getArg(key));
                }
                ++i2;
            }
        }
        this.serverConfig = new ServerConfig(this.config);
    }
}

