/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.catalina.Lifecycle;
import org.apache.tomcat.catalina.LifecycleException;
import org.apache.tomcat.catalina.Manager;
import org.apache.tomcat.catalina.Session;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.SessionManager;
import org.apache.tomcat.session.StandardManager;

public final class StandardSessionManager
implements SessionManager {
    private Manager manager = new StandardManager();

    public StandardSessionManager() {
        if (this.manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.manager)).configure(null);
                ((Lifecycle)((Object)this.manager)).start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(String.valueOf(String.valueOf(e)));
            }
        }
    }

    public void accessed(Context ctx, Request req, String id) {
        HttpSession session = this.findSession(ctx, id);
        if (session == null) {
            return;
        }
        if (session instanceof Session) {
            ((Session)session).access();
        }
        req.setSession(session);
    }

    public HttpSession createSession(Context ctx) {
        return this.manager.createSession().getSession();
    }

    public HttpSession findSession(Context ctx, String id) {
        try {
            Session session = this.manager.findSession(id);
            if (session != null) {
                return session.getSession();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public void removeSessions(Context ctx) {
        if (this.manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.manager)).stop();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(String.valueOf(String.valueOf(e)));
            }
        }
    }

    public void setSessionTimeOut(int minutes) {
        if (minutes != -1) {
            this.manager.setMaxInactiveInterval(minutes * 60);
        }
    }
}

