/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

public class ConnectorRequest
extends RequestImpl {
    MsgConnector con;
    Hashtable env_vars;
    private InputStream in;
    byte[] bodyBuff;
    int blen;
    int pos;

    public ConnectorRequest(MsgConnector con) {
        this.con = con;
        this.pos = 0;
        this.in = new BufferedServletInputStream(this);
    }

    protected int decodeRequest(MsgBuffer msg) throws IOException {
        this.env_vars = new Hashtable();
        int envCount = msg.getInt();
        int i = 0;
        while (i < envCount) {
            String n = msg.getString();
            String v = msg.getString();
            this.env_vars.put(n, v);
            ++i;
        }
        int hCount = msg.getInt();
        int i2 = 0;
        while (i2 < hCount) {
            String n = msg.getString();
            String v = msg.getString();
            this.headers.putHeader(n.toLowerCase(), v);
            ++i2;
        }
        byte[] initialBodyChunk = new byte[msg.getMaxLen()];
        int len = msg.getBytes(initialBodyChunk);
        this.bodyBuff = initialBodyChunk;
        this.blen = len;
        this.method = (String)this.env_vars.get("REQUEST_METHOD");
        this.protocol = (String)this.env_vars.get("SERVER_PROTOCOL");
        this.requestURI = (String)this.env_vars.get("REQUEST_URI");
        this.queryString = (String)this.env_vars.get("QUERY_STRING");
        if (this.requestURI == null) {
            throw new IOException("Protocol error - request is null");
        }
        int idQ = this.requestURI.indexOf("?");
        if (idQ > -1) {
            this.requestURI = this.requestURI.substring(0, idQ);
        }
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        String sport = (String)this.env_vars.get("SERVER_PORT");
        if (sport == null) {
            sport = "80";
        }
        this.serverPort = new Integer(sport);
        this.remoteAddr = (String)this.env_vars.get("REMOTE_ADDR");
        this.remoteHost = (String)this.env_vars.get("REMOTE_ADDR");
        return 0;
    }

    public int doRead() throws IOException {
        if (this.pos > this.blen) {
            System.out.println("Read after end " + this.pos + " " + this.blen);
            return -1;
        }
        return this.bodyBuff[this.pos++];
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        int i = off;
        while (i < len + off) {
            int a = this.doRead();
            if (a == -1) {
                System.out.println("Y");
                return i - off;
            }
            b[i] = (byte)a;
            ++i;
        }
        System.out.println("doRead " + off + " " + len);
        return len;
    }

    public void recycle() {
        super.recycle();
        this.pos = 0;
    }
}

