/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.SessionManager;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

public class RequestImpl
implements Request {
    protected String jvmRoute;
    protected String requestURI;
    protected String queryString;
    protected String serverName;
    protected Vector cookies = new Vector();
    protected String contextPath;
    protected String lookupPath;
    protected String servletPath;
    protected String pathInfo;
    protected String pathTranslated;
    protected boolean pathTranslatedIsSet = false;
    protected Hashtable parameters = new Hashtable();
    protected int contentLength = -1;
    protected String contentType = null;
    protected String charEncoding = null;
    protected String authType;
    protected String remoteUser;
    protected Response response;
    protected HttpServletRequestFacade requestFacade;
    protected Context context;
    protected ContextManager contextM;
    protected Hashtable attributes = new Hashtable();
    protected boolean didReadFormData;
    protected boolean didParameters;
    protected boolean didCookies;
    protected String reqSessionId;
    protected boolean sessionIdFromCookie = false;
    protected boolean sessionIdFromURL = false;
    protected HttpSession serverSession;
    protected String servletName;
    protected ServletWrapper handler = null;
    Container container;
    protected String mappedPath = null;
    protected String scheme;
    protected String method;
    protected String protocol;
    protected MimeHeaders headers = new MimeHeaders();
    protected ServletInputStream in;
    protected int serverPort;
    protected String remoteAddr;
    protected String remoteHost;
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.core");

    public RequestImpl() {
        this.recycle();
    }

    public int doRead() throws IOException {
        return -1;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return -1;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = RequestUtil.getCharsetFromContentType(this.getContentType());
        return this.charEncoding;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getContentLength() {
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        this.contentLength = this.getFacade().getIntHeader("content-length");
        return this.contentLength;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader("content-type");
        if (this.contentType != null) {
            return this.contentType;
        }
        return this.contentType;
    }

    public Context getContext() {
        return this.context;
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public Cookie[] getCookies() {
        if (!this.didCookies) {
            this.didCookies = true;
            RequestUtil.processCookies(this, this.cookies);
        }
        Cookie[] cookieArray = new Cookie[this.cookies.size()];
        int i = 0;
        while (i < this.cookies.size()) {
            cookieArray[i] = (Cookie)this.cookies.elementAt(i);
            ++i;
        }
        return cookieArray;
    }

    public HttpServletRequestFacade getFacade() {
        if (this.requestFacade == null) {
            this.requestFacade = new HttpServletRequestFacade(this);
        }
        return this.requestFacade;
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.names();
    }

    public Enumeration getHeaders(String name) {
        Vector v = this.getMimeHeaders().getHeadersVector(name);
        return v.elements();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public String getLookupPath() {
        return this.lookupPath;
    }

    public String getMappedPath() {
        return this.mappedPath;
    }

    public String getMethod() {
        return this.method;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public Enumeration getParameterNames() {
        this.handleParameters();
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        this.handleParameters();
        return (String[])this.parameters.get(name);
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.pathTranslatedIsSet) {
            return this.pathTranslated;
        }
        this.pathTranslatedIsSet = true;
        String path = this.getPathInfo();
        this.pathTranslated = null;
        if (path == null || "".equals(path)) {
            return null;
        }
        this.pathTranslated = this.context.getRealPath(path);
        return this.pathTranslated;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        return this.queryString;
    }

    public BufferedReader getReader() throws IOException {
        return RequestUtil.getReader(this);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestURI() {
        if (this.requestURI != null) {
            return this.requestURI;
        }
        return this.requestURI;
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        String hostHeader = this.getHeader("host");
        if (hostHeader != null) {
            int i = hostHeader.indexOf(58);
            if (i > -1) {
                hostHeader = hostHeader.substring(0, i);
            }
            this.serverName = hostHeader;
            return this.serverName;
        }
        System.out.println("No server name, defaulting to localhost");
        this.serverName = "localhost";
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getServletPrefix() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (this.serverSession != null) {
            try {
                this.serverSession.getCreationTime();
                return this.serverSession;
            }
            catch (IllegalStateException illegalStateException) {
                this.serverSession = null;
                this.reqSessionId = null;
            }
        }
        SessionManager sM = this.context.getSessionManager();
        if (this.reqSessionId != null) {
            this.serverSession = sM.findSession(this.context, this.reqSessionId);
            if (this.serverSession != null) {
                return this.serverSession;
            }
        }
        if (!create) {
            return null;
        }
        this.serverSession = sM.createSession(this.context);
        this.reqSessionId = this.serverSession.getId();
        this.response.setSessionId(this.reqSessionId);
        return this.serverSession;
    }

    public Principal getUserPrincipal() {
        if (this.context.getRequestSecurityProvider() == null) {
            return null;
        }
        return this.context.getRequestSecurityProvider().getUserPrincipal(this.context, this.getFacade());
    }

    public ServletWrapper getWrapper() {
        return this.handler;
    }

    private void handleParameters() {
        String qString;
        if (!this.didParameters && (qString = this.getQueryString()) != null) {
            this.didParameters = true;
            RequestUtil.processFormData(qString, this.parameters);
        }
        if (!this.didReadFormData) {
            this.didReadFormData = true;
            Hashtable postParameters = RequestUtil.readFormData(this);
            if (postParameters != null) {
                this.parameters = RequestUtil.mergeParameters(this.parameters, postParameters);
            }
        }
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.sessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.sessionIdFromURL;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession(false);
        return session != null;
    }

    public boolean isSecure() {
        if (this.context.getRequestSecurityProvider() == null) {
            return false;
        }
        return this.context.getRequestSecurityProvider().isSecure(this.context, this.getFacade());
    }

    public boolean isUserInRole(String role) {
        if (this.context.getRequestSecurityProvider() == null) {
            return false;
        }
        return this.context.getRequestSecurityProvider().isUserInRole(this.context, this.getFacade(), role);
    }

    public void recycle() {
        this.response = null;
        this.context = null;
        this.attributes.clear();
        this.parameters.clear();
        this.cookies.removeAllElements();
        this.contentLength = -1;
        this.contentType = null;
        this.charEncoding = null;
        this.authType = null;
        this.remoteUser = null;
        this.reqSessionId = null;
        this.serverSession = null;
        this.didParameters = false;
        this.didReadFormData = false;
        this.didCookies = false;
        this.container = null;
        this.handler = null;
        this.jvmRoute = null;
        this.scheme = "http";
        this.method = "GET";
        this.requestURI = "/";
        this.queryString = null;
        this.protocol = "HTTP/1.0";
        this.headers.clear();
        this.serverName = "localhost";
        this.serverPort = 8080;
        this.pathTranslated = null;
        this.pathInfo = null;
        this.pathTranslatedIsSet = false;
        this.remoteAddr = "127.0.0.1";
        this.remoteHost = "localhost";
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setBody(StringBuffer body) {
    }

    public void setCharEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setLookupPath(String l) {
        this.lookupPath = l;
    }

    public void setMappedPath(String m) {
        this.mappedPath = m;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMimeHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setParameters(Hashtable h) {
        if (h != null) {
            this.parameters = h;
        }
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setPathTranslated(String s) {
        this.pathTranslated = s;
        this.pathTranslatedIsSet = true;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteUser(String s) {
        this.remoteUser = s;
    }

    public void setRequestURI(String r) {
        this.requestURI = r;
    }

    public void setRequestedSessionId(String reqSessionId) {
        this.reqSessionId = reqSessionId;
    }

    public void setRequestedSessionIdFromCookie(boolean newState) {
        this.sessionIdFromCookie = true;
    }

    public void setRequestedSessionIdFromURL(boolean newState) {
        this.sessionIdFromURL = newState;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setSession(HttpSession serverSession) {
        this.serverSession = serverSession;
    }

    public void setWrapper(ServletWrapper handler) {
        this.handler = handler;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("R( ");
        if (this.context != null) {
            sb.append(this.context.getPath());
            if (this.getServletPath() != null) {
                sb.append(" + " + this.getServletPath() + " + " + this.getPathInfo());
            } else {
                sb.append(" + " + this.getLookupPath());
            }
        } else {
            sb.append(this.getRequestURI());
        }
        sb.append(")");
        return sb.toString();
    }

    public String toStringDebug() {
        StringBuffer sb = new StringBuffer();
        sb.append("Request( " + this.context).append("\n");
        sb.append("    URI:" + this.getRequestURI()).append("\n");
        sb.append("    SP:" + this.getServletPath());
        sb.append(",PI:" + this.getPathInfo());
        sb.append(",LP:" + this.getLookupPath());
        sb.append(",MP:" + this.getMappedPath());
        sb.append("," + this.getWrapper() + ") ");
        return sb.toString();
    }
}

