/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.ServletWrapper;

public class Container
implements Cloneable {
    private ContextManager contextM;
    Context context;
    String path;
    String proto;
    private Hashtable attributes = new Hashtable();
    private Vector contextInterceptors = new Vector();
    ContextInterceptor[] cInterceptors;
    private Vector requestInterceptors = new Vector();
    RequestInterceptor[] rInterceptors;
    ServletWrapper handler;
    String transport;
    String[] roles = null;

    public void addContextInterceptor(ContextInterceptor ci) {
        this.contextInterceptors.addElement(ci);
    }

    public void addRequestInterceptor(RequestInterceptor ci) {
        this.requestInterceptors.addElement(ci);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Container getClone() {
        try {
            return (Container)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public ContextInterceptor[] getContextInterceptors() {
        if (this.cInterceptors == null || this.cInterceptors.length != this.contextInterceptors.size()) {
            this.cInterceptors = new ContextInterceptor[this.contextInterceptors.size()];
            int i = 0;
            while (i < this.cInterceptors.length) {
                this.cInterceptors[i] = (ContextInterceptor)this.contextInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.cInterceptors;
    }

    public ContextManager getContextManager() {
        if (this.contextM == null && this.context != null) {
            this.contextM = this.context.getContextManager();
        }
        return this.contextM;
    }

    public ServletWrapper getHandler() {
        if (this.handler == null) {
            this.handler = this.context.getDefaultServlet();
        }
        return this.handler;
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocol() {
        return this.proto;
    }

    public RequestInterceptor[] getRequestInterceptors() {
        if (this.rInterceptors == null || this.rInterceptors.length != this.requestInterceptors.size()) {
            this.rInterceptors = new RequestInterceptor[this.requestInterceptors.size()];
            int i = 0;
            while (i < this.rInterceptors.length) {
                this.rInterceptors[i] = (RequestInterceptor)this.requestInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.rInterceptors;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String getTransport() {
        return this.transport;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setHandler(ServletWrapper h) {
        this.handler = h;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setProtocol(String protocol) {
        this.proto = protocol;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Ct (");
        if (this.handler != null) {
            sb.append(this.handler.toString());
        }
        if (this.roles != null) {
            sb.append(" Roles: ");
            int i = 0;
            while (i < this.roles.length) {
                sb.append(" ").append(this.roles[i]);
                ++i;
            }
        }
        sb.append(" )");
        return sb.toString();
    }
}

