/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.HTMLOutputHandler;
import com.jclark.xsl.sax.NXMLOutputHandler;
import com.jclark.xsl.sax.OutputDocumentHandler;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.TextOutputHandler;
import com.jclark.xsl.sax.XMLOutputHandler;
import com.jclark.xsl.sax.XSLProcessor;
import java.io.IOException;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class OutputMethodHandlerImpl
implements OutputMethodHandler {
    private XSLProcessor processor;
    private Destination dest;
    private static final String JAVA_OUTPUT_METHOD = "http://www.jclark.com/xt/java";

    public OutputMethodHandlerImpl(XSLProcessor xSLProcessor) {
        this.processor = xSLProcessor;
    }

    public void setDestination(Destination destination) {
        this.dest = destination;
    }

    public DocumentHandler createDocumentHandler(String string, AttributeList attributeList) throws SAXException, IOException {
        DocumentHandler documentHandler = null;
        if (string != null) {
            if (string.startsWith(JAVA_OUTPUT_METHOD) && string.lastIndexOf(94) == JAVA_OUTPUT_METHOD.length()) {
                try {
                    Class<?> clazz = Class.forName(string.substring(JAVA_OUTPUT_METHOD.length() + 1));
                    documentHandler = (DocumentHandler)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {}
            } else if (string.equals("http://www.jclark.com/xt" + '^' + "nxml")) {
                documentHandler = new NXMLOutputHandler();
            } else if (string.equals("html")) {
                documentHandler = new HTMLOutputHandler();
            } else if (string.equals("text")) {
                documentHandler = new TextOutputHandler();
            }
        }
        if (documentHandler == null) {
            documentHandler = new XMLOutputHandler();
        }
        if (documentHandler instanceof OutputDocumentHandler) {
            documentHandler = ((OutputDocumentHandler)documentHandler).init(this.dest, attributeList);
        }
        return documentHandler;
    }

    public OutputMethodHandler createOutputMethodHandler(String string) {
        Destination destination = this.dest.resolve(string);
        if (destination == null) {
            return null;
        }
        OutputMethodHandlerImpl outputMethodHandlerImpl = new OutputMethodHandlerImpl(this.processor);
        outputMethodHandlerImpl.setDestination(destination);
        return outputMethodHandlerImpl;
    }
}

