/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Zip
extends MatchingTask {
    private File zipFile;
    private File baseDir;
    protected String archiveType = "zip";

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!");
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!");
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.baseDir);
        String[] files = ds.getIncludedFiles();
        String[] dirs = ds.getIncludedDirectories();
        boolean upToDate = true;
        int i = 0;
        while (i < files.length && upToDate) {
            if (new File(this.baseDir, files[i]).lastModified() > this.zipFile.lastModified()) {
                upToDate = false;
            }
            ++i;
        }
        if (upToDate) {
            return;
        }
        this.project.log("Building " + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        try {
            ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
            this.initZipOutputStream(zOut);
            int i2 = 0;
            while (i2 < dirs.length) {
                File f = new File(this.baseDir, dirs[i2]);
                String name = String.valueOf(dirs[i2].replace(File.separatorChar, '/')) + "/";
                this.zipDir(f, zOut, name);
                ++i2;
            }
            int i3 = 0;
            while (i3 < files.length) {
                File f = new File(this.baseDir, files[i3]);
                String name = files[i3].replace(File.separatorChar, '/');
                this.zipFile(f, zOut, name);
                ++i3;
            }
            zOut.close();
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.archiveType + " " + ioe.getMessage();
            throw new BuildException(msg);
        }
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        zOut.setMethod(8);
    }

    public void setBasedir(String baseDirname) {
        this.baseDir = this.project.resolveFile(baseDirname);
    }

    public void setZipfile(String zipFilename) {
        this.zipFile = this.project.resolveFile(zipFilename);
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        this.zipFile(fIn, zOut, vPath);
        fIn.close();
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath) throws IOException {
        ZipEntry ze = new ZipEntry(vPath);
        zOut.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }
}

