/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import sun.rmi.rmic.Main;

public class Rmic
extends Task {
    private String base;
    private String classname;
    private String sourceBase;
    private String stubVersion;
    private String compileClasspath;
    private boolean filtering = false;

    private void addExistingToClasspath(StringBuffer target, String source) {
        StringTokenizer tok = new StringTokenizer(source, System.getProperty("path.separator"), false);
        while (tok.hasMoreTokens()) {
            File f = this.project.resolveFile(tok.nextToken());
            if (f.exists()) {
                target.append(File.pathSeparator);
                target.append(f.getAbsolutePath());
                continue;
            }
            this.project.log("Dropping from classpath: " + f.getAbsolutePath(), 3);
        }
    }

    public void execute() throws BuildException {
        File baseFile = this.project.resolveFile(this.base);
        File sourceBaseFile = null;
        if (this.sourceBase != null) {
            sourceBaseFile = this.project.resolveFile(this.sourceBase);
        }
        String classpath = this.getCompileClasspath(baseFile);
        Main compiler = new Main((OutputStream)System.out, "rmic");
        int argCount = 5;
        int i = 0;
        if (this.stubVersion != null) {
            ++argCount;
        }
        if (this.sourceBase != null) {
            ++argCount;
        }
        String[] args = new String[argCount];
        args[i++] = "-d";
        args[i++] = baseFile.getAbsolutePath();
        args[i++] = "-classpath";
        args[i++] = classpath;
        args[i++] = this.classname;
        if (this.stubVersion != null) {
            args[i++] = "1.1".equals(this.stubVersion) ? "-v1.1" : ("1.2".equals(this.stubVersion) ? "-v1.2" : "-vcompat");
        }
        if (this.sourceBase != null) {
            args[i++] = "-keepgenerated";
        }
        compiler.compile(args);
        if (this.sourceBase != null) {
            String stubFileName = String.valueOf(this.classname.replace('.', '/')) + "_Stub.java";
            File oldStubFile = new File(baseFile, stubFileName);
            File newStubFile = new File(sourceBaseFile, stubFileName);
            try {
                this.project.copyFile(oldStubFile, newStubFile, this.filtering);
                oldStubFile.delete();
            }
            catch (IOException ioe) {
                String msg = "Failed to copy " + oldStubFile + " to " + newStubFile + " due to " + ioe.getMessage();
                throw new BuildException(msg);
            }
            if (!"1.2".equals(this.stubVersion)) {
                String skelFileName = String.valueOf(this.classname.replace('.', '/')) + "_Skel.java";
                File oldSkelFile = new File(baseFile, skelFileName);
                File newSkelFile = new File(sourceBaseFile, skelFileName);
                try {
                    this.project.copyFile(oldSkelFile, newSkelFile, this.filtering);
                    oldSkelFile.delete();
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + oldSkelFile + " to " + newSkelFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg);
                }
            }
        }
    }

    private String getCompileClasspath(File baseFile) {
        String bootcp;
        StringBuffer classpath = new StringBuffer();
        classpath.append(baseFile.getAbsolutePath());
        if (this.compileClasspath != null) {
            this.addExistingToClasspath(classpath, this.compileClasspath);
        }
        this.addExistingToClasspath(classpath, System.getProperty("java.class.path"));
        if (Project.getJavaVersion().startsWith("1.2") && (bootcp = System.getProperty("sun.boot.class.path")) != null) {
            this.addExistingToClasspath(classpath, bootcp);
        }
        return classpath.toString();
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setClass(String classname) {
        this.project.log("The class attribute is deprecated. Please use the classname attribute.", 1);
        this.classname = classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setClasspath(String classpath) {
        this.compileClasspath = this.project.translatePath(classpath);
    }

    public void setFiltering(String filter) {
        this.filtering = Project.toBoolean(filter);
    }

    public void setSourceBase(String sourceBase) {
        this.sourceBase = sourceBase;
    }

    public void setStubVersion(String stubVersion) {
        this.stubVersion = stubVersion;
    }
}

