#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 / 
inventory  -- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gPrevCard,gDescription1,gDescription2
  put "inventory" into gStack
  if the short name of this stack <> gStack then exit openStack
  
  put field "Description1label" into gDescription1
  put field "Description2label" into gDescription2
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if field "date" of card 1 is empty then
      go first card
      put the long date into field "date"
    else
      if gPrevCard is not empty then
        go card gPrevCard
      else
        go last card
      end if
    end if
    saveData
    setArrows
    unlock screen with visual plain
  end if
end openStack

on calculateCost whichFld,prompt
  global gDollarSign
  if gDollarSign = "$" then set the numberformat to 0.00
  put validateNumber(field whichFld) into temp
  ask prompt with temp
  if the result is "cancel" or it is empty then
    put empty into field whichFld
    exit to metaCard
  end if
  if whichFld is "qty" AND it is not a number then
    answer error "Enter numbers only. Try again."
    exit to metaCard
  else
    put checkNumber(it) into znumber
  end if
  if znumber is empty or znumber is 0 then
    put empty into field whichFld
    exit to metaCard
  end if
  put validateNumber(znumber) into znumb
  put validateNumber(field "cost") into zCost
  put validateNumber(field "qty") into zQty
  put validateNumber(field "total") into zTotal
  switch whichFld
  case "cost"
    put gDollarSign & setNumber(znumb) into field whichFld
    if zQty is empty  then exit calculateCost
    put gDollarSign & setNumber(znumb * zQty) into field "total"
    break
  case "qty"
    put  setNumber(znumb) into field whichFld
    if zCost is empty then exit calculateCost
    put gDollarSign & setNumber(znumb * zCost) into field "total"
    break
  case "total"
    put gDollarSign & setNumber(znumb) into field whichFld
    if zQty is empty then exit calculateCost
    put gDollarSign & setNumber(znumb / zQty) into field "cost"
  end switch
  calculateRemaining
end calculateCost

on calculateRemaining
  global gDollarSign
  
  if field "qty" is empty then exit calculateRemaining
  if gDollarSign = "$" then set the numberformat to 0.00
  put 0 into zNumSold
  repeat with i = 1 to the number of lines of field "dates sold"
    add word 1 of line i of field "dates sold" to zNumSold
  end repeat
  put validateNumber(field "qty") into znumb
  put  znumb - zNumSold into temp
  if temp < 0 then
    put "Need to order" && abs(temp) into field "instock"
    put 0 into field "instockvalue"
  else
    put setNumber(temp) into field "instock"
    if field "price" is empty then
      put 0 into field "instockvalue"
    else
      put validateNumber(field "price") * temp into instockvalue
      put gDollarSign & setNumber(instockvalue) into field "instockvalue"
    end if
  end if
  if field "price" is empty then send mouseUp to field "price"
end calculateRemaining

on clearCardOne
  put the number of field "date" into firstField
  repeat with i = firstField to the number of fields
    if the short name of field i is "short" or the short name of field i is "long" then next repeat
    put empty into field i
  end repeat
  put 1 into field "record"
end clearCardOne

on checkCompleted
  if the number of cards = 1 and field "item" is empty then exit checkCompleted
  if field "item" is empty OR (field "cost" is empty OR field "qty" is empty OR field "price" is empty) then
    answer warning "This record is missing information" & return & \
        " and will not be included in any report." & return \
        & "All records must have an item description," & return & \
        "a cost, a quantity and a retail price." with "Fix later" or "Delete Record" or "Fix now"
    unlock screen
    if it is "fix now" then
      if field "item" is empty then send mouseUp to button "select item"
      if field "cost" is empty then send mouseUp to field "cost"
      if field "qty" is empty then send mouseUp to field "qty"
      if field "price" is empty then send mouseUp to field "price"
      exit to metaCard
    end if
    if it is "Delete Record"  then
      if the number of cards > 1 then
        lock screen
        put the number of this card into cardNum
        delete this card
        go card cardNum
        unlock screen
      else
        clearCardOne
      end if
      repeat with i = 1 to the number of cards
        put i into field "record" of card i
      end repeat
    end if
  end if
end checkCompleted

on openCard
  if the short name of this stack is "inventory" then
    saveData
  end if
end openCard

on closeCard
  global gDontSave
  
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "inventory" then
    checkData
    set the hilitedLines of field "dates sold" to 0
    hide button "Delete Line"
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w         Ԡ Gold    white        
       ^ Inventory Tracker    
  W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica  
 W 
Helvetica  
 W 
Helvetica   W 
Helvetica  
 U Arial 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
       	@          &        i fon mouseUp
  set the hilitedLines of field "dates sold" to 0
  hide button "Delete Line"
end mouseUp
        
  > date label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "date" of card i is it then
      lock screen
      go card i
      unlock screen with visual plain
      setarrows
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
         
 l            Purchase Date 
  u description1label           
             
Description1 
  o label2           > l            Item Description 
   description2label           =             
Description2 
   label3a           n M            
Cost Each 
   label3b           n H            	Quantity 
   label3c          n H            Total Cost 
   label3d          t              x 
   label3e                        = 
   label4            n            Retail Price Each 
   label4b                        Remaining in Stock 
   label4c                        Remaining Stock Value 
  C label5                        Date, Qty & Price Sold 
  { label6          0             Notes 
   recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	Record #   S New Ex  von mouseUp
  global gRegistered
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel "Register"
    exit mouseUp
  end if
  
  if  field "item" is empty then
    answer information "You need to choose or create an item " & return & \
        "for this record before creating another."
    send mouseUp to button "select item"
    exit mouseUp
  end if
  
  checkCompleted
  if  field "item" is empty then
    answer question "Do you want a new blank record or" & return & " a duplicate of this item?" \
        with "Blank Record" or "Duplicate Item"
    put it into which
  else
    put "Blank Record" into which
  end if
  unlock screen
  lock screen
  lock messages
  
  if which is "blank record" then
    go last
    create card
    put the number of this card into field "record"
    send mouseUp to button "select item"
  end if
  
  if which is "Duplicate Item" then
    put field "item" into zItemName
    put field "description1" into description1
    put field "description2" into description2
    go last
    create card
    put zItemName into field "item"
    put description1 into field "description1"
    put description2 into field "description2"
    put the number of this card into field "record"
  end if
  
  put the long date into field "date"
  setArrows
  unlock screen with visual plain
end mouseUp
           ک Wheat    & A             	     
  F date  	x  Mon mouseUp
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "date"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "date"
  end if
end mouseUp
        
             
  p item  	x   ?on mouseUp
  send mouseUp to button "Select Item"
end mouseUp
        
 S            
   cost  	x   Pon mouseUp
  calculateCost "cost", "Enter the cost for each item."
end mouseUp
        
  j           
   qty  	x   Oon mouseUp
  calculateCost "qty", "Enter the quantity purchased."
end mouseUp
          a           
   total  	x   Ion mouseUp
  calculateCost "total", "Enter the total cost."
end mouseUp
         h           
   price  	x  on mouseUp
  global gDollarSign
  put validateNumber(field "price") into temp
  --  put field "price" into temp
  ask "Enter the retail price for each item." with temp
  if the result is "cancel" then exit mouseUp
  if it is empty then exit mouseUp
  if checkNumber(it) is empty then
    put empty into field "price"
  else
    put validateNumber(it) into temp
    put gDollarSign &setNumber(temp) into field "price"
    -- else put setNumber(it) into field "price"
  end if
  calculateRemaining
end mouseUp
                     
  J dates sold  	x   on mouseUp
  if line (the hilitedLines of field "dates sold") of field "dates sold" is not empty
  then show button "Delete Line"
  else hide button "Delete Line"
end mouseUp
        
   {                  K    	`    @     y 
  y notes  )h         
E  K            z    	`    @  F  I 
  N record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *          1   O First @V  
 on mouseUp
  global gVeffect
checkCompleted
  lock screen
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat      * ,  ?         	   	  o   P Prev @F  
 on mouseUp
  global gVeffect
checkCompleted
  lock screen
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat     * ,  @         	     Q Next @F  
 on mouseUp
  global gVeffect
checkCompleted
  lock screen
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat   ?  * ,  A         	     R Last @F  
 on mouseUp
  global gVeffect
checkCompleted
  lock screen
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   ک Wheat   e  * ,  B         	     T Delete Ex  Jon mouseUp
  if the number of cards = 1 then
    if field "item" is empty then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
      put the long date into field "date"
    end if
    exit mouseUp
  end if
  answer question "Delete all records, old records or just this one?" with "All" or "Older" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card -1 into cardNum
  if it is "Older" then
    ask "Delete records older than what date?" with field "date"
    if it is empty or it is not a date then exit mouseUp
    put it into theDate
    convert theDate to seconds
    lock screen
    repeat with i = the number of cards down to 2
      set cursor to busy
      put field "date" of card i into zdate
      convert zdate to seconds
      if zdate < theDate then  delete card i
    end repeat
    
    go card 1
    put field "date" of card 1 into zdate
    convert zdate to seconds
    if zdate < theDate then
      if the number of cards is 1 then
        clearCardOne
        put the long date into field "date"
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    put the long date into field "date"
    setArrows
    saveData
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
           ک Wheat   C& A             	       U Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 220 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack zFindStack to it
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
           ک Wheat    @ A              	       V Sort Ex  +on mouseUp
  if field "item" is empty then
    answer information "No records to sort."
    exit mouseUp
  end if
  answer question "Sort records by date or item description?" with  "Cancel" or "Item Description"  or "Date"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock screen
  lock messages
  repeat with i = 1 to the number of cards
    put empty into temp
    put field "date"  of card i into startDate
    convert startDate to seconds
    put startDate into field "Start items" of card i
  end repeat
  
  sort this stack by field "Start items"
  if it is "Item Description" then
    sort this stack by field "item"
  end if
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
           ک Wheat   C@ A              	       W Import Ex  Von mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "item" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  importRecords firstCard, renumberTasks -- in this script
  setArrows
  saveData
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  global gDescription1,gDescription2
  -- read from file, create and populate new cards
  answer file "Select an inventory records file to import." with "inventory_records.txt"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 of temp <> "Purchase" then
      answer error "This is not a valid inventory records file. Try again."
      close file fileName
      exit to metaCard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    
    set the itemDelimiter to tab
    put item 3 of temp into gDescription1
    put gDescription1 into field "description1label"
    set the label of button "description1" of stack "invReportOpts" to gDescription1
    put item 4 of temp into gDescription2
    put gDescription2 into field "description2label"
    set the label of button "description2" of stack "invReportOpts" to gDescription2
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into startDate
      convert startDate to long date
      put startDate into field "Date"
      put item 2 of zline into field "item"
      
      put item 3 of zline into field "description1"
      put item 4 of zline into field "description2"
      
      put item 5 of zline into field "cost"
      put item 6 of zline into field "qty"
      put item 7 of zline into field "total"
      put item 8 of zline into field "price"
      
      put item 9 of zline into dsold
      repeat while offset(" | ",dsold) > 0
        put offset(" | ",dsold) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of dsold
      end repeat
      put dsold into field "dates sold"
      
      put item 10 of zline into tNotes
      repeat while offset(" | ",tnotes) > 0
        put offset(" | ",tnotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of tnotes
      end repeat
      put tnotes into field "Notes"
      
      put true into zflag
      repeat with n = 1 to the number of lines of field "Projects" of stack "Items"
        if field "item" = line n of field "Projects" of stack "Items" then
          put false into zflag
          exit repeat
        end if
      end repeat
      if zflag then
        put the number of lines of field "Projects" of stack "Items" + 1into zlines
        put field "item" into line zlines of field "Projects" of stack "Items"
      end if
      calculateRemaining
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
    sort field "projects" of stack "items"
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords
           ک Wheat    U A              	       X Export Ex  2on mouseUp
  global gDescription1,gDescription2
  if the number of cards is 1 and field "item" is empty then
    answer information "There are no records to export."
    exit mouseUp
  end if
  answer question "Export all records or specific records?" with "All" or "Specific" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  put it into exportWhich
  put empty into whichProject
  put the short date into whichDate
  if it is "Specific" then
    answer question "Export old records, new records or item records?" with "New" or "Old" or "Item" or "Cancel"
    if it is "Cancel" then exit mouseUp
    unlock screen
    put it into exportWhich
    if exportWhich is "Item" then
      answer "Export records for item" && field "item" & "?" with "OK" or "Help" or "Cancel"
      if it is "Cancel" then exit mouseUp
      if it is "Help" then
        answer "You can only export item records from a record for that item."
        exit mouseUp
      end if
      put field "item" into whichProject
      put empty into whichDate
      ask file "Save records as... " with whichProject&"_inventory_records.txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
    end if
    if exportWhich is "New" then
      ask "Export records newer than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "inventory_records_newer_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
    if exportWhich is "Old" then
      ask "Export records older than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "inventory_records_older_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
  end if
  if exportWhich is "all" then
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_inventory_records_" & whichDate & ".txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    put empty into whichDate
  end if
  unlock screen
  
  lock messages
  lock screen
  put true into noRecords
  repeat with i = 1 to the number of cards
    set cursor to busy
    go card i
    put true into exportRecord
    if whichProject <> empty then
      if  field "item" <> whichProject then
        put false into exportRecord
      end if
    end if
    if whichDate<> empty then
      put field "date" into startDate
      convert startDate to seconds
      if exportWhich is "New" then
        if startDate <= whichDate then
          put false into exportRecord
        end if
      else -- exportWhich is "old"
        if startDate >= whichDate then
          put false into exportRecord
        end if
      end if
    end if
    if exportRecord then
      put false into noRecords
      
      put field "date" into startDate
      convert startDate to short date
      put field "notes" into tnotes
      repeat while offset(return,tnotes) > 0
        put " | " into char offset(return,tnotes) of tnotes
      end repeat
      
      put field "dates sold" into dsold
      repeat while offset(return,dsold) > 0
        put " | " into char offset(return,dsold) of dsold
      end repeat
      
      put startDate & tab & field "item" & tab & field "description1" & tab & field "description2"  & tab & field "cost" & \
          tab & field "qty" & tab & field "total" & tab & field "price" & tab & dsold  & tab & \
          tnotes & return after export -- file fileName
    end if
  end repeat
  setarrows
  saveData
  
  if  noRecords then
    answer information "No records were found to export."
    exit to metaCard
  end if
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    write "Purchase Date" & tab  & "Item Description" & tab & gDescription1 & tab & gDescription2 \
        & tab & "Cost Each" & tab & "Quantity" & tab & "Total Cost" & tab & "Retail Price" \
        & tab & "Dates sold" & tab & "Notes"  & return to file fileName
    write export to file fileName
    unlock screen with visual plain
    close file fileName
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
           ک Wheat   CU A              	       Y Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
   ک Wheat    j A              	       ^ Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "ivyHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "inventory tracker", helpStack, zStack
end mouseUp
   ک Wheat   Cj A              	       \ Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
   ک Wheat     A      Quit          	       [ Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
   ک Wheat   C A              	       ] Inventory Report Ex  -on mouseUp
  global gCurrentCard
  if the number of cards is 1 and field "item" is empty then
    answer information "There are no records to report."
    exit mouseUp
  end if
  checkCompleted
  checkData
  lock screen
  put "invReportOpts" into whichStack
  if the openStacks contains whichStack then close stack whichStack
  put the number of this card into gCurrentCard
  put field "projects" of stack "items" into field "items" of stack "invReportOpts"
  topLevel "invReportOpts"
  setLoc "invReportOpts"
  unlock screen with visual plain
end mouseUp
   ک Wheat                  	       _ Today Ex  
 >on mouseUp
  put the long date into field "date"
end mouseUp
   ک Wheat    d  (              	       ` Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
   ک Wheat      (              	       a Choose Ex  
ton mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
   ک Wheat      2              	     
  l start items  !h            t                  | Today2 ex  
on mouseUp
--  put the abbr date into temp
  put the short date into temp
  addDateQtyPrice temp
end mouseUp

on addDateQtyPrice zdate
  global gDollarSign
  ask "Enter the number sold on this date"
  if it is empty then exit addDateQtyPrice
  if it is not a number then
    answer "Enter only numbers. Please try again."
    ask "Enter the number sold on this date"
    if it is empty or it is not a number then exit addDateQtyPrice
  end if
  put it into znumb
  ask "Enter the selling price for each item."
  if it is empty then exit addDateQtyPrice
  if it is not a number then
    answer "Enter only numbers. Please try again."
    ask "Enter the selling price for each item."
    if it is empty or it is not a number then exit addDateQtyPrice
  end if
 -- put zdate & comma && znumb && "sold" & comma && gDollarSign & it & return after field "dates sold"
   put znumb && "sold on" && zdate && "for" && gDollarSign & it  && "each" & return after field "dates sold"
  calculateRemaining
end addDateQtyPrice
   ک Wheat      (      Today          	       ~ Choose Ex  
on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "dates sold" into gStartDate
  put "dates sold" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date Sold"
  modal stack "dates"
end mouseUp
   ک Wheat      2              	        Select Item ex   on mouseUp
  global gStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gStack
  modal stack "items"
end mouseUp
           ک Wheat     < V      Add/Select         	        Delete Line Ex  
on mouseUp
  if the hilitedLines of field "dates sold" is not empty then
    delete line (the hilitedLines of field "dates sold") of field "dates sold"
  end if
  set the hilitedLines of field "dates sold" to 0
  calculateRemaining
  hide button "Delete Line"
end mouseUp
   ک Wheat      ^              	        Edit Ex  
 7on mouseUp
  send mouseUp to field "cost"
end mouseUp
   ک Wheat    T p                	        Edit Ex  
 6on mouseUp
  send mouseUp to field "qty"
end mouseUp
   ک Wheat     p                	        Edit Ex  
 8on mouseUp
  send mouseUp to field "total"
end mouseUp
   ک Wheat   d p                	        Edit Ex  
 8on mouseUp
  send mouseUp to field "price"
end mouseUp
   ک Wheat   d                 	        
Main Menu }    ^on menuPick which
checkCompleted
  set cursor to watch
  goSBTrackerStack which
end menuPick
   ک Wheat    
       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
Schedule Tracker - Calendar
Task Tracker - To Do List
-
(Inventory Tracker
Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        size   a          h Z
   short  )h 	 
       $ l  <           button "First"	242,250,284,294  button "Prev"	281,250,323,294  button "Next"	319,250,361,294  button "Last"	357,250,399,294  button "New"	254,294,319,316   button "Delete"	323,294,388,316  button "Find"	254,320,319,338  button "Sort"	323,320,388,338   button "Import"	254,341,319,359   button "Export"	323,341,388,359  button "Prefs"	254,362,319,380  button "Help"	323,362,388,380  button "Quit"	254,383,319,401  button "Save"	323,383,388,401  *button "Inventory Report"	254,411,388,433  "button "Main Menu"	10,411,234,433  field "label6"	3,304,187,328  $field "recNumLabel"	280,223,349,247  "field "dates sold"	10,181,234,304  field "notes"	10,325,234,400  field "record"	346,223,388,247       	`    @   m  : 
   long  )h 	 
        l  <           button "First"	242,354,284,398  button "Prev"	281,354,323,398  button "Next"	319,354,361,398  button "Last"	357,354,399,398  button "New"	254,402,319,424   button "Delete"	323,402,388,424  button "Find"	254,428,319,446  button "Sort"	323,428,388,446   button "Import"	254,449,319,467   button "Export"	323,449,388,467  button "Prefs"	254,470,319,488  button "Help"	323,470,388,488  button "Quit"	254,491,319,509  button "Save"	323,491,388,509  *button "Inventory Report"	254,519,388,541  "button "Main Menu"	10,519,234,541  field "label6"	3,351,187,375  $field "recNumLabel"	280,327,349,351  "field "dates sold"	10,181,234,352  field "notes"	10,372,234,508  field "record"	346,326,388,350       	`    @  m  :    putLong Ex  
2on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 15
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of button 27 & tab & the rect of button 27 after field whichField
  repeat with i = 14 to 15
    put return & the name of field i & tab & the rect of field i after field whichField
  end repeat
  repeat with i = 22 to 24
    put return & the name of field i & tab & the rect of field i after field whichField
  end repeat
end mouseUp
   ک Wheat      :              	        setLong Ex  
on mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
  show field "label4b"
  show field "label4c"
  show field "instock"
  show field "instockvalue"
end mouseUp
   ک Wheat      :              	        	putShort Ex  
3on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 15
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of button 27 & tab & the rect of button 27 after field whichField
  repeat with i = 14 to 15
    put return & the name of field i & tab & the rect of field i after field whichField
  end repeat
  repeat with i = 22 to 24
    put return & the name of field i & tab & the rect of field i after field whichField
  end repeat
end mouseUp
   ک Wheat    '  :              	        	setShort Ex  
on mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
  hide field "label4b"
  hide field "label4c"
  hide field "instock"
  hide field "instockvalue"
end mouseUp
   ک Wheat    g  :              	        
Find Project ex  on mouseUp
  global gStack, gButton,gWhichCard
  put the short name of me into gButton
  put the short name of this stack into gStack
  checkCompleted
  answer question "Do you want to go to the first or last " \
      & return & "record for a particular item?" \
      with "Cancel" or "First" or "Last"
  if it is "cancel" then exit mouseUp
  else put it into gWhichCard
  modal stack "items"
end mouseUp
           ک Wheat    l < $      Go         	     
   
description1  )x   on enterInField
  -- trap
end enterInField

on returnInField
  answer "Returns are not allowed in this field."
end returnInField
                     
   
description2  )x   on enterInField
  -- trap
end enterInField

on returnInField
  answer "Returns are not allowed in this field."
end returnInField
         R               Change Ex  
Con mouseUp
  global gDescription1
  
  ask "Enter a new name for this field." with field "Description1label"
  if the result is "cancel" or it is empty then exit mouseUp
  put it into gDescription1
  put it into field "Description1label"
  set the label of button "description1" of stack "invReportOpts" to it
end mouseUp
   ک Wheat   R  2              	        Change Ex  
Con mouseUp
  global gDescription2
  
  ask "Enter a new name for this field." with field "Description2label"
  if the result is "cancel" or it is empty then exit mouseUp
  put it into gDescription2
  put it into field "Description2label"
  set the label of button "description2" of stack "invReportOpts" to it
end mouseUp
   ک Wheat   R ? 2              	     
   instock  h                      
   
instockvalue  h                        items  on openCard
  global gProject
  if field "projects" = empty then exit openCard
  if gProject is empty then
    set the hilitedlines of field "projects" to 1
    put 1 into gProject
  else
    set the hilitedlines of field "projects" to gProject
  end if
end openCard

on arrowKey which
  global gProject
  put the number of lines of field "projects" into numLines
  if which is "up" then
    if gProject is 1 then
      put numLines into gProject
    else
      subtract 1 from gProject
    end if
  end if
  if which is "down" then
    if gProject is numLines then
      put 1 into gProject
    else
      add 1 to gProject
    end if
  end if
  set the hilitedlines of field "projects" to gProject
end arrowKey
           Ԡ Gold    # _^,         Item Descriptions      U Arial   U Arial   U 
Helvetica  
 U Arial  	 U Arial   U Arial   U 
Helvetica  
 U 
Helvetica  
 W 
Helvetica   W Arial   W 
Helvetica       	@          ^,                  
   projectsbg  	h          6                    	`    @   7      Create Item Ex 
 #on mouseUp
  global gProject
  put 32 into maxLength
  ask "Enter the new item description."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this item that is" && maxLength && "characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is it then
      answer information "You have already created this item."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "projects" + 1 into temp
  put it into newProject
  put newProject into line temp of field "projects"
  sort field "projects"
  unlock screen
  set cursor to watch
  save this stack
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is newProject then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit mouseUp
    end if
  end repeat
  
end mouseUp
           ک Wheat     j s             	        Delete Item Ex  Hon mouseUp
  global gProject,gStack
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project to delete."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into temp
  answer warning "Are you sure you want to delete item " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gProject of field "projects"
  put empty into gProject
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat      s             	        Choose Item Mx  on mouseUp
  global gProject,gStack,gProjectName,gButton
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "First create an item description."
      send mouseUp to button "Create Item"
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select or create an item."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into gProjectName
  send chooseProject to field "projects"
end mouseUp
   ک Wheat     9 q %            	        
Close Window Ex   Xon mouseUp
  global gDontSave
  put true into gDontSave
  close this stack
end mouseUp
   ک Wheat      s             	     
   instruction 	          F (           iCreate an item description or select one from the list on the left and then click a button on the right. 
   	projects  	x  on mouseUp
  global gProject
  put word 2 of the clickLine into gProject
end mouseUp

on mouseDoubleDown
  global gProject,gStack,gProjectName,gButton,gWhichCard
  put word 2 of the clickLine into gProject
  put line gProject of field "projects" into gProjectName
  if gProjectName is empty then exit to metaCard
  chooseProject
end mouseDoubleDown

on chooseProject
  global gProject,gStack,gProjectName,gButton,gWhichCard,gDontSave
  put true into gDontSave
  lock screen
  put line gProject of field "projects" into gProjectName
  close this stack
  if gButton is "find project" then
    if gWhichCard is "Last" then
      repeat with i = the number of cards of stack gStack down to 1
        if field "item" of card i of stack gStack is gProjectName then
          go card i of stack gStack
          send setArrows to stack gStack
          exit repeat
        end if
      end repeat
    else
      repeat with i = 1 to the number of cards of stack gStack
        if field "item" of card i of stack gStack is gProjectName then
          go card i of stack gStack
          send setArrows to stack gStack
          exit repeat
        end if
      end repeat
    end if
  else
    if field "item" of stack gStack is empty then
      put gProjectName into field "item" of stack gStack
    else
      answer warning "Do you want to change the Item for this record" \
          & return & "or do you want to create a new record?" with "Change" or "New" or "Cancel"
      if it is "Cancel" then exit to metacard
      if it is "New" then send mouseUp to button "New" of stack gStack
      if it is "Change" then put gProjectName into field "item" of stack gStack
    end if
  end if
  put empty into gProject
end chooseProject
        	 6                    	`    @   7      Modify Item Ex  *on mouseUp
  global gProject, gStack,gProjectName
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select an item."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into origProject
  
  put 32 into maxLength
  ask "Enter the new name for this item." with origProject
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this item that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  put it into gProjectName
  put gProjectName into line gProject of field "projects"
  sort field "projects"
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is gProjectName then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit repeat
    end if
  end repeat
  
  repeat with i = 1 to the number of cards of stack "inventory"
    if field "item" of card i of stack "inventory" is origProject then
      put gProjectName into field "item" of card i of stack "inventory"
    end if
  end repeat
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat      s             	        Import/Export Ex   on mouseUp
  put "projects" into zfield
  put "items" into what
  put "an Item" into zstack
  put "items.txt" into fileName
  
  importExport zfield,what,zstack,filename
end mouseUp
   ک Wheat      s              	       " 
invReport   on closeCard
  global gDontSave
  put true into gDontSave
  if the visible of group "font" then hide group "font"
end closeCard
  w        Black Ԡ Gold ffffff      white       	darkgray    
 ?         Inventory Report      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica  	 U 
Helvetica   U Georgia   U Georgia   U Georgia  
 U Georgia   U Geneva   U LB Helvetica Black   U Swis721 BdCn BT   U Swis721 BdCnOul BT   U Swis721 BdOul BT   U Swis721 BdRnd BT   U Swis721 BlkRnd BT   U Swis721 BdRnd BT   U Swis721 BdRnd BT   U LB Helvetica Black   U LB Helvetica Black  
 U B Friz Quadrata Bold  
 U 	Capitals   U 	Capitals  
 U C Helvetica Condensed       	@          ?&                   
Close Window Ex   on mouseUp
  global gDontSave
  put true into gDontSave
  lock screen
  close this stack
  goStack "invReportOpts"
  unlock screen with visual plain
end mouseUp
   ک Wheat    [              	        Save as... Ux  son mouseUp
  lock screen
  put the short date into whichDate
  repeat while offset("/",whichDate) > 0
    put "_" into char offset("/",whichDate) of whichDate
  end repeat
  ask file "Save Inventory report as... " with "inventory_report_" & whichDate & ".txt"
  
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  
  open file fileName for write
  if the result is empty then
    write "Inventory Report as of " & the long date & return & return to file fileName
    
    set the itemDelimiter to tab
    repeat with i = 1 to the number of lines of field "report"
      put line i of field "report" into temp
      delete item 6 to 7 of temp
      write temp & return to file fileName
    end repeat
    
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   ک Wheat     X             	        Print Ux   &on mouseUp
  printReport
end mouseUp
   ک Wheat    H             	        Font Ux  on mouseUp
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  put the textHeight of field "report" into field "lheight"
  show group "font"
  unlock screen with visual wipe right
end mouseUp
   ک Wheat   J H             	        font   a            font bg E`  ک Wheat                  	        bgrect   K@              v   
   fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @         Close Ex   `on mouseUp
  lock screen
  hide group "font"
  unlock screen with visual wipe left
end mouseUp
   ک Wheat    `              	     
   inst 	                      +Pick a font face and size for your report.    sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K   9 pt @D  ک Wheat     8              	      10 pt @D  ک Wheat     8              	     11 pt @D  ک Wheat     8              	      12 pt @D  ک Wheat     8              	      14 pt @D  ک Wheat     8              	      16 pt @D  ک Wheat     8              	   
  
 
instruction2 	         z  ,           KAfter making changes to the font or size, you may need to adjust the tabs. 
   label2 
         T             Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
        '            13    Tabs Ex  on mouseUp
  global gContactTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    set the tabstops of field "report" to "100,225,375"
    put the tabstops of field "report" into gContactTabs
    break
    
  case "Custom"
    if gContactTabs is empty then put the tabstops of field "report" into gContactTabs
    ask "Set the tab stops of the report field to" with gContactTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gContactTabs
    end if
  end switch
end mouseUp
   ک Wheat   ` `              	       " 
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
   ک Wheat   < `              	     
   report 	x 	 
 )on mouseUp
  goReportLine 8
end mouseUp
        	 +x 
 
 
 
    }                  	`    @ #  v    size   a         Z
   short  )h 	 
         <           %button "Close Window"	91,410,223,431  $button "Save as..."	232,410,320,431  button "Print"	411,410,483,431  button "Font"	330,410,402,431  field "report"	9,24,564,400       	`    @  	  : 
   long  )h 	 
         <           %button "Close Window"	91,519,223,540  $button "Save as..."	232,519,320,540  button "Print"	411,519,483,540  button "Font"	330,519,402,540  field "report"	9,24,564,508       	`    @ 	 	  :    putLong Ex  
-on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 4
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field 2 & tab & the rect of field 2 after field whichField
end mouseUp
   ک Wheat    H :              	        setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   ک Wheat    H :              	         	putShort Ex  
.on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 4
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field 2 & tab & the rect of field 2 after field whichField
end mouseUp
   ک Wheat    H :              	       ! 	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   ک Wheat   S H :              	     
   instruction 	  
                    JClick the Purchase Date or an item name in the list to go to that record.     ivyHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard
  w        Black Ԡ Gold ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w         Inventory Report   	@          w       	Tutorial   	@          w       Inventory Tracker   	@          w       Preferences   	@          w       Keyboard Shortcuts   	@          w      & Importing/Export items   	@          w    * About Adding Items   	@          w    . Add/Select Item   	@          w    / Adding a New Record   	@          w     Date, Qty & Price Sold   	@          w    1 Adjusting the Date   	@          w    3 Background Color   	@          w     Button Colors   	@          w    7 Changing Items   	@          w    : Choose Date   	@          w    < Choose Item   	@          w    B Create item   	@          w     !Cost Each, Quantity & Total Cost   	@          w    D Default Settings   	@          w    G Delete item   	@          w    H Deleting Records   	@          w    I 
Edit Date   	@          w    M Exporting Records   	@          w     
First Record   	@          w      Font   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w    ] Modify item   	@          w     Next Record   	@          w     Prev Record   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w     Sorting Records   	@          w    z 
Today's Date   	@          w    { Visual Effects   	@          w     Help Index   	@          w    !               help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         About Help 
  @        
  
  @          #Welcome to Inventory Tracker Help. 
 @        Black    "   Listed in this Help system are all the features, fields and buttons of Inventory Tracker. (Buttons are things you click on and fields contain text.) 
         You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
         Each "record" in Inventory Tracker consists of the purchase date, quantity, Item description, size, other description, dates sold and notes.  You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   The Inventory Tracker window is where you can keep track of the purchase date, quantity, size, date sold and notes about your inventory. 
       
 @      Blue   
      s   jThe Inventory Report window is where you can create inventory reports sorted by date or item description. 
       
 @      Blue   
      
 @        Black   
      M  
         }The Preferences window is where you can change background and button colors and the general "look and feel" of the program.  
       
  @       
      m   jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470      Inventory Tracker 
  @          
  @          SThe Inventory Tracker window is where you will add all your inventory information. 
 @        Black    
 @      red   
 @        Black   5  Each "record" in Inventory Tracker consists of the date, an item description, two additional description fields, the cost for each item, the quantity purchased, the total cost, and the retail price. There is also a field for keeping track of the date, quantity and price of items sold as well as a field for notes.  In Tall Windows mode, there are two additional fields, total remaining in stock and remaining stock value (based on the retail price). You can add new records or edit the information for any record at any time.   rThe Date field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. Enter the current date by clicking the Today button. You can also use the date chooser by clicking Choose. See Choose Date for more information. You can go directly to the first record with a particular date by clicking the Date label. 
       
      
      Z
     b 
     f G
      
      7
      
      
  @       
      
     N
    e 
    j   -To add a new item, click the Add/Select Item button. Next click the Create Item button. Enter the name for the new item. The maximum length for item names is 32 characters. To transfer the new item name to the current record, click the Choose Item button. For more information see About Adding Items. 
       
 @      Blue   
     , 
     D 
     O 
      
      "
  @        You can enter two other descriptions of your item in the Description 1 field and the Description 2 field. You may change the name of either of these fields by clicking the corresponding Change button. For instance you might want to change the field names to Size and Color. 
       8
     8 
     F 
     U 

     b X
      
      Q  Next enter the cost of each item in the Cost Each field by clicking the field or the Edit button above it. Then enter the quantity purchased in the Quantity field by clicking the field or the Edit button above it. The Total Cost will be automatically calculated. Alternately, you can enter the quantity and the total cost and the Cost Each field will be automatically calculated. Finally, enter the retail price in the Retail Price Each field by clicking the field or the Edit button above it. In Tall Windows mode, the number of items Remaining in Stock and the Remaining Stock Value will also be displayed. For more information about Tall Windows see Preferences. 
       (
     ( 	
     1 $
     U 
     Y ;
      
      $
      
      
      

      f
    J 	
    S P
     
     $
     
     <
     
    + 
    3 
    H 
    a ,
  @      
        <You can also keep notes about this item in the Notes field. 
       /
     / 
     4    Keeping track of items sold 
  @          
  @         "As the items for this record are sold, you can keep track of the date, quantity and sale price in the Date, Qty & Price Sold field by clicking the Today or Choose button above the field. You will be asked to choose a date, enter the number sold and then the amount each items was sold for. 
       f
     f 
     | 
      
      
      
      7If you make a mistake, you can delete a line in this field by clicking the line and then clicking the Delete Line button that appears. If you change your mind about deleting the line at this point, you can click in the field just below the last line or just outside of the field to hide the Delete Line button. 
       f
     f 
     q    0Adding, Deleting, Searching and Sorting Records 
  @        /  
  @         To add a new record click the New button. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Item Information, only the current item information will be copied onto the new record. If you choose With Notes, then all information from the current record will be copied to the new record. If you choose Blank Record, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     ! 
      
      V
     

     _
    z 
     i  <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
         You can sort records by clicking the Sort button. You will be asked if you want to sort the records by Date or item. All records are renumbered after sorting. 
       %
     % 
     ) J
     s 
     t *  
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are a couple of reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b A  
         1) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version of Inventory Tracker.    The exported file is called inventory_records.txt and contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       
 @      Red   
     1 R
 @      Blue   (   You can export one or all records, or records that are newer or older than a certain date. See Exporting Records for more information. 
       _
  @      _ 
     p   
         Other Buttons 
  @        
  wYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Inventory Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q |
      
      
      
      4
     
     
    & 
    * /
 @      Blue Y X
     0
     
        The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Monetary Symbol. For more information see Preferences. 
       
      
     	 
  @       
     1 t
  @       
        
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _    /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    The Inventory Report button takes you to a window where you can choose options for your reports. See Inventory Report  for more information. 
       
      
 @        Black   
      P
 @      blue  e 
     u    mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   The Quit button saves the data and quits the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination, but using this button is better. 
       
      
      .
     6          Inventory Report 
  @          
  @          5You can generate several different types of reports. 
 @        Black    4   iEasily create Inventory reports by clicking the Inventory Report button in the Inventory Tracker window. 
       0
     0 
     @ 
 @      Red  N   DThe Purchase Date, Cost, Quantity and Item Description are included in all reports. You may also add any of the following Options by clicking the appropriate checkbox in  the Inventory Report Options window: Show Cost, Show Retail Price, Show Other Descriptions, Show Item Totals, Show Date & Quantity Sold, and Show Notes. 
       z
     z 
      .
 @      Red   !
      s  
         kYou must specify a Start Date, an End Date  or select All Dates before clicking the Create Report button.  
       
      

      
     " 
     * 
     6 

     @ 
     T 

     a 
     i   
         eYou  can select any specific item from the list of click the All Items button for a complete report. 
       <
     < 
     G   
         The list can be sorted by clicking one of the Sort By radio buttons. The choices are Purchase Date, Item Description, Description 1 and Description 2 (or whatever you have changed these labels to).  
       .
     . 
     5  
     U /
      
      
      0  
         8Click the Create Report button to generate the report.  
       

     
 

      
     6    Click any item description in  the report to go directly to that item's record. If you click a line in the report and nothing happens, you need to click the line with the date, cost, quantity and item description.    The font face, size, line height and tab stops of the list can be modified by clicking the Font button in the Inventory Report window. See Font  for more information. 
       [
     [ 
     _ 
 @      Red  n 
      
 @      Blue   
         YYou can print the task list by clicking the Print button in the Inventory Report window. 
       ,
     , 
     1 
 @      Red  @    To save the list as a text file for importing into another program click the Save as... button in the Inventory Report window. 
       M
     M 

     W 
 @      Red  f   
          & Importing/Export items 
  @          BYou can import or export lists of items. Just click the Import/Export button in the Item Descriptions Window.  If you choose Import, you will be asked to locate an items.txt file. If you choose Export, save the items.txt file to your computer so that you can then import it into another module of this productivity suite. 
       8
     8 

     E 
 @      Red  T 
     n 
     } 
      !
 @      Red   
 @      Red   
      
      
      
 @      Red   
 @      Red   
      e   Preferences 
  @          
  @          AThere are several preferences you can set for Inventory Tracker. 
 @        Black    @   ZTo access the Preferences window, click the Prefs button in the Inventory Tracker window. 
       ,
     , 
     1 
 @      Red  @ 
     X   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D   You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   /There is a visual effect that helps to indicate the movement from one record to another in the Inventory Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       p
 @      red  p 
     w 
    
 
     
     
     
  @      
    -   KYou can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed in the Inventory Tracker window and in all the reports. 
       
      
      
 @      Red  
    2   
        NIf your screen is larger than 640x480, the Inventory Tracker window will open in Tall Windows mode. This allows for slightly larger buttons and fields near the bottom of the screen. If you have a small screen, this feature is not available. If for some reason you prefer shorter windows, you can turn this feature off in this window. 
       +
 @      Red  + 
     C 
 @        Black  Q 
     ]   
        The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U  
         WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <         xx    	Tutorial 
  @          
  @          SHere's a quick tutorial for those just getting started with the Inventory Tracker. 
 @        Black    R  Each "record" in Inventory Tracker consists of the date, an item description, two additional description fields, the cost for each item, the quantity purchased, the total cost, and the retail price. There is also a field for keeping track of the date, quantity and price of items sold as well as a field for notes.  In Tall Windows mode, there are two additional fields, total remaining in stock and remaining stock value (based on the retail price). You can add new records or edit the information for any record at any time.   To add a new record click the New button. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Item Descriptions, only the current item information will be copied onto the new record. If you choose With Notes, then all information from the current record will be copied to the new record. If you choose Blank Record, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     ! 
      
      V
     

     _
    { 
     i   The Date field is filled in automatically. You can easily change it at any time by clicking the Today, Edit, or Choose buttons. For more information see Adjusting the Date.  
       
      
      X
     ` 
     e 
     g 
     k 
     p 
     v #
  @       
        -To add a new item, click the Add/Select Item button. Next click the Create Item button. Enter the name for the new item. The maximum length for item names is 32 characters. To transfer the new item name to the current record, click the Choose Item button. For more information see About Adding Items. 
       
      
     , 
     D 
     O 
      
      "
  @        You can enter two other descriptions of your item in the Description 1 field and the Description 2 field. You may change the name of either of these fields by clicking the corresponding Change button. For instance you might want to change the field names to Size and Color. 
       8
     8 
     F 
     U 

     b X
      
      Q  Next enter the cost of each item in the Cost Each field by clicking the field or the Edit button above it. Then enter the quantity purchased in the Quantity field by clicking the field or the Edit button above it. The Total Cost will be automatically calculated. Alternately, you can enter the quantity and the total cost and the Cost Each field will be automatically calculated. Finally, enter the retail price in the Retail Price Each field by clicking the field or the Edit button above it. 
       (
     ( 	
     1 $
     U 
     Y ;
      
      $
      
      
      

      f
    J 	
    S P
     
     $
     
        <You can also keep notes about this item in the Notes field. 
       /
     / 
     4    Keeping track of items sold 
  @          
  @         "As the items for this record are sold, you can keep track of the date, quantity and sale price in the Date, Qty & Price Sold field by clicking the Today or Choose button above the field. You will be asked to choose a date, enter the number sold and then the amount each items was sold for. 
       f
     f 
     | 
      
      
      
      7If you make a mistake, you can delete a line in this field by clicking the line and then clicking the Delete Line button that appears. If you change your mind about deleting the line at this point, you can click in the field just below the last line or just outside of the field to hide the Delete Line button. 
       f
     f 
     q    Other features: 
  @          
        wYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Inventory Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q |
      
      
      
      4
     
     
    & 
    * /
 @      Blue Y X
     0
     
        Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         You can sort records by clicking the Sort button. You will be asked if you want to sort the records by Date or Item. All records are renumbered after sorting. 
       %
     % 
     ) J
     s 
     t *   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Inventory Tracker at any time. You will want to export your data when updating to a newer version of Inventory Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @     p 
     
  @      
       
  @         If your screen is larger than 640x480, the Inventory Tracker window will open in Tall Windows mode. This allows for slightly larger buttons and fields near the bottom of the screen. You also get two additional fields, total remaining in stock and remaining stock value. If you have a small screen, these fields are not visible. If for some reason you prefer shorter windows, you can turn this feature off in the Preferences window. 
       +
 @      Red  + 
     C 
 @        Black  Q 
     ] i
      F
     
  @      
       
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, Monetary Symbol, etc. For more information see Preferences. 
       ,
     , 
     1 t
  @         
        You can close the current window by using the Control + w (or command + w on the Mac) key combination. It is usually better to use the Close Window button, if there is one, or choose another tool from the Small Business Tracker Menu instead of using this shortcut though. 
       
      
      :
      
      '  
         The Save button saves your data. All records are saved automatically when going to another record or when you Quit the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      f
     n 
     r |  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
              1 Adjusting the Date 
  @          The date can be adjusted several ways. If you want to enter today's date, click the Today button above the Purchase Date field. If you want to edit the Purchase date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y 
     k 

     x B
      
      F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %       * About Adding Items 
  @           You can enter any number of items into Inventory Tracker. Item descriptions are limited to 32 characters, but commas and other special characters are permitted.    To choose an item, click the Add/Select Item button. Then select an item description and click the Choose Item button. You may also double-click on the item description. 
       
      
     , 
     I 
     T 
     c 
     n /
      
        To create a item description, click the Add/Select Item button. Then click the Create Item button and enter a name. The maximum length for item description is 32 characters. To transfer the new item description to the current record, click the Choose Item button. 
       (
     ( 
     7 
     O 
     [ 5
      
      ,
      
      "
      
         To modify an item description, click the Add/Select Item button. Then select an item description to modify and click the Modify Item button. You will be asked for a new name. All records with the old item name will be updated with the new name. 
       )
     ) 
     8 
     U 
     ` 
     y 
      *
  @       E
         To delete an item description, click the Add/Select Item button. Then select an item description to delete and click the Delete Item button.  
       )
     ) 
     8 
     U 
     ` 
     y 
      	  
        To import or export a list of item names, click the Import/Export  button. If you choose Import, you will be asked to locate a items.txt file. If you choose Export, save the items.txt file to your computer so that you can then import it into a newer version of Inventory Tracker. 
       4
     4 
     B 
     Y 
     _  
 @      Red   
 @      Red   
      
      
      
 @      Red   
 @      Red   
      `        Font 
  @          
         Before printing you may want to adjust the font, size or line height of the report  text by clicking the Font... button. Choose a new font by clicking its name in the font list. 
       i
     i 
     p A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  
        You can also set the tab stops of the report or invoice text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report has been generated. 
       
      .
     M 
     T 
     i 
     l *
      
      
      
      
 @      Blue { D  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H   
                 Keyboard Shortcuts 
  @          
  @          )Many buttons have a keyboard equivalent. 
 @        Black    (  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    $Inventory Tracker window shortcuts: 
 @        Black    
      
 Add/Select - a  New - n  Delete - d  Inventory Report - r  Schedule Event -e  Find Contact - f  Save -s  	Quit - q    +Inventory Report Options window shortcuts: 
 @        Black     
       
 	Help - h  Close Window - c  Create Report - r  	Save - s    #Inventory Report window shortcuts: 
 @        Black    
      
 	Help - h  Close Window - c  Save as - v  	Font - f  
Print - p  	Save - s    Add/Item Window shortcuts: 
        Choose Item - i  Create item - r  Modify Item - m  Delete Item - d  Import/Export - i  Close Window - c  $Move up in list of items - Up arrow  (Move down in list of items - Down arrow    Help window shortcuts: 
        About Help - a  Inventory Tracker - i  Inventory Report - r  Keyboard Shortcuts- k  
Tutorial - t  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c         g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting. You can quit the program from any window by using the Control + Q (or command + q on the Macintosh) key combination. 
       ?
     ? 
     C       M Exporting Records 
  @          3You can export the records to a text file by clicking the Export button. You will be asked if you want export All records or just Specific ones. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       :
     : 
     @ .
     n 
     y 	
      
      
      
      $
 @      Blue   l   If you choose Specific you will then be asked if you want to export Old records, New records or item records. If you click the item button, only records for the item on the current record will be exported. 
       
      
      .
     D 
     G 

     Q 
     T y   If you choose New, you will be asked to enter a date. Only records newer than that date will be exported. Using this feature allows you to export just the records for the last week (for example) so that they can be sent to an administrator for importing. 
       
      
        
         If you choose Old, you will also be asked to enter a date. Only records older than that date will be exported. This feature is useful if you want to delete old records, but want to export and archive them first. 
       
      
        
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
         
         You can export records which have their timer running. However, when these records are imported again, the timer will be paused at the time it was exported. The note "timer running or paused" is added to the exported record. 
       
      :   @There are a couple of reasons you might want to export records: 
  @        ? 1) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.   
  @          The exported file is called inventory_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       
 @      Red   
  @      . 
     1 n
  @       '      i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )         H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v          Date, Qty & Price Sold 
  @          9As the items for this record are sold, you can keep track of the date, quantity and sale price in the Date, Qty & Price Sold field by clicking the Today or Choose button above the Date, Qty & Price Sold field. You will be asked to choose a date, enter the number sold and then the amount each items was sold for. 
       f
     f 
     | 
      
      
      
      
      
      m  MIf you make a mistake, you can delete a line in the Date, Qty & Price Sold field by clicking the line and then clicking the Delete Line button that appears. If you change your mind about deleting the line at this point, you can click in the field just below the last line or just outside of the field to hide the Delete Line button. 
       4
     4 
     J 2
     | 
        7 Changing Items 
  @           To add a new item description to the current record, click the Add/Select Item button. Then select the new description and then click the Choose Item button. You may also double-click on the item description to add the item to the current record. 
       ?
     ? 
     N 
     k 
     v 
      
      /
      
      '  UTo change items, click the Add/Select Item button. If you want to modify an existing item description, select the item to be changed, click the Modify Item button and enter a new description. The maximum length for item descriptions is 32 characters. To transfer the new item description to the current record, click the Choose item button. 
       
      
     * 0
     Z 
     e +
      
      
      
      
      
      -
     
     "
    A 
    L         . Add/Select Item 
  @          NTo add a new item description, click the Add/Select item button. Next click the Create item button. Enter the description for the new item. The maximum length for item descriptions is 32 characters. To transfer the new item description to the current record, click the Choose item button. For more information see About Adding Items. 
       )
     ) 
     8 
     P 
     [ 
     n 
     y /
      
      -
      
      !
     
     "
  @     :          
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H         !Cost Each, Quantity & Total Cost 
  @            oYou can enter the cost of each item in the Cost Each field by clicking the field or the Edit button above it.  
       +
     + 	
     4 $
     X 
     \    Then enter the quantity purchased in the Quantity field by clicking the field or the Edit button above it. The Total Cost will be automatically calculated.  
       )
     ) 
     1 $
     U 
     Y 
     o 

     y #   uAlternately, you can enter the Quantity and the Total Cost and the Cost Each field will be automatically calculated. 
       
      
     ' 	
     0 

     : 	
     C 	
     L (    rFinally, enter the retail price in the Retail Price Each field by clicking the field or the Edit button above it. 
       '
     ' 
     8 $
     \ 
     `     B Create item 
  @          >To create an item description, click the Add/Select Item button. Then click the Create Item button and enter a description. The maximum length for item descriptions is 32 characters. To transfer the new item description to the current record, click the Choose Item button. For more information see About Adding Items. 
       )
     ) 
     8 
     P 
     [ 
     o 
     z 
      
      -
      
      "
      
     "
  @     *         / Adding a New Record 
  @          To add a new record click the New button. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Item & Description, only the current item information will be copied onto the new record. If you choose With Notes, then all information from the current record will be copied to the new record. If you choose Blank Record, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     ! 
      
      V
     

     _
    | 
     i        { Visual Effects 
  @          ,There is a visual effect that helps to indicate the movement from one record to another in the Inventory Tracker window when using the arrow keys. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
       p
 @      red  p 
     w 
     
    	 
    
 
     
  @      
    *    See also Record #. 
       	
 @      Blue  	 	  z 
Today's Date 
  @           cTo easily enter today's date into a record, click the Today button above the Purchase Date  field. 
       6
     6 
     ; 
     M 

     Z    dYou can go directly to the first record with a particular date by clicking the Purchase Date label. 
       O
     O 

     \      Sorting Records 
  @           You can sort records by Date or item  by clicking the Sort button in the Inventory Tracker window.  All records are renumbered after sorting. 
       
      
      
     6 
     : 
 @      red  H 
     a ,    o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S     n Save Record 
  @           You can save all the data in the Inventory Tracker window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
        
 @      Red    
     9 
     J 
     N c         Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C  h 	Record # 
  @          Each Record in Inventory Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       /
  @      / 6
     e <
      
      <
  @       
      
  @       
      
  @       
     
  @      
        The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	    Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
            Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           ] Modify item 
  @          )To modify an item description, click the Add/Select Item button. Then select an item description to modify and click the Modify Item button. You will be asked for a new description. All records with the old item name will be updated with the new name. For more information see About Adding Items. 
       )
     ) 
     8 
     U 
     ` 
     y 
      %
      
      
  @       F
      
  @              Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F    W Importing Records 
  @          3You can import previously exported records by clicking the Import button in the Inventory Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones. You then will be asked to locate an inventory.txt file to import.  
       ;
     ; 
     A 
 @      Red  P 
     h )
      
      *
      
      P
 @      Red  

    !    ,See Exporting Records for more information. 
       
  @       
          V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Inventory Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O  
 @      red  o 
     v 
      
      F        I 
Edit Date 
  @        	   The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %       G Delete item 
  @           To delete an item description, click the Add/Select Item button. Then select an item description to delete and click the Delete Item button. 
       )
     ) 
     8 
     U 
     ` 
     x 
              D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     < Choose Item 
  @          To choose an item description, click the Add/Select Item button. Then select an item description and click the Choose Item button. You may also double-click on the item description to add it directly to the current record. For more information see About Adding Items. 
       (
     ( 
     9 
     U 
     ` 
     o 
     z /
      
      D
  @               : Choose Date 
  @          <One method for changing a date, is to click the Choose button above the Purchase Date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6 
     H 

     U      Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G           Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
   ک Wheat      ]             	        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
   ک Wheat      ~             	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
   ک Wheat     " P             	        Inventory Tracker Ex   Pon mouseUp
  lock screen
  push card
  go card "Inventory Tracker"
end mouseUp
   ک Wheat    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
   ک Wheat     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
   ک Wheat     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
   ک Wheat     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
           ک Wheat     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Inventory Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
   ک Wheat     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
   ک Wheat     y             	        	devtools   a         tH    Save Ex   *on mouseUp
  save this stack
end mouseUp
   ک Wheat    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
   ک Wheat    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
   ک Wheat   x 2              	        go prev Ex   'on mouseUp
  go prev card
end mouseUp
   ک Wheat    x Q              	        Inventory Report Ex   Oon mouseUp
  lock screen
  push card
  go card "Inventory Report"
end mouseUp
   ک Wheat    l  p             	           K        
  ^          K        ^             K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Adding Items  About Help  Add/Select Item  Adding a New Record  Adjusting the Date  Background Color  Button Colors  Changing Items  Choose Date  Choose Item  !Cost Each, Quantity & Total Cost  Create item  Date, Qty & Price Sold  Default Settings  Delete item  Deleting Records  
Edit Date  Exporting Records  
First Record  Font  Highlight Color  Importing Records  Importing/Export items  Inventory Report  Inventory Tracker  Keyboard Shortcuts  Last Record  Look and Feel  Modify item  Next Record  Preferences  Prev Record  Quit  	Record #  
Registration  Save As...  Save Record  Searching Records  Sorting Records  
Today's Date  	Tutorial  Visual Effects         	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
   ک Wheat      `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
   ک Wheat    D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
   ک Wheat     ` 8             	        reindex and sort EpMon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put line 1 of field "main" of card i  & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp
   ک Wheat    T               	        
replace text Ep on mouseUp
  repeat forever
    find string "items window"
    if the result is "not found" then exit repeat
    put "Inventory Tracker Window" into the foundchunk
  end repeat
end mouseUp
   ک Wheat     t 0             	           K        i  t       invReportOpts  on keyDown which
  if commandKey() AND which is "q" then
    save this stack
    quit
  end if
  if commandKey() AND which is "w" then
    close this stack
  end if
  pass keyDown
end keyDown

function checkItems cardNum
  if field "item" of card cardNum of stack "inventory" is empty \
      OR field "cost" of card cardNum of stack "inventory" is empty \
      OR field "qty" of card cardNum of stack "inventory" is empty \
      OR field "total" of card cardNum of stack "inventory" is empty \
      OR field "price" of card cardNum of stack "inventory" is empty then
    return true
  else
    return false
  end if
end checkItems

on checkTime
  set the hilite of button "all dates" to false
  put field "start"  into startDate
  put field "end" into endDate
  convert startDate to seconds
  convert endDate to seconds
  if endDate < startDate then
    answer "The End Date that is earlier than the Start Date."
    exit to metaCard
  end if
end checkTime
  w        Black Ԡ Gold ffffff      white       	darkgray    
          Inventory Report Options    
  U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial       	@                 D  E        V  W  d  e  \  ]  _                          
   Start  	x  on mouseUp
  global gDateField,gDateStack
  global gStartDate
  put field "start" into gStartDate
  
  if field "start" is empty then
    ask "Enter a Start Date" with the date
  else
    ask "Enter a Start Date" with field "start"
  end if
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer warning "All dates must be in the format dd/mm/yy. Try again."
    exit mouseUp
  else
    put it into field "start"
  end if
  
  if it is not a date then
    ask "You entered an invalid Start Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Start Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into field "start"
    end if
  else
    put it into field "start"
  end if
  if field "end" is not empty then
    put "start" into gDateField
    checkTime
  end if
end mouseUp
         v b                      
   End  	x  ron mouseUp
  global gDateField,gDateStack,gEndDate
  
  put field "end" into gEndDate
  
  if field "end" is empty then
    ask "Enter an End Date" with the date
  else
    ask "Enter an End Date" with field "end"
  end if
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer warning "All dates must be in the format dd/mm/yy. Try again."
    exit mouseUp
  else
    put it into field "end"
  end if
  
  if it is not a date then
    ask "You entered an invalid End Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid End Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into field "end"
    end if
  else
    put it into field "end"
  end if
  put "end" into gDateField
  checkTime
end mouseUp
          b                
   
instruction2 	          X J           To create a report, select a start date, an end date, select any number of items (hold shift key to select multiple items) or select All. Then choose any Options and a Sort Order, and click on Create Report.   D Edit Ex  
 8on mouseUp
  send mouseUp to field "Start"
end mouseUp
   ک Wheat     c (              	       E Edit Ex  
 6on mouseUp
  send mouseUp to field "end"
end mouseUp
   ک Wheat      (              	       V Today Ex  
 on mouseUp
  global gStartDate,gDateField
  put field "start" into gStartDate
  if field "end" is empty then
    put the date into field "end"
  end if
  put the date into field "Start"
  put "start" into gDateField
  checkTime
end mouseUp
   ک Wheat    \ c (              	       W Today Ex  
 on mouseUp
  global gEndDate,gDateField
  put field "end" into gEndDate
  put "End" into gDateField
  put the date into field "end"
  checkTime
end mouseUp
   ک Wheat    \  (              	       \ Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "ivyHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "Inventory Report", helpStack, zStack
end mouseUp
   ک Wheat    
 H             	       ] 
Close Window Ex   on mouseUp
  global gDontSave
  put true into gDontSave
  lock screen
  close this stack
  goStack "inventory"
  unlock screen with visual plain
end mouseUp
   ک Wheat    \              	       _ Save Ux   @on mouseUp
  set cursor to watch
  save this stack
end mouseUp
   ک Wheat   < H              	       d Choose Ex  
yon mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "start" into gStartDate
  put "start" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Select a Start Date"
  go stack "dates"
end mouseUp
   ک Wheat    z y 4              	       e Choose Ex  
ton mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "end" into gStartDate
  put "end" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Select an End Date"
  go stack "dates"
end mouseUp
   ک Wheat    z  4              	     
    startDate label 	          _ d            Start Date 
   endDate label 	           d            	End Date    sort   i        C I   Sort Order  D    ک Wheat    MG b              	      Purchase Date @D    ک Wheat    ]               	     Item Description @D    ک Wheat    r               	      
description1 @d    ک Wheat    ]       
Description1          	      
description2 @d    ک Wheat    r       
Description2          	   
   label2           [ l            
Select Items 
   items 	x   Kon mouseUp
  set the hilite of button "all projects" to false
end mouseUp
         q                    	`    @ s r      Show Other Descriptions @E  on mouseUp
  set the disabled of button "description1" to not the hilite of me
  set the disabled of button "description2" to not the hilite of me
  if the disabled of button "description2" AND ( the hilite of button "description1" \
      OR  the hilite of button "description1") then
    set the hilite of button "purchase date" to true
    set the hilite of button "description1" to false
    set the hilite of button "description2" to false
  end if
end mouseUp
   ک Wheat                   	       
All Dates @E   Ton mouseUp
  put empty into field "start"
  put empty into field "end"
end mouseUp
   ک Wheat      P              	       
All projects @e   Ion mouseUp
  set the hilitedLines of field "items" to empty
end mouseUp
   ک Wheat   @ ^ P      
All Items          	       Show Item Totals @E    ک Wheat                    	       
List Options  D    ک Wheat      h              	      Show Date & Quantity Sold @E    ک Wheat                   	        Show Notes @E    ک Wheat    & p              	        
Show Cost @D    ک Wheat                    	  	        Show Retail Price @D    ک Wheat                   	     Create Report Mx  ,jon mouseUp
  global gCurrentCard,gInventoryTabs,gDollarSign,gRegistered,gTallWindows
  global gDescription1,gDescription2
  
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    close this stack
    go stack "Register"
    exit mouseUp
  end if
  
  put "inventory" into gStack
  lock screen
  if the hilitedButtonName of group "sort" is empty then
    set the hilitedButtonName of group "sort" to "Purchase Date"
  end if
  
  if NOT the hilite of button "all dates" then
    put field "start"  into startDate
    if startDate is not a date or startDate is empty then
      ask "Enter a valid Start Date." with the short date
      if it is empty then exit mouseUp
      put it into field "start"
      put it into startDate
      if startDate is not a date then exit mouseUp
    end if
    
    put field "end" into endDate
    if endDate is not a date or endDate is empty then
      ask "Enter a valid End Date." with the short date
      if it is empty then exit mouseUp
      put it into field "end"
      put it into endDate
      if endDate is not a date then exit mouseUp
    end if
    
    convert startDate to seconds
    convert endDate to seconds
    checkTime
  end if
  
  if the hilitedLines of field "items" is empty and not the hilite of button "all projects" then
    answer information "Report on specific or all items?" with "Specific" or "All Items"
    if it is "All Items" then
      set the hilite of button "all projects" to true
      put "All" into whichProject
    else
      answer information "Select as many items as you want to include in the report. " & return \
          & "Hold down the shift key to select more than one."
      exit mouseUp
    end if
  else
    if the hilite of button "all projects" then
      put "All" into whichProject
    else
      put the hilitedLines of field "items" into whichProject
    end if
  end if
  
  put  "Purchase Date" & tab & "Cost " & tab & "Qty" & tab & "Item Description"  into temp
  put tab & "Retail" & tab & "Left in stock" after temp
  put temp & return & return into field "report" of stack "invReport"
  put "125,175,215,385,450" into gInventoryTabs
  set the tabstops of field "report" of stack "invReport" to gInventoryTabs
  
  set the itemDelimiter to tab
  put 1 into sortLine
  put the hilitedButtonName of group "sort" into sortBy
  if sortBy is "Purchase date" then put "date" into sortBy
  if sortBy is "item description" then put "item" into sortBy
  
  put true into nodata
  put the number of cards of stack "inventory" into zcards
  
  repeat with i = 1 to zcards
    if zcards > 50 then set cursor to busy
    if checkItems(i) then next repeat
    put field "date" of card i of stack gStack into theDate
    convert theDate to seconds
    if NOT the hilite of button "all dates" then
      if (theDate < startDate) or (theDate > endDate) then next repeat
    end if
    put theDate into temp
    
    if whichProject <> "all" then
      put field "item" of card i of stack gStack into theProject
      set the itemDelimiter to comma
      put true into skipRecord
      repeat with n = 1 to the number of items of whichProject
        if theProject is line (item n of whichProject) of field "items" then
          put false into skipRecord
          exit repeat
        end if
      end repeat
      set the itemDelimiter to tab
      if skipRecord then next repeat
    end if
    
    if sortBy is "date" then
      put field "item" of card i of stack gStack into item 2 of temp
    else
      put field sortby of card i of stack gStack into item 2 of temp
    end if
    put i into item 3 of temp
    put temp into line sortLine of zSorter
    add 1 to sortLine
    put false into nodata
  end repeat
  
  if nodata then
    unlock screen with visual plain
    answer information "There was no inventory found for these options."
    exit to metacard
  end if
  
  if sortBy is "date" then
    sort lines of zSorter  by item 2 of each
    sort lines of zSorter  by item 1 of each
  else
    sort lines of zSorter by item 1 of each
    sort lines of zSorter  by item 2 of each
  end if
  
  put 0 into zTotalItems
  put 0 into zTotalSold
  put 0 into zTotalCostofItemsSold
  put 0 into zTotalCost
  put 0 into zTotalSales
  put 0 into zTotalNetValue
  put 0 into zTotalNetProfit
  put 0 into zTotalAllItemsLeft
  
  repeat with n = 1 to the number of lines of zsorter
    put item 3 of line n of zsorter into cardNum
    put 0 into zTotalItemsSold
    put 0 into zTotalItemSales
    put 0 into zTotalItemCost
    put 0 into zTotalItemsLeft
    put 0 into zTotalItemProfit
    
    add validateNumber(field "total" of card cardNum of stack gStack) to zTotalCost
    put validateNumber(field "cost" of card cardNum of stack gStack) into zCost
    put validateNumber(field "qty" of card cardNum of stack gStack) into zQty
    add zQty to zTotalItems
    put field "dates sold" of card cardNum of stack gStack into dsold
    
    set itemdelimiter to comma
    repeat with l = 1 to the number of lines of dsold
      put word 1 of line l of dsold into znumSold
      add znumSold to zTotalSold
      add znumSold to zTotalItemsSold
      put validateNumber(word 6 of line l of dsold) into zprice
      add (validateNumber(zcost) *  znumSold) to zTotalItemCost
      add (zprice *  znumSold) to zTotalItemSales
    end repeat
    put zQty -  zTotalItemsSold into zTotalItemsLeft
    if zTotalItemsLeft > 0 then
      add (validateNumber(field "price" of card cardNum of stack gStack) * zTotalItemsLeft) to zTotalNetValue
    end if
    put zTotalItemSales - zTotalItemCost into zTotalItemProfit
    add zTotalItemProfit to zTotalNetProfit
    add zTotalItemSales to zTotalSales
    put zTotalSold - zTotalCost into zProfit
    add zTotalItemCost to zTotalCostofItemsSold
    
    set itemdelimiter to tab
    put field "date" of card cardNum of stack gStack into temp
    convert temp to abbr date
    put tab & field "price" of card cardNum of stack gStack after temp
    put tab & field "qty" of card cardNum of stack gStack & tab after temp
    put field "item" of card cardNum of stack gStack & tab after  temp
    put field "price" of card cardNum of stack gStack & tab after temp
    if zTotalItemsLeft > 0 then
      put zTotalItemsLeft & tab after temp
    add zTotalItemsLeft to zTotalAllItemsLeft
    else
      put "<" & zTotalItemsLeft & ">" & tab after temp
    end if
    put cardNum into item 8 of temp
    put temp & return after field "report" of stack "invReport"
    
    --  if the hilite of button "Show Other Descriptions"  then
    put tab & gDescription1 & ":" && field "description1" of card cardNum of stack gStack into temp
    put ";" && gDescription2 &  ":" && field "description2" of card cardNum of stack gStack after temp
    put temp & return after field "report" of stack "invReport"
    --  end if
    
    if the hilite of button "Show Date & Quantity Sold"  then
      set itemdelimiter to comma
      put return & "Dates and Quantity Sold:" & return after field "report" of stack "invReport"
      repeat with l = 1 to the number of lines of dsold
        put word 4 of line l of dsold into zdate
        convert zdate to abbr date
        put word 1 of line l of dsold into znumSold
        put word 1 of line l of dsold into znum
        put validateNumber(zCost) * znum into zsaleCost
        subtract znum from zQty
        put validateNumber(word 6 of line l of dsold) into zprice
        put (znum * zprice) - zsaleCost into zSaleProfit
        delete char 1 of znum
        put zdate & tab & znumSold & " for " & gDollarSign & zprice & " each" \
            & comma & " cost = " & gDollarSign & zsaleCost & comma & " profit = " \
            & gDollarSign & zSaleProfit  & return after field "report" of stack "invReport"
      end repeat
      set itemdelimiter to tab
    end if
    
    if the hilite of button "Show Item Totals" then
      put return &  "Totals for this item" & tab & space & zTotalItemsSold & \
          " sold for " & gDollarSign & zTotalItemSales & \
          comma & " cost = " & gDollarSign & zTotalItemCost & \
          comma & " profit = " & gDollarSign & zTotalItemProfit  & tab & \
          return after field "report" of stack "invReport"
    end if
    
    if the hilite of button "Show Notes"  then
      put return & "Notes:" & tab into temp
      put field "notes" of card cardNum of stack gStack into notes
      repeat while offset(return,notes) > 0
        if char offset(return,notes) -1 of notes is space then
          delete char offset(return,notes) of notes
        else
          put space into char offset(return,notes) of notes
        end if
      end repeat
      put 0 into charCount
      put 70 into lineLength
      repeat while length(notes) > lineLength
        put char 1 to lineLength of notes after temp
        repeat while last char of temp is not space
          delete last char of temp
          add 1 to charCount
        end repeat
        delete char 1 to (lineLength-charCount) of notes
        put temp & return after field "report" of stack "invReport"
        put tab into temp
        put 0 into charCount
      end repeat
      put temp & notes & return after field "report" of stack "invReport"
    end if
    
    if the hilite of button "Show Date & Quantity Sold"  OR \
        the hilite of button "Show Item Totals"  OR \
        the hilite of button "Show Notes"  then
      put makeLine(50,"= ") & return & return after field "report" of stack "invReport"
    else
      put return after field "report" of stack "invReport"
    end if
  end repeat
  
  put zTotalSales -  zTotalCost into zTotalProfit
  if zTotalProfit < 0 then put "< -" &  gDollarSign & abs( zTotalProfit) & " >" into zTotalProfit
  else put gDollarSign before zTotalProfit
  if zTotalNetProfit < 0 then put "< -" &  gDollarSign & abs( zTotalNetProfit) & " >" into zTotalNetProfit
  else put gDollarSign before zTotalNetProfit
  if zTotalNetValue < 0 then put "< -" &  gDollarSign & abs( zTotalNetValue) & " >" into zTotalNetValue
  else put gDollarSign before zTotalNetValue
  if zTotalAllItemsLeft < 0 then put "< -" &  abs( zTotalAllItemsLeft) & " >" into zTotalAllItemsLeft
  put "Report totals:" & return & "Total Items Purchased = " & tab & tab & zTotalItems & return & \
      "Total Items Sold = " & tab & tab & zTotalSold & return & \
      "Total Items left in stock = " & tab & tab & zTotalAllItemsLeft & return & \
      "Total Sales = " & tab & tab & tab & gDollarSign &  zTotalSales & return & \
      "Total Cost of Items Sold = " & tab & tab & tab & gDollarSign & zTotalCostofItemsSold & return & \
      "Total Profits from Items Sold = " & tab & tab & zTotalNetProfit & return & \
      "Total Cost of Items Purchased = " & tab & tab & gDollarSign & zTotalCost & return & \
      "Total Profit (or Loss) = " & tab & tab & tab & zTotalProfit & return & return & \
      "Total Value of Remaining Inventory = " & tab & zTotalNetValue  after field "report" of stack "invReport"
  setHeight "invReport"
  if the openStacks contains "invReport" then close stack "invReport"
  toplevel "invReport"
  setLoc "invReport"
  unlock screen with visual plain
end mouseUp

function makeLine znum,zchar
  repeat with i = 1 to znum
    put space & zchar after temp
  end repeat
  return temp
end makeLine
   ک Wheat    e              	       a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
   Ԡ Gold    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
   ک Wheat    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
   ک Wheat     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@  ک Wheat      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
   Ԡ Gold   + N d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
           N d  z                
     @       0              -Delete all records first or add to existing?   z icon BP on mouseUp
end mouseUp
   ک Wheat      , (         	      Cancel D`  ک Wheat      6 L            	      Add D`  ک Wheat     6 9            	      Delete D`  ک Wheat     6 I            	      All D`  ک Wheat   | 6 /            	      y D`  ک Wheat     4 '            	      x D`  ک Wheat    i 4 '            	      w D`  ک Wheat      4 )            	    