/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.sql;

import java.io.Serializable;
import org.nakedobjects.object.NakedClass;

final class SqlOid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final long key;

    public SqlOid(String string) {
        int n = string.indexOf(35);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid sql reference: " + string);
        }
        this.className = string.substring(0, n);
        this.key = Long.valueOf(string.substring(n + 1));
    }

    public SqlOid(NakedClass nakedClass, long l) {
        this.className = nakedClass.getName();
        this.key = l;
    }

    public SqlOid(String string, long l) {
        this(NakedClass.getNakedClass(string), l);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SqlOid) {
            return this.key == ((SqlOid)object).key;
        }
        return false;
    }

    public final long getDBKey() {
        return this.key;
    }

    public final String getDBReference() {
        return this.className + "#" + this.key;
    }

    public final NakedClass getNakedClass() {
        return NakedClass.getNakedClass(this.className);
    }

    public int hashCode() {
        return (int)(this.key ^ this.key >>> 32);
    }

    public String toString() {
        return "SQL" + this.key;
    }
}

