/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.file;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.AbstractNakedObject;
import org.nakedobjects.object.AbstractObjectStore;
import org.nakedobjects.object.AggregateOid;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.NonPersistentObjectException;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.collection.InternalCollection;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.persistence.file.CollectionData;
import org.nakedobjects.persistence.file.Data;
import org.nakedobjects.persistence.file.DataManager;
import org.nakedobjects.persistence.file.FileOid;
import org.nakedobjects.persistence.file.ObjectData;
import org.nakedobjects.persistence.file.Reference;
import org.nakedobjects.persistence.file.ReferenceVector;
import org.nakedobjects.utility.NotImplementedException;

public abstract class FileObjectStore
extends AbstractObjectStore {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$persistence$file$FileObjectStore == null ? (class$org$nakedobjects$persistence$file$FileObjectStore = FileObjectStore.class$("org.nakedobjects.persistence.file.FileObjectStore")) : class$org$nakedobjects$persistence$file$FileObjectStore));
    private DataManager manager;
    static /* synthetic */ Class class$org$nakedobjects$persistence$file$FileObjectStore;

    public FileObjectStore(DataManager dataManager) {
        this.manager = dataManager;
    }

    public boolean isFirstElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        if (nakedCollection instanceof InternalCollection) {
            return this.manager.readObject(this.parentOid(nakedCollection)).elements(this.fieldName(nakedCollection)).first().equals(new Reference(nakedObject));
        }
        return this.manager.readCollection(nakedCollection.getOid()).references().first().equals(new Reference(nakedObject));
    }

    public boolean isFirstInstance(NakedObject nakedObject, NakedObject nakedObject2) throws ObjectStoreException {
        if (!nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        NakedClass nakedClass = nakedObject.getNakedClass();
        return nakedObject2.getOid().equals(this.manager.readInstances(nakedClass).firstElement());
    }

    public boolean isLastElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        if (nakedCollection instanceof InternalCollection) {
            return this.manager.readObject(this.parentOid(nakedCollection)).elements(this.fieldName(nakedCollection)).last().equals(new Reference(nakedObject));
        }
        return this.manager.readCollection(nakedCollection.getOid()).references().last().equals(new Reference(nakedObject));
    }

    public boolean isLastInstance(NakedObject nakedObject, NakedObject nakedObject2) throws ObjectStoreException {
        if (!nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        NakedClass nakedClass = nakedObject.getNakedClass();
        return nakedObject2.getOid().equals(this.manager.readInstances(nakedClass).lastElement());
    }

    public Vector getNextElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectStoreException {
        Object object;
        int n2;
        int n3;
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (nakedObject != null && !nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        ReferenceVector referenceVector = nakedCollection instanceof InternalCollection ? this.manager.readObject(this.parentOid(nakedCollection)).elements(this.fieldName(nakedCollection)) : this.manager.readCollection(nakedCollection.getOid()).references();
        int n4 = referenceVector.size();
        if (nakedObject == null) {
            n3 = 0;
            n2 = n;
        } else {
            object = new Reference(nakedObject);
            n3 = 0;
            while (n3 < n4) {
                if (((Reference)object).equals(referenceVector.elementAt(n3))) break;
                ++n3;
            }
            if (n3 == n4) {
                throw new ObjectNotFoundException("Could not find " + nakedObject);
            }
            n2 = ++n3 + n;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        object = new Vector();
        int n5 = n3;
        while (n5 < n2) {
            Reference reference = referenceVector.elementAt(n5);
            if (reference == null) {
                throw new RuntimeException();
            }
            ((Vector)object).addElement(this.recreateObject(this.manager.readObject(reference.getOid())));
            ++n5;
        }
        return object;
    }

    public Vector getNextInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws ObjectStoreException {
        if (nakedObject == null) {
            throw new NullPointerException();
        }
        if (nakedObject2 != null && !nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        NakedClass nakedClass = nakedObject.getNakedClass();
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        Enumeration enumeration = this.manager.readInstances(nakedClass).elements();
        boolean bl = nakedObject2 == null;
        while (enumeration.hasMoreElements() && n2 < n) {
            Object e = enumeration.nextElement();
            if (bl) {
                Object object = this.createSkeletalObject(e, nakedClass);
                ((NakedObject)object).resolve();
                if (!this.matchesPattern(nakedObject, (NakedObject)object)) continue;
                vector.add(object);
                ++n2;
                continue;
            }
            if (!nakedObject2.getOid().equals(e)) continue;
            bl = true;
        }
        if (!bl) {
            throw new ObjectNotFoundException("From object not found " + nakedObject2);
        }
        if (vector.size() == 0 && nakedObject2 != null) {
            throw new ObjectNotFoundException("No objects found matching pattern " + nakedObject + " after object " + nakedObject2);
        }
        return vector;
    }

    private boolean matchesPattern(NakedObject nakedObject, NakedObject nakedObject2) {
        NakedClass nakedClass = nakedObject2.getNakedClass();
        Field[] fieldArray = nakedClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (!field.isAggregate() && !field.isDerived()) {
                Naked naked;
                Naked naked2;
                if (field.isValue()) {
                    naked2 = (NakedValue)field.get(nakedObject);
                    naked = (NakedValue)field.get(nakedObject2);
                    if (!naked2.isEmpty()) {
                        String string = naked2.title().toString().toLowerCase();
                        String string2 = naked.title().toString().toLowerCase();
                        if (string2.indexOf(string) == -1) {
                            return false;
                        }
                    }
                } else {
                    naked2 = field.get(nakedObject);
                    naked = field.get(nakedObject2);
                    if (naked2 != null) {
                        if (naked == null) {
                            return false;
                        }
                        if (naked2 != naked) {
                            return false;
                        }
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public NakedObject getObject(Object object) throws ObjectNotFoundException, ObjectStoreException {
        Data data = this.manager.read(object);
        LOG.debug((Object)("Data read " + data));
        if (data instanceof ObjectData) {
            return this.recreateObject((ObjectData)data);
        }
        if (data instanceof CollectionData) {
            throw new NotImplementedException();
        }
        throw new ObjectNotFoundException();
    }

    public Vector getPreviousElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectStoreException {
        Object object;
        int n2;
        int n3;
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (nakedObject != null && !nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        ReferenceVector referenceVector = nakedCollection instanceof InternalCollection ? this.manager.readObject(this.parentOid(nakedCollection)).elements(this.fieldName(nakedCollection)) : this.manager.readCollection(nakedCollection.getOid()).references();
        int n4 = referenceVector.size();
        if (nakedObject == null) {
            n3 = n4;
            n2 = n3 - n;
        } else {
            object = new Reference(nakedObject);
            n3 = 0;
            while (n3 < n4) {
                if (((Reference)object).equals(referenceVector.elementAt(n3))) break;
                ++n3;
            }
            if (n3 == n4) {
                throw new ObjectNotFoundException("Could not find " + nakedObject);
            }
            n2 = n3 - n;
            if (n2 < 0) {
                n2 = 0;
            }
        }
        object = new Vector();
        int n5 = n2;
        while (n5 < n3) {
            Reference reference = referenceVector.elementAt(n5);
            if (reference == null) {
                throw new RuntimeException();
            }
            ((Vector)object).addElement(this.recreateObject(this.manager.readObject(reference.getOid())));
            ++n5;
        }
        return object;
    }

    public Vector getPreviousInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws ObjectStoreException {
        Object object;
        if (nakedObject == null) {
            throw new NullPointerException();
        }
        if (nakedObject2 != null && !nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        NakedClass nakedClass = nakedObject.getNakedClass();
        Enumeration enumeration = this.manager.readInstances(nakedClass).elements();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (nakedObject2 != null && nakedObject2.getOid().equals(object)) break;
            objectArray[n2] = object;
            if (++n2 != n) continue;
            n2 = 0;
        }
        object = new Vector(n);
        int n3 = n2;
        while (n3 < n && objectArray[n3] != null) {
            ((Vector)object).addElement((Object)this.createSkeletalObject(objectArray[n3], nakedClass));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            ((Vector)object).addElement(this.createSkeletalObject(objectArray[n4], nakedClass));
            ++n4;
        }
        return object;
    }

    public void addElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        if (nakedCollection instanceof InternalCollection) {
            ObjectData objectData = this.manager.readObject(this.parentOid(nakedCollection));
            objectData.addElement(this.fieldName(nakedCollection), nakedObject);
            this.manager.write(objectData);
        } else {
            CollectionData collectionData = this.manager.readCollection(nakedCollection.getOid());
            collectionData.addElement(nakedObject);
            this.manager.write(collectionData);
        }
    }

    public boolean containsElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent " + nakedCollection);
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent " + nakedObject);
        }
        if (nakedCollection instanceof InternalCollection) {
            return this.manager.readObject(this.parentOid(nakedCollection)).elements(this.fieldName(nakedCollection)).contains(new Reference(nakedObject));
        }
        return this.manager.readCollection(nakedCollection.getOid()).references().contains(new Reference(nakedObject));
    }

    public void destroyObject(NakedObject nakedObject) throws ObjectStoreException {
        this.manager.remove(nakedObject.getOid());
    }

    public void endTransaction() throws ObjectStoreException {
        throw new NotImplementedException();
    }

    public boolean hasInstances(NakedClass nakedClass) throws ObjectStoreException {
        return this.manager.readInstances(nakedClass).size() > 0;
    }

    public void makePersistent(NakedObject nakedObject) throws ObjectStoreException {
        if (nakedObject instanceof InternalCollection) {
            throw new IllegalArgumentException("Cannot persist an InternalCollection");
        }
        this.makePersistent(nakedObject, new Vector());
    }

    public String name() {
        throw new NotImplementedException();
    }

    public int numberOfElements(NakedCollection nakedCollection) throws ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (nakedCollection instanceof InternalCollection) {
            return this.manager.readObject(this.parentOid(nakedCollection)).elements(this.fieldName(nakedCollection)).size();
        }
        return this.manager.readCollection(nakedCollection.getOid()).references().size();
    }

    public int numberOfInstances(NakedObject nakedObject) throws ObjectStoreException {
        Vector vector = this.manager.readInstanceFile(nakedObject.getNakedClass().getName());
        return vector.size();
    }

    public void removeElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        if (nakedCollection instanceof InternalCollection) {
            ObjectData objectData = this.manager.readObject(this.parentOid(nakedCollection));
            objectData.removeElement(this.fieldName(nakedCollection), nakedObject);
            this.manager.write(objectData);
        } else {
            CollectionData collectionData = this.manager.readCollection(nakedCollection.getOid());
            collectionData.removeElement(nakedObject);
            this.manager.write(collectionData);
        }
    }

    public void resolve(NakedObject nakedObject) throws ObjectStoreException {
        if (nakedObject.isResolved()) {
            return;
        }
        if (nakedObject instanceof NakedCollection) {
            nakedObject.setResolved();
        } else {
            ObjectData objectData = this.manager.readObject(nakedObject.getOid());
            Field[] fieldArray = nakedObject.getNakedClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (field.isValue()) {
                    objectData.get(field.getName(), (NakedValue)field.get(nakedObject));
                } else {
                    Object object = objectData.get(field.getName());
                    LOG.debug((Object)(field + " " + object));
                    if (object != null) {
                        Object object2;
                        Object object3;
                        Serializable serializable;
                        if (this.isObjectCached(object)) {
                            ((Association)field).init(nakedObject, this.getCachedObject(object));
                        } else if (object instanceof ReferenceVector) {
                            serializable = (InternalCollection)field.get(nakedObject);
                            object3 = ((ReferenceVector)object).elements();
                            while (object3.hasMoreElements()) {
                                object2 = (Reference)object3.nextElement();
                                if (this.isObjectCached(((Reference)object2).getOid())) {
                                    ((Association)field).init(nakedObject, this.getCachedObject(((Reference)object2).getOid()));
                                }
                                NakedObject nakedObject2 = this.classFor(((Reference)object2).getType()).acquireInstance();
                                nakedObject2.setOid(((Reference)object2).getOid());
                                ((InternalCollection)serializable).add(nakedObject2);
                            }
                            ((AbstractNakedObject)serializable).setResolved();
                        } else {
                            serializable = ((Reference)object).getOid();
                            object3 = this.manager.readObject(serializable);
                            object2 = this.classFor(((Data)object3).getType()).acquireInstance();
                            object2.setOid(serializable);
                            this.cache((NakedObject)object2);
                            ((Association)field).set(nakedObject, object2);
                        }
                    }
                }
                ++n;
            }
            nakedObject.setResolved();
        }
    }

    public void save(NakedObject nakedObject) throws ObjectStoreException {
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        if (!(nakedObject instanceof NakedCollection) || nakedObject instanceof InternalCollection) {
            this.saveObject(nakedObject);
        }
        this.broadcastObjectUpdate(nakedObject);
    }

    public long serialNumber(String string) throws ObjectStoreException {
        long l = this.manager.readSerialNumber(string);
        this.manager.writeSerialNumber(string, ++l);
        return l;
    }

    public void startTransaction() throws ObjectStoreException {
        throw new NotImplementedException();
    }

    private NakedClass classFor(String string) {
        return NakedClass.getNakedClass(string);
    }

    private Object createSkeletalObject(Object object, NakedClass nakedClass) {
        if (this.isObjectCached(object)) {
            return this.getCachedObject(object);
        }
        NakedObject nakedObject = nakedClass.acquireInstance();
        nakedObject.setOid(object);
        this.cache(nakedObject);
        return nakedObject;
    }

    private String fieldName(NakedCollection nakedCollection) {
        return ((AggregateOid)nakedCollection.getOid()).getName();
    }

    private void makePersistent(NakedObject nakedObject, Vector vector) throws ObjectStoreException {
        if (nakedObject == null || nakedObject.isPersistent() || vector.contains(nakedObject)) {
            return;
        }
        vector.addElement(nakedObject);
        FileOid fileOid = this.manager.createOid();
        if (nakedObject instanceof NakedCollection) {
            CollectionData collectionData = new CollectionData(nakedObject.getNakedClass(), fileOid);
            Enumeration enumeration = ((NakedCollection)nakedObject).elements();
            while (enumeration.hasMoreElements()) {
                NakedObject nakedObject2 = (NakedObject)enumeration.nextElement();
                this.makePersistent(nakedObject2, vector);
                collectionData.addElement(nakedObject2);
            }
            this.manager.create(collectionData);
        } else {
            ObjectData objectData = new ObjectData(nakedObject.getNakedClass(), fileOid);
            Field[] fieldArray = nakedObject.getNakedClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Naked naked = fieldArray[n].get(nakedObject);
                String string = fieldArray[n].getName();
                if (naked instanceof InternalCollection) {
                    Enumeration enumeration = ((InternalCollection)naked).elements();
                    while (enumeration.hasMoreElements()) {
                        NakedObject nakedObject3 = (NakedObject)enumeration.nextElement();
                        this.makePersistent(nakedObject3, vector);
                        objectData.addElement(string, nakedObject3);
                    }
                    ((NakedObject)naked).setResolved();
                } else if (naked instanceof NakedValue) {
                    objectData.set(string, (NakedValue)naked);
                } else if (naked instanceof NakedObject) {
                    this.makePersistent((NakedObject)naked, vector);
                    objectData.set(string, (NakedObject)naked);
                }
                ++n;
            }
            this.manager.create(objectData);
        }
        nakedObject.setOid(fileOid);
        nakedObject.setResolved();
        this.cache(nakedObject);
    }

    private Object parentOid(NakedCollection nakedCollection) {
        return ((AggregateOid)nakedCollection.getOid()).getParentOid();
    }

    private NakedObject recreateObject(ObjectData objectData) throws ObjectStoreException {
        NakedClass nakedClass = this.classFor(objectData.getType());
        NakedObject nakedObject = nakedClass.acquireInstance();
        nakedObject.setOid(objectData.getOid());
        Field[] fieldArray = nakedClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (field.isValue()) {
                objectData.get(field.getName(), (NakedValue)field.get(nakedObject));
            } else if (!field.isAggregate()) {
                Object object = objectData.get(field.getName());
                LOG.debug((Object)(field + " " + object));
                if (object != null) {
                    if (this.isObjectCached(object)) {
                        ((Association)field).init(nakedObject, this.getCachedObject(object));
                    } else {
                        FileOid fileOid = ((Reference)object).getOid();
                        ObjectData objectData2 = this.manager.readObject(fileOid);
                        NakedObject nakedObject2 = this.classFor(objectData2.getType()).acquireInstance();
                        nakedObject2.setOid(fileOid);
                        if (nakedObject2 instanceof InternalCollection) {
                            nakedObject2.setResolved();
                        }
                        this.cache(nakedObject2);
                        ((Association)field).set(nakedObject, nakedObject2);
                    }
                }
            }
            ++n;
        }
        nakedObject.setResolved();
        return nakedObject;
    }

    private void saveObject(NakedObject nakedObject) throws ObjectStoreException {
        ObjectData objectData = new ObjectData(nakedObject.getNakedClass(), (FileOid)nakedObject.getOid());
        Field[] fieldArray = nakedObject.getNakedClass().getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Naked naked = fieldArray[n].get(nakedObject);
            String string = fieldArray[n].getName();
            if (naked instanceof InternalCollection) {
                Enumeration enumeration = ((InternalCollection)naked).elements();
                while (enumeration.hasMoreElements()) {
                    NakedObject nakedObject2 = (NakedObject)enumeration.nextElement();
                    objectData.addElement(string, nakedObject2);
                }
            } else if (naked instanceof NakedValue) {
                objectData.set(string, (NakedValue)naked);
            } else {
                if (naked != null && ((NakedObject)naked).getOid() == null) {
                    throw new IllegalStateException("Cannot save object with field that has no OID: " + string);
                }
                objectData.set(string, (NakedObject)naked);
            }
            ++n;
        }
        this.manager.write(objectData);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

