/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class TimeStamp
extends Magnitude
implements Externalizable {
    private static final DateFormat SHORT_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    private static final DateFormat MEDIUM_FORMAT = DateFormat.getDateTimeInstance(2, 3);
    private static final DateFormat LONG_FORMAT = DateFormat.getDateTimeInstance(1, 1);
    private transient DateFormat format = MEDIUM_FORMAT;
    private boolean isNull = true;
    private Date date;

    public TimeStamp() {
        this.setValue(new Date());
        this.isNull = false;
    }

    public TimeStamp(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public TimeStamp(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setValue(n3, n2, n, n4, n5, n6);
        this.isNull = false;
    }

    public TimeStamp(TimeStamp timeStamp) {
        this.date = timeStamp.date;
        this.isNull = timeStamp.isNull;
    }

    public void add(int n, int n2, int n3) {
        this.checkCanOperate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.add(13, n3);
        calendar.add(12, n2);
        calendar.add(11, n);
        this.set(calendar);
    }

    private void checkTime(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month must be in the range 1 - 12 inclusive " + n2);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, 0);
        int n7 = calendar.getMaximum(5);
        if (n3 < 1 || n3 > n7) {
            throw new IllegalArgumentException("Day must be in the range 1 - " + n7 + " inclusive " + n3);
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive " + n4);
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive " + n5);
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException("Second must be in the range 0 - 59 inclusive " + n6);
        }
    }

    public void clear() {
        this.isNull = true;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof TimeStamp)) {
            throw new IllegalArgumentException("Can only copy the value of  a TimeStamp object");
        }
        this.date = ((TimeStamp)naked).date;
        this.isNull = ((TimeStamp)naked).isNull;
    }

    private Calendar createCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        return calendar;
    }

    public Date dateValue() {
        return this.isNull ? null : this.date;
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof TimeStamp) {
            if (this.isNull) {
                return magnitude.isEmpty();
            }
            return this.date.equals(((TimeStamp)magnitude).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public boolean isLessThan(Magnitude magnitude) {
        this.checkCanOperate();
        if (magnitude instanceof TimeStamp) {
            return !this.isNull && !magnitude.isEmpty() && this.date.before(((TimeStamp)magnitude).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public long longValue() {
        this.checkCanOperate();
        return this.date.getTime();
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            string = string.trim();
            String string2 = string.toLowerCase();
            Calendar calendar = this.createCalendar();
            if (!string2.equals("today") && !string2.equals("now")) {
                if (string2.startsWith("+")) {
                    int n = Integer.valueOf(string2.substring(1));
                    calendar.setTime(this.date);
                    calendar.add(10, n);
                } else if (string2.startsWith("-")) {
                    int n = Integer.valueOf(string2.substring(1));
                    calendar.setTime(this.date);
                    calendar.add(10, -n);
                } else {
                    DateFormat[] dateFormatArray = new DateFormat[]{LONG_FORMAT, MEDIUM_FORMAT, SHORT_FORMAT};
                    int n = 0;
                    while (n < dateFormatArray.length) {
                        try {
                            calendar.setTime(dateFormatArray[n].parse(string));
                            break;
                        }
                        catch (ParseException parseException) {
                            if (n + 1 == dateFormatArray.length) {
                                throw new ValueParseException(parseException, "Invalid timeStamp " + string);
                            }
                            ++n;
                        }
                    }
                }
            }
            this.set(calendar);
            this.isNull = false;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isNull = objectInput.readBoolean();
        this.date.setTime(objectInput.readLong());
    }

    public void reset() {
        this.date = new Date();
        this.isNull = false;
    }

    private void set(Calendar calendar) {
        this.date = calendar.getTime();
    }

    public void setValue(Date date) {
        if (date == null) {
            this.isNull = true;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(14, 0);
            this.date = calendar.getTime();
        }
    }

    public void setValue(long l) {
        this.isNull = false;
        this.date.setTime(l);
    }

    public void setValue(TimeStamp timeStamp) {
        if (timeStamp == null) {
            this.isNull = true;
        } else {
            this.date = new Date(timeStamp.date.getTime());
        }
    }

    public void setValue(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkTime(n, n2, n3, n4, n5, n6);
        Calendar calendar = this.createCalendar();
        calendar.set(5, n3);
        calendar.set(2, n2 - 1);
        calendar.set(1, n);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        this.set(calendar);
    }

    public Title title() {
        return new Title(this.isNull ? "" : this.format.format(this.date));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isNull);
        objectOutput.writeLong(this.date.getTime());
    }

    public Calendar calendarValue() {
        if (this.isNull) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        return calendar;
    }

    public void restoreString(String string) {
        if (string.equals("NULL")) {
            this.clear();
        } else {
            int n = Integer.valueOf(string.substring(0, 4));
            int n2 = Integer.valueOf(string.substring(4, 6));
            int n3 = Integer.valueOf(string.substring(6, 8));
            int n4 = Integer.valueOf(string.substring(8, 10));
            int n5 = Integer.valueOf(string.substring(10, 12));
            int n6 = Integer.valueOf(string.substring(12));
            this.setValue(n, n2, n3, n4, n5, n6);
        }
    }

    public String saveString() {
        if (this.isEmpty()) {
            return "NULL";
        }
        Calendar calendar = this.calendarValue();
        StringBuffer stringBuffer = new StringBuffer(8);
        String string = String.valueOf(calendar.get(1));
        stringBuffer.append("0000".substring(0, 4 - string.length()));
        stringBuffer.append(string);
        int n = calendar.get(2) + 1;
        stringBuffer.append(n <= 9 ? "0" : "");
        stringBuffer.append(n);
        int n2 = calendar.get(5);
        stringBuffer.append(n2 <= 9 ? "0" : "");
        stringBuffer.append(n2);
        int n3 = calendar.get(11);
        stringBuffer.append(n3 <= 9 ? "0" : "");
        stringBuffer.append(n3);
        int n4 = calendar.get(12);
        stringBuffer.append(n4 <= 9 ? "0" : "");
        stringBuffer.append(n4);
        int n5 = calendar.get(13);
        stringBuffer.append(n5 <= 9 ? "0" : "");
        stringBuffer.append(n5);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.title() + " " + this.longValue() + " [TimeStamp]";
    }
}

