/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import java.io.Serializable;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class MakePersistentRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private NakedObject object;

    public MakePersistentRequest(NakedObject nakedObject) {
        this.object = nakedObject;
    }

    void generateResponse(Server server) {
        try {
            server.getObjectStore().makePersistent(this.object);
            this.response = (Serializable)this.object.getOid();
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public void makePersistent() throws ObjectStoreException {
        this.sendRequest();
        this.object.setOid(this.response);
    }

    public String toString() {
        return "MakePersistent [object=" + this.object + "]";
    }
}

