/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.collection;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.collection.CollectionStrategy;

class PersistentCollectionStrategy
implements CollectionStrategy {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$object$collection$PersistentCollectionStrategy == null ? (class$org$nakedobjects$object$collection$PersistentCollectionStrategy = PersistentCollectionStrategy.class$("org.nakedobjects.object.collection.PersistentCollectionStrategy")) : class$org$nakedobjects$object$collection$PersistentCollectionStrategy));
    private NakedObjectStore logicalCollection;
    private NakedCollection collection;
    private int startWindowAt = 0;
    private int windowSize;
    private Vector elements;
    static /* synthetic */ Class class$org$nakedobjects$object$collection$PersistentCollectionStrategy;

    public PersistentCollectionStrategy(NakedCollection nakedCollection) {
        this.logicalCollection = nakedCollection.getObjectStore();
        this.collection = nakedCollection;
    }

    public void setWindowSize(int n) {
        this.windowSize = n;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void add(NakedObject nakedObject) {
        try {
            this.logicalCollection.addElement(this.collection, nakedObject);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"Failed to add element to collection", (Throwable)objectStoreException);
        }
    }

    public boolean contains(NakedObject nakedObject) {
        try {
            return this.logicalCollection.containsElement(this.collection, nakedObject);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"Failed to check for element", (Throwable)objectStoreException);
            return false;
        }
    }

    public Enumeration displayElements() {
        if (this.elements == null) {
            this.first();
        }
        return this.elements.elements();
    }

    public Enumeration elements() {
        return new CollectionEnumeration();
    }

    public void first() {
        try {
            this.elements = this.logicalCollection.getNextElements(this.collection, null, this.windowSize);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"failed to get first elements", (Throwable)objectStoreException);
        }
    }

    public boolean hasNext() {
        try {
            return !this.logicalCollection.isLastElement(this.collection, (NakedObject)this.elements.lastElement());
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"failed to check for next elements", (Throwable)objectStoreException);
            return false;
        }
    }

    public boolean hasPrevious() {
        try {
            return !this.logicalCollection.isFirstElement(this.collection, (NakedObject)this.elements.firstElement());
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"failed to check for previous elements", (Throwable)objectStoreException);
            return false;
        }
    }

    public void last() {
        try {
            this.elements = this.logicalCollection.getPreviousElements(this.collection, null, this.windowSize);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"failed to get last elements", (Throwable)objectStoreException);
        }
    }

    public void next() {
        try {
            this.elements = this.logicalCollection.getNextElements(this.collection, (NakedObject)this.elements.lastElement(), this.windowSize);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"failed to get next elements", (Throwable)objectStoreException);
        }
    }

    public void previous() {
        try {
            this.elements = this.logicalCollection.getPreviousElements(this.collection, (NakedObject)this.elements.firstElement(), this.windowSize);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"failed to get previous elements", (Throwable)objectStoreException);
        }
    }

    public void remove(NakedObject nakedObject) {
        try {
            this.logicalCollection.removeElement(this.collection, nakedObject);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"Failed to remove element to collection", (Throwable)objectStoreException);
        }
    }

    public void reset() {
        this.elements = null;
    }

    public int size() {
        try {
            return this.logicalCollection.numberOfElements(this.collection);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)"Failed to remove element to collection", (Throwable)objectStoreException);
            return 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CollectionEnumeration
    implements Enumeration {
        int count;
        Object last;

        public CollectionEnumeration() {
            PersistentCollectionStrategy.this.first();
            this.count = 0;
        }

        public boolean hasMoreElements() {
            if (this.count == PersistentCollectionStrategy.this.elements.size()) {
                if (!PersistentCollectionStrategy.this.hasNext()) {
                    return false;
                }
                PersistentCollectionStrategy.this.next();
                if (PersistentCollectionStrategy.this.hasNext()) {
                    this.count = 0;
                } else {
                    this.count = 0;
                    while (this.count < PersistentCollectionStrategy.this.elements.size()) {
                        if (PersistentCollectionStrategy.this.elements.elementAt(this.count).equals(this.last)) {
                            ++this.count;
                            break;
                        }
                        ++this.count;
                    }
                }
            }
            return this.count < PersistentCollectionStrategy.this.elements.size();
        }

        public Object nextElement() {
            this.last = PersistentCollectionStrategy.this.elements.elementAt(this.count++);
            return this.last;
        }
    }
}

