/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object;

import java.awt.Image;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.AggregateOid;
import org.nakedobjects.object.ExternalOid;
import org.nakedobjects.object.ImageIcon;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.Status;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.control.About;
import org.nakedobjects.object.control.ActionAbout;
import org.nakedobjects.object.control.FieldAbout;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.object.reflect.OneToManyAssociation;

public abstract class AbstractNakedObject
extends Observable
implements NakedObject {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$object$AbstractNakedObject == null ? (class$org$nakedobjects$object$AbstractNakedObject = AbstractNakedObject.class$("org.nakedobjects.object.AbstractNakedObject")) : class$org$nakedobjects$object$AbstractNakedObject));
    private static NakedObjectStore store;
    private Object oid;
    private transient boolean isResolved = false;
    private boolean isFinder = false;
    static /* synthetic */ Class class$org$nakedobjects$object$AbstractNakedObject;
    static /* synthetic */ Class class$org$nakedobjects$object$NakedValue;

    public About about() {
        return FieldAbout.READ_WRITE;
    }

    public About aboutExplorationActionClone() {
        return ActionAbout.enable(this.canClone());
    }

    public boolean canClone() {
        return true;
    }

    public String contextualTitle() {
        return this.title().toString();
    }

    public void copyObject(Naked naked) {
        if (naked.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Copy object can only copy objects of the same type");
        }
        NakedObject nakedObject = (NakedObject)naked;
        Field[] fieldArray = this.getNakedClass().getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (field instanceof OneToManyAssociation) {
                ((NakedCollection)field.get(this)).copyObject((NakedCollection)field.get(nakedObject));
            } else if (field instanceof Association) {
                ((Association)field).init(this, (NakedObject)field.get(nakedObject));
            } else if (field instanceof Field) {
                ((NakedValue)field.get(this)).copyObject(field.get(nakedObject));
            }
            ++n;
        }
    }

    protected static NakedObject createInstance(Class clazz) {
        return NakedClass.getNakedClass(clazz).actionNewInstance();
    }

    protected static NakedObject createTransientInstance(Class clazz) {
        NakedObject nakedObject = AbstractNakedObject.acquireInstance(clazz);
        nakedObject.created();
        return nakedObject;
    }

    private static NakedObject acquireInstance(Class clazz) {
        NakedClass nakedClass = NakedClass.getNakedClass(clazz.getName());
        if (nakedClass == null) {
            throw new RuntimeException("Invalid type to create " + clazz);
        }
        return nakedClass.acquireInstance();
    }

    public void created() {
    }

    public void destroy() throws ObjectStoreException {
        if (this.isPersistent()) {
            this.getObjectStore().destroyObject(this);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractNakedObject) {
            AbstractNakedObject abstractNakedObject = (AbstractNakedObject)object;
            if (abstractNakedObject.getOid() == null) {
                return false;
            }
            return abstractNakedObject.getOid().equals(this.getOid());
        }
        return false;
    }

    public NakedClass explorationActionClass() {
        return this.getNakedClass();
    }

    public AbstractNakedObject explorationActionClone() {
        AbstractNakedObject abstractNakedObject = (AbstractNakedObject)AbstractNakedObject.createInstance(this.getClass());
        abstractNakedObject.copyObject(this);
        abstractNakedObject.objectChanged();
        return abstractNakedObject;
    }

    public static String getClassHelpText() {
        return null;
    }

    public String getClassName() {
        String string = this.getFullClassName();
        if (string.indexOf(36) >= 0) {
            string = string.substring(0, string.indexOf(36));
        }
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public String getCollectiveName() {
        return this.getClassName() + "s";
    }

    public String getFullClassName() {
        return this.getClass().getName();
    }

    public String getIconName() {
        return this.getClassName();
    }

    public String getIdString() {
        return this.getClassName() + "/" + this.getOid() + " (" + this.countObservers() + ")";
    }

    public NakedClass getNakedClass() {
        return NakedClass.getNakedClass(this.getClass().getName());
    }

    public String getObjectHelpText() {
        return this.summary();
    }

    public NakedObjectStore getObjectStore() {
        return store;
    }

    public Object getOid() {
        return this.oid;
    }

    public int hashCode() {
        if (this.getOid() == null) {
            return super.hashCode();
        }
        return 629 + this.getOid().hashCode();
    }

    public Image iconImage(int n) {
        String string = this.getIconName();
        String string2 = this instanceof Status ? ((Status)((Object)this)).statusCode() : "";
        return ImageIcon.getImageIcon(string, n, string2).getImage();
    }

    public static void init(NakedObjectStore nakedObjectStore) {
        store = nakedObjectStore;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isFinder() {
        return this.isFinder;
    }

    public boolean isLookupElement(String string) {
        return string.equals(this.title().toString());
    }

    public boolean isPersistent() {
        return this.getOid() != null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public boolean isValid() {
        return true;
    }

    public void makeFinder() {
        if (this.isPersistent()) {
            throw new IllegalStateException("Can't make a persient object into a Finder");
        }
        this.isFinder = true;
    }

    public void makePersistent() throws ObjectStoreException {
        if (!this.isPersistent()) {
            LOG.debug((Object)("makePersistent(" + this + ")"));
            store.makePersistent(this);
        }
    }

    public void objectChanged() {
        if (this.isResolved()) {
            try {
                store.save(this);
            }
            catch (ObjectStoreException objectStoreException) {
                LOG.error((Object)"Error saving object", (Throwable)objectStoreException);
            }
        } else if (this.isFinder()) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isFinder = objectInput.readBoolean();
        Object object = objectInput.readObject();
        if (this.getOid() == null && object != null) {
            this.setOid(object);
        }
        block2: while (true) {
            Serializable serializable;
            Naked naked;
            Field field;
            Object object2;
            try {
                String string = objectInput.readUTF();
                if (string.equals("END_OF_OBJECT")) break;
                object2 = objectInput.readObject();
                field = this.getNakedClass().getField(string);
            }
            catch (EOFException eOFException) {
                break;
            }
            if (field == null) continue;
            if (field instanceof OneToManyAssociation) {
                naked = (NakedCollection)field.get(this);
                if (this.isFinder() || !this.isPersistent()) {
                    serializable = (Vector)object2;
                    int n = 0;
                    while (true) {
                        if (n >= ((Vector)serializable).size()) continue block2;
                        naked.add((NakedObject)((Vector)serializable).elementAt(n));
                        ++n;
                    }
                }
                if (object2 == null) {
                    throw new RuntimeException("InternalCollections must have their OIDs set");
                }
                if (object2.equals(naked.getOid())) continue;
                throw new IllegalStateException("The object being updated must have the same OID");
            }
            if (field instanceof Association) {
                naked = (NakedObject)field.get(this);
                if (object2 != null) {
                    serializable = (ExternalOid)object2;
                    if (naked != null && naked.getOid() == ((ExternalOid)serializable).getOid()) continue;
                    ((Association)field).init(this, ((ExternalOid)serializable).recreateObject(this.getObjectStore()));
                    continue;
                }
                if (naked == null) continue;
                ((Association)field).init(this, null);
                continue;
            }
            naked = (NakedValue)field.get(this);
            if (naked == null) continue;
            naked.copyObject((NakedValue)object2);
        }
    }

    public void resolve() {
        if (!this.isResolved() && this.isPersistent()) {
            LOG.debug((Object)("resolve(" + this + ")"));
            try {
                store.resolve(this);
            }
            catch (ObjectStoreException objectStoreException) {
                LOG.error((Object)"Failed to resolve", objectStoreException.getException());
            }
        }
    }

    public static void resolve(NakedObject nakedObject) {
        if (nakedObject != null) {
            nakedObject.resolve();
        }
    }

    public void setChangedAndNotifyObservers() {
        this.setChanged();
        this.notifyObservers();
    }

    public void setOid(Object object) {
        if (this.oid == null) {
            this.oid = object;
            Field[] fieldArray = this.getNakedClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n] instanceof OneToManyAssociation) {
                    ((NakedObject)((OneToManyAssociation)fieldArray[n]).get(this)).setOid(new AggregateOid(object, fieldArray[n].getName()));
                }
                ++n;
            }
        } else {
            throw new IllegalStateException("The OID is already set (" + this.oid + ")");
        }
    }

    public void setResolved() {
        if (this.isResolved) {
            throw new IllegalStateException("Object is already marked as resolved (" + this + ")");
        }
        this.isResolved = true;
    }

    public String summary() {
        return this.title().toString();
    }

    public abstract Title title();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [");
        if (!this.isResolved()) {
            stringBuffer.append("~");
        }
        stringBuffer.append(this.getClassName());
        stringBuffer.append(":");
        stringBuffer.append(this.getOid() == null ? (this.isFinder() ? "FINDER" : "TRANSIENT") : "PERSISTENT");
        if (this.oid != null) {
            stringBuffer.append(":");
            stringBuffer.append(this.oid);
        } else {
            stringBuffer.append(":-");
        }
        stringBuffer.append("/" + super.hashCode());
        stringBuffer.append("/" + this.countObservers() + "] ");
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isFinder());
        objectOutput.writeObject(this.getOid());
        Field[] fieldArray = this.getNakedClass().getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (!field.isDerived()) {
                NakedObject nakedObject;
                objectOutput.writeUTF(field.getName());
                if ((class$org$nakedobjects$object$NakedValue == null ? AbstractNakedObject.class$("org.nakedobjects.object.NakedValue") : class$org$nakedobjects$object$NakedValue).isAssignableFrom(field.getType())) {
                    objectOutput.writeObject(field.get(this));
                } else if (fieldArray[n] instanceof OneToManyAssociation) {
                    nakedObject = (NakedCollection)field.get(this);
                    if (this.isFinder() || !this.isPersistent()) {
                        Vector vector = new Vector(nakedObject.size());
                        Enumeration enumeration = nakedObject.elements();
                        while (enumeration.hasMoreElements()) {
                            vector.addElement(enumeration.nextElement());
                        }
                        objectOutput.writeObject(vector);
                    } else {
                        objectOutput.writeObject(nakedObject.getOid());
                    }
                } else {
                    nakedObject = (NakedObject)field.get(this);
                    objectOutput.writeObject(nakedObject == null ? null : new ExternalOid(nakedObject));
                }
            }
            ++n;
        }
        objectOutput.writeUTF("END_OF_OBJECT");
    }

    public void deleted() {
    }

    public boolean isSameAs(Naked naked) {
        return naked == this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

