/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.object.NakedObject;

public abstract class IconBorder
extends ViewBorder {
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int LEFT = 16;
    public static final int CENTER = 32;
    public static final int RIGHT = 48;
    protected static final int imageLabelGap = 6;
    private int justification;
    private int position;
    protected TextStyle style;
    protected ViewBorder border;

    public IconBorder() {
        this(1, 16, TextStyle.getStyle(1), null);
    }

    public IconBorder(int n, int n2, TextStyle textStyle, ViewBorder viewBorder) {
        this.justification = n;
        this.position = n2;
        this.style = textStyle;
        this.border = viewBorder;
    }

    public IconBorder(TextStyle textStyle, ViewBorder viewBorder) {
        this(1, 16, textStyle, viewBorder);
    }

    public IconBorder(ViewBorder viewBorder) {
        this(1, 16, TextStyle.getStyle(1), viewBorder);
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        Insets insets = this.insets(objectViewer.getObject());
        if (this.border == null) {
            return insets;
        }
        Insets insets2 = this.border.getBorderInsets(objectViewer);
        insets2.top += insets.top;
        insets2.bottom += insets.bottom;
        insets2.left += insets.left;
        insets2.right += insets.right;
        return insets2;
    }

    protected Dimension getIconDimension(NakedObject nakedObject) {
        Image image = nakedObject.iconImage(16);
        Dimension dimension = image == null ? new Dimension(16, 16) : new Dimension(image.getWidth(null), image.getHeight(null));
        return dimension;
    }

    protected String getTitle(NakedObject nakedObject) {
        if (nakedObject.contextualTitle() == null) {
            return "";
        }
        return nakedObject.contextualTitle();
    }

    public abstract Insets insets(NakedObject var1);

    public void paintBorder(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        if (this.border != null) {
            Insets insets = this.insets(objectViewer.getObject());
            int n = rectangle.x + insets.left;
            int n2 = rectangle.y + insets.top;
            int n3 = rectangle.width - insets.left - insets.right;
            int n4 = rectangle.height - insets.top - insets.bottom;
            this.border.paint(graphics, new Rectangle(n, n2, n3, n4), objectViewer);
        }
    }

    public String toString() {
        return "[style=" + this.style + ",inner=" + this.border + "]";
    }
}

