Attribute VB_Name = "AINET"
' Last revision: July 11 1997
'
' Note about VB40 32bit and aiNet32.dll
' -------------------------------------
'
' 32 bit C and C++ compilers treat integer as 32bit long.
' Both versions of Visual Basic (16 and 32 bit) treats Integer as 16 bit long.
' Therefore we must use Long variable declaration wherever ainet32.dll expects an integer.
' That is because Long in VB40 is 32 bit long.
'

Option Explicit

'
' aiNet function declarations
'
Public Declare Function aiCreateModel Lib "ainet32.dll" (ByVal nModelVectors As Long, ByVal nVariables As Long, ByVal nInpVariables As Long) As Long
Public Declare Function aiCreateModelFromCSVFile Lib "ainet32.dll" (ByVal FileName As String) As Long
Public Declare Function aiDeleteModel Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiNormalize Lib "ainet32.dll" (ByVal Model As Long, ByVal method As Long) As Long
Public Declare Function aiDenormalize Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiRegistration Lib "ainet32.dll" (ByVal user As String, ByVal code As String) As Long
Public Declare Function aiPrediction Lib "ainet32.dll" (ByVal Model As Long, toPredict As Single, ByVal penalty As Single, ByVal method As Long) As Long
Public Declare Function aiGetVariableVB Lib "ainet32.dll" (ByVal Model As Long, ByVal mv As Long, ByVal v As Long, value As Single) As Long
Public Declare Function aiGetVariable Lib "ainet32.dll" (ByVal Model As Long, ByVal mv As Long, ByVal v As Long) As Single
Public Declare Function aiSetVariable Lib "ainet32.dll" (ByVal Model As Long, ByVal mv As Long, ByVal v As Long, ByVal value As Single) As Long
Public Declare Function aiGetCSVFileModelSize Lib "ainet32.dll" (ByVal FileName As String) As Long
Public Declare Function aiGetVersion Lib "ainet32.dll" () As Long
Public Declare Function aiGetNumberOfVariables Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiGetNumberOfModelVectors Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiGetNumberOfInputVariables Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiSetDiscreteFlag Lib "ainet32.dll" (ByVal Model As Long, ByVal v As Long, ByVal f As Long) As Long
Public Declare Function aiGetDiscreteFlag Lib "ainet32.dll" (ByVal Model As Long, ByVal i As Long) As Long
' new in version 1.24
Public Declare Function aiSetCapacity Lib "ainet32.dll" (ByVal Model As Long, ByVal newCap As Long) As Long
Public Declare Function aiGetCapacity Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiGetFreeEntries Lib "ainet32.dll" (ByVal Model As Long) As Long
Public Declare Function aiInsertModelVector Lib "ainet32.dll" (ByVal Model As Long, ByVal index As Long, NewMV As Single) As Long
Public Declare Function aiOverwriteModelVector Lib "ainet32.dll" (ByVal Model As Long, ByVal index As Long, NewMV As Single) As Long
Public Declare Function aiAppendModelVector Lib "ainet32.dll" (ByVal Model As Long, NewMV As Single) As Long
Public Declare Function aiDeleteModelVector Lib "ainet32.dll" (ByVal Model As Long, ByVal index As Long) As Long
Public Declare Function aiPredictionEx Lib "ainet32.dll" (ByVal Model As Long, toPredict As Single, ByVal penalty As Single, ByVal method As Long, list As Long, ByVal listSize As Long, ByVal listType As Long) As Long
Public Declare Function aiExcludeModelVector Lib "ainet32.dll" (ByVal Model As Long, ByVal i As Long, ByVal exclude As Long) As Long
Public Declare Function aiExcludeModelVectorRange Lib "ainet32.dll" (ByVal Model As Long, ByVal first As Long, ByVal last As Long, ByVal exclude As Long) As Long
Public Declare Function aiIsModelVectorExcluded Lib "ainet32.dll" (ByVal Model As Long, ByVal index As Long) As Long
Public Declare Function aiSaveCSVFile Lib "ainet32.dll" (ByVal Model As Long, ByVal FileName As String) As Long

'
' aiNet error constants
'
Public Const AIERR_NO_ERROR = 0
Public Const AIERR_PENALTY_ZERO = -1
Public Const AIERR_NO_IO_VARIABLES = -2
Public Const AIERR_PENALTY_TOO_SMALL = -3
Public Const AIERR_EMPTY_ROW = -4
Public Const AIERR_EMPTY_COLUMN = -5
Public Const AIERR_EQUAL_COLUMN = -6
Public Const AIERR_CSV_OPEN = -7
Public Const AIERR_CSV_READ = -8
Public Const AIERR_MEMORY_ALLOCATION = -9
Public Const AIERR_INVALID_POINTER = -10
Public Const AIERR_INVALID_INDEX = -11
' new in version 1.24
Public Const AIERR_NO_FREE_ENTRY = -12


'
' Penalty coefficient constants
'
Public Const PENALTY_STATIC = 0
Public Const PENALTY_DYNAMIC = 1
Public Const PENALTY_NEAREST = 2

'
' Normalization constants
'
Public Const NORMALIZE_REGULAR = 0
Public Const NORMALIZE_STATISTICAL = 1

'
' List Influence constants

Public Const MOST_INFLUENT = 1
Public Const LEAST_INFLUENT = 0

