// ------------------------------------------------------------------------
// System       : Pictorial Inventory
// Program      : bmpcalc.c
// Description  : simple windows .bmp filesize calculator
//                output can be redirected to disk
// Written by   : Bill Buckels
// Date Written : December 25, 1995
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>

void main()
{
    char *lpszLine =
         "===========================================================";
    char szWidth[128], szHeight[128], szColors[128];
    long dwWidth, dwHeight, dwColors;
    long dwRaster, dwCmap, dwBits, dwHeader = 54L;
    long dwImageSize, dwKbytes;
    unsigned wBits, wColors;

    puts("BMPCALC.EXE Non-Compressed Windows .BMP FileSize Calculator");


    for(;;)
    {
        // loop until finished
        puts(lpszLine);

        // 1. Width Entry
        printf("Enter Width  (blank exits) ?: ");gets(szWidth);
        dwWidth = atol(szWidth);
        if(dwWidth < 1L)break;

        // 2. Height Entry
        printf("Enter Height (blank exits) ?: ");gets(szHeight);
        dwHeight = atol(szHeight);
        if(dwHeight < 1L)break;

        // 3. Color Entry
        for(;;)
        {
          printf("Colors (2, 16, 256, 16M)   ?: ");gets(szColors);
          dwColors = atol(szColors);
          if(dwColors<1L)break;
          wColors = (unsigned)dwColors;
          switch(wColors)
          {
            case 2  :   dwBits = 1L;
                        break;
            case 16 :   if(toupper(szColors[2])=='M')dwBits = 24L;
                        else dwBits = 4L;
                        break;
            case 256:   dwBits = 8L;
                        break;
            default :   dwBits = 0L;
                        printf("%c",7);
          }
          // loop if invalid
          if(dwBits>0L)break;
        }
        // if finished break
        if(dwColors<1L)break;
        wBits = (unsigned )dwBits;

        // adjust for image type
        //   1. color map size (RGB QUAD = 4 bytes)
        //   2. raster length in bytes (must be aligned on 32 bit boundaries)
        switch(wBits)
        {
             case 1  : dwCmap = 4L * 2L;
                       dwRaster = dwWidth;
                       while((dwRaster%32)!=0)dwRaster++;
                       dwRaster /= 8;
                       break;

             case 4  : dwCmap = 4L * 16L;
                       dwRaster = dwWidth;
                       while((dwRaster%8)!=0)dwRaster++;
                       dwRaster /= 2;
                       break;

             case 8  : dwCmap = 4L * 256L;
                       dwRaster = dwWidth;
                       while((dwRaster%4)!=0)dwRaster++;
                       break;

             case 24 : dwCmap = 0L;
                       dwRaster = dwWidth * 4L;
                       break;
        }

        // print report to screen
       printf("%s\n.BMP FileSize Calculation   : %s x %s x %s colors\n%s\n",
               lpszLine,szWidth,szHeight,szColors,lpszLine);

       dwImageSize = dwRaster * dwHeight;

       printf("Header size                 : %20ld bytes\n",dwHeader);
       printf("Color map size              : %20ld bytes\n",dwCmap);
       printf("Image data size             : %20ld bytes\n",dwImageSize);
         puts("                              =============================");

       dwImageSize += dwHeader;
       dwImageSize += dwCmap;
       dwKbytes     = dwImageSize/1024L;
       if(dwImageSize%1024!=0)dwKbytes+=1;

       printf("Total .BMP size (bytes)     : %20ld bytes\n",dwImageSize);
       printf("Total .BMP size (Kbytes)    : %20ld Kbytes\n",dwKbytes);
       puts(lpszLine);
       puts("   (Actual disk space used will vary for different drives.)");
    
    }

  exit(0);
}
