//============================================================
// MYPRINT.H - Header file
//============================================================

#define	PERR_CANCELED           -1
#define	PERR_EOF                -2
#define	PERR_NOPRINT            -3
#define	PERR_NODISK             -4
#define	PERR_NOFONT             -5
#define	PERR_BADPRINT           -6
#define	PERR_BADPAGE            -7
#define	PERR_BADPRNDC           -8
#define	PERR_OUTOFMEMORY        -9

// MyPrintInit - Called during instance init.
INT MyPrintInit (HINSTANCE, HWND, LPSTR);

// MyPrintInit - Called during instance terminate.
INT MyPrintTerm (HINSTANCE, HWND, LPSTR);

// MyPrintSetup - Called to display Print Setup dialog
INT MyPrintSetup (HWND);

// MyPrintPageSetup - Called to display Page Setup dialog
INT MyPrintPageSetup (HWND);

// prototype of callback function used by MyPrintPrint to 
// get document data.
typedef	UINT (*PGDCBFUNC) (HWND, LONG, LPSTR, UINT);

// MyPrintPrint - Called to print document
INT MyPrintPrint (HWND, LPSTR, HFONT, INT, PGDCBFUNC);

// MyPrintCancel - Called to cancel printing
INT MyPrintCancel (HWND, LPSTR);

#define	IDD_HEADER            100
#define	IDD_FOOTER            101
#define	IDD_MLEFT             102
#define	IDD_MRIGHT            103
#define	IDD_MTOP              104
#define	IDD_MBOTTOM           105
#define	IDD_LINES             106
#define	IDD_PRNINFO           107
