VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "VBPrint Functions"
   ClientHeight    =   4215
   ClientLeft      =   1665
   ClientTop       =   3090
   ClientWidth     =   6195
   Height          =   4650
   Left            =   1605
   LinkTopic       =   "Form1"
   ScaleHeight     =   4215
   ScaleWidth      =   6195
   Top             =   2715
   Width           =   6315
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Printer Features"
      Height          =   1695
      Left            =   0
      TabIndex        =   11
      Top             =   2460
      Width           =   6180
      Begin ListBox lstRes 
         Height          =   615
         Left            =   5025
         TabIndex        =   17
         Top             =   420
         Width           =   975
      End
      Begin ListBox lstBins 
         Height          =   615
         Left            =   3135
         TabIndex        =   15
         Top             =   420
         Width           =   1785
      End
      Begin ListBox lstPapers 
         Height          =   1200
         Left            =   135
         TabIndex        =   12
         Top             =   420
         Width           =   2940
      End
      Begin Label Label1 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Resolutions"
         Height          =   195
         Index           =   5
         Left            =   5025
         TabIndex        =   16
         Top             =   195
         Width           =   1005
      End
      Begin Label Label1 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Paper bins"
         Height          =   195
         Index           =   4
         Left            =   3120
         TabIndex        =   14
         Top             =   195
         Width           =   915
      End
      Begin Label Label1 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Paper types"
         Height          =   195
         Index           =   3
         Left            =   135
         TabIndex        =   13
         Top             =   195
         Width           =   1020
      End
   End
   Begin CheckBox chkDefault 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Use Windows defaults in dialog"
      Height          =   195
      Left            =   75
      TabIndex        =   5
      Top             =   2175
      Width           =   3270
   End
   Begin CheckBox chkPerm 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Make changes permanent"
      Height          =   195
      Left            =   75
      TabIndex        =   4
      Top             =   1905
      Width           =   2745
   End
   Begin Timer Timer1 
      Interval        =   1000
      Left            =   6015
      Top             =   9670
   End
   Begin CommandButton cmdBtn 
      Caption         =   "E&xit"
      Height          =   330
      Index           =   2
      Left            =   4800
      TabIndex        =   3
      Top             =   1560
      Width           =   1300
   End
   Begin CommandButton cmdBtn 
      Caption         =   "Show &Dialog"
      Height          =   330
      Index           =   1
      Left            =   4800
      TabIndex        =   2
      Top             =   1170
      Width           =   1300
   End
   Begin CommandButton cmdBtn 
      Caption         =   "&Set Default"
      Height          =   330
      Index           =   0
      Left            =   4800
      TabIndex        =   1
      Top             =   780
      Width           =   1300
   End
   Begin ListBox lstPrinters 
      Height          =   1590
      Left            =   60
      TabIndex        =   0
      Top             =   255
      Width           =   3270
   End
   Begin Label lblDefDriver 
      BackColor       =   &H00FFFFFF&
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   4050
      TabIndex        =   10
      Top             =   510
      Width           =   1410
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Driver:"
      Height          =   195
      Index           =   2
      Left            =   3420
      TabIndex        =   9
      Top             =   525
      Width           =   585
   End
   Begin Label lblDefault 
      BackColor       =   &H00FFFFFF&
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   3420
      TabIndex        =   8
      Top             =   270
      Width           =   2610
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Current default printer:"
      Height          =   195
      Index           =   1
      Left            =   3420
      TabIndex        =   7
      Top             =   30
      Width           =   1935
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Installed printers"
      Height          =   195
      Index           =   0
      Left            =   60
      TabIndex        =   6
      Top             =   30
      Width           =   1425
   End
End
DefInt I
DefLng L
DefStr S

Option Explicit

Dim Shared DeviceData() As DEVMODE_TYPE

Sub cmdBtn_Click (Index As Integer)
  Dim iRet As Integer
  Dim inMode As DEVMODE_TYPE
  Dim outMode As DEVMODE_TYPE
  Dim sTemp As String
  Dim iMode As Integer
  Dim sTemp2 As String

  Select Case Index
    Case 0
      If lstPrinters.ListIndex = True Then Exit Sub
      sTemp = lstPrinters.List(lstPrinters.ListIndex)
      iRet = VBSetDefPrinter(sTemp)
      If iRet <> True Then MsgBox "Error setting default printer", 48, "Error"
      Timer1_Timer
    Case 1
      If lstPrinters.ListIndex = True Then Exit Sub
      sTemp = lstPrinters.List(lstPrinters.ListIndex)
      iMode = DM_OUT_BUFFER Or DM_IN_PROMPT
      If chkPerm.Value <> 0 Then iMode = iMode Or DM_OUT_DEFAULT
      If chkDefault.Value = 0 Then iMode = iMode Or DM_IN_BUFFER
      sTemp2 = VBDevModeToStr(DeviceData(lstPrinters.ListIndex))
      iRet = VBStrToDevMode(sTemp2, inMode)
      iRet = VBExtDeviceMode(0, sTemp, inMode, DeviceData(lstPrinters.ListIndex), iMode)
    Case 2
      End
  End Select
End Sub

Sub Form_Load ()
  Dim sTemp As String
  Dim inMode As DEVMODE_TYPE
  Dim iRet As Integer

  Me.Left = screen.Width / 2 - Me.Width / 2
  Me.Top = screen.Height / 2 - Me.Height / 2
  
  sTemp = VBGetPrinters()
  While sTemp <> ""
    ReDim Preserve DeviceData(lstPrinters.ListCount)
    iRet = VBExtDeviceMode(0, sTemp, inMode, DeviceData(lstPrinters.ListCount), DM_OUT_BUFFER)
    If iRet = 1 Then lstPrinters.AddItem sTemp
    sTemp = VBGetPrinters()
  Wend
  lstPrinters.ListIndex = 0
  lstPrinters_Click
  Timer1_Timer
End Sub

Sub lstPrinters_Click ()
  ShowOptions lstPrinters.List(lstPrinters.ListIndex) + ""
End Sub

Sub ShowOptions (sPrinter As String)
  Dim resList() As ENUMRESOLUTIONS_TYPE
  Dim binNameList() As BINNAMES_TYPE
  Dim binNumList() As Integer
  Dim papNameList() As PAPERNAMES_TYPE
  Dim papSizeList() As PAPERSIZE_TYPE
  Dim lRet As Long
  Dim inDev As DEVMODE_TYPE
  Dim iCounter As Integer

  ' Step 1, find out how many paper sizes/names there are
  lRet = VBDeviceCapabilities(sPrinter, DC_PAPERSIZE, ByVal 0&, inDev)
  If lRet = 0 Then Exit Sub
  
  ' Size our arrays accordingly
  ReDim papSizeList(lRet - 1) As PAPERSIZE_TYPE
  ReDim papNameList(lRet - 1) As PAPERNAMES_TYPE
  
  papNameList(0).sName = "Test1"
  papNameList(1).sName = "Test2"
  ' Get the actual names of the available papers and their sizes
  lRet = VBDeviceCapabilities(sPrinter, DC_PAPERNAMES, papNameList(0), inDev)
  lRet = VBDeviceCapabilities(sPrinter, DC_PAPERSIZE, papSizeList(0), inDev)
  
  ' Display the available paper types in a list
  ' Note the papSizeList() is just for demonstration
  ' purposes, I don't use it here but you may want to use
  ' it for reference purposes.
  lstPapers.Clear
  For iCounter = 0 To lRet - 1
    lstPapers.AddItem Trim$(papNameList(iCounter).sName)
  Next
  
  ' Same procedure for the available printer bins
  lRet = VBDeviceCapabilities(sPrinter, DC_BINNAMES, ByVal 0&, inDev)
  If lRet = 0 Then Exit Sub
  ReDim binNameList(lRet - 1) As BINNAMES_TYPE
  ReDim binNumList(lRet - 1) As Integer

  lRet = VBDeviceCapabilities(sPrinter, DC_BINS, binNumList(0), inDev)
  lRet = VBDeviceCapabilities(sPrinter, DC_BINNAMES, binNameList(0), inDev)
  lstBins.Clear
  For iCounter = 0 To lRet - 1
    lstBins.AddItem Trim$(binNameList(iCounter).sName)
  Next
  
  lRet = VBDeviceCapabilities(sPrinter, DC_ENUMRESOLUTIONS, ByVal 0&, inDev)
  If lRet = 0 Then Exit Sub
  ReDim resList(lRet - 1) As ENUMRESOLUTIONS_TYPE
  lRet = VBDeviceCapabilities(sPrinter, DC_ENUMRESOLUTIONS, resList(0), inDev)
  lstRes.Clear
  For iCounter = 0 To lRet - 1
    lstRes.AddItem Format$(resList(iCounter).xdpi, "#") + " x " + Format$(resList(iCounter).ydpi, "#")
  Next
End Sub

Sub Timer1_Timer ()
  Dim sTemp As String

  sTemp = VBGetDefPrinter()
  lblDefault.Caption = sTemp
  lblDefDriver = VBGetDriverFromName(sTemp)
End Sub

