#ifndef _WINUTIL_H

typedef struct tagGLOBALMEM /* glbmem */
{
    HGLOBAL hglbMem;
    void FAR * lpvMem;
    unsigned long int nMemSize;
} GLOBALMEM;

typedef struct tagLOCALMEM /* locmem */
{
    HLOCAL hlocMem;
    void NEAR * npvMem;
    unsigned long int nMemSize;
} LOCALMEM;

typedef struct tagGLOBALSTR /* glbstr */
{
    HGLOBAL hglbMem;
    LPSTR lpStr;
    unsigned long int nMemSize;
    unsigned long int nStrLen;
} GLOBALSTR;

typedef struct tagLOCALSTR /* locstr */
{
    HLOCAL hlocMem;
    LPSTR lpStr;
    unsigned long int nMemSize;
    unsigned long int nStrLen;
} LOCALSTR;

#if defined (WIN32)
#define MAX_EDIT_SIZE 1048500
#else
#define MAX_EDIT_SIZE 65500
#endif

#define MSGBOX(a,b) \
    MessageBeep(MB_ICONASTERISK); \
    MessageBox(a,b,"WinQuery Message",MB_OK | MB_ICONASTERISK);
#define ERRBOX(a,b) \
    MessageBeep(MB_ICONHAND); \
    MessageBox(a,b,"WinQuery Error",MB_OK | MB_ICONHAND);
    
BOOL ReadFileIntoEdit(HWND ,LPSTR);
BOOL WriteFileFromEdit(HWND ,LPSTR);
//BOOL AddLineToBuffer(HGLOBAL *, LPSTR *, LPSTR);
//BOOL AddStrToBuffer(HGLOBAL *, LPSTR *, LPSTR);
BOOL EditLineCat (HWND, LPSTR);
BOOL EditStrCat (HWND, LPSTR);
//BOOL MemFree(HGLOBAL *);
//BOOL MemAlloc(HGLOBAL *, LPSTR *);
//BOOL MemAdd(HGLOBAL *, LPSTR *, DWORD);
BOOL FreeMem(GLOBALMEM *);
BOOL AllocMem(GLOBALMEM *);
BOOL ReAllocMem(GLOBALMEM *, DWORD);
BOOL AddLineToMem(GLOBALMEM *, LPSTR);
BOOL AddStrToMem(GLOBALMEM *, LPSTR);

#define _WINUTIL_H
#endif
