Program trigcalc; { precalculate trig tables for MapView }
{ tables calculated will be Ln(ArcTan(p2 * x + p1)) and Sin(x)               }
{ for x = 0..90, in steps of 0.01, where p2 = Pi/360, p1 = Pi/4              }
{ Optional command line argument: /4 or /6 (Default is /6):                  }
{ /2 : format is standard TurboPascal 6 byte reals; output file is TRIG2.BIN }
{ /3 : format is IEEE 4 byte reals for 80x87 use;   output file is TRIG3.BIN }
{ Freeware by TapirSoft Gisbert W.Selke, 18 Dec 1988. TurboPascal 5.0        }

{$R-,S-,I-,D-,F-,V-,B-,N+,E+,L+ }
{$M 65520,0,480000 }

  Const out2name = 'TRIG2.BIN';
        out3name = 'TRIG3.BIN';
        maxangle = 9000;
        max1merc = 8500;

  Type table2 = Array [0..maxangle] Of real;
       table3 = Array [0..maxangle] Of single;

  Var trigf2 : File Of table2;
      trigf3 : File Of table3;
      y2 : table2;
      y3 : table3 Absolute y2;
      x, p1, p2 : double;
      i : word;
      outname : string;
      ieee : boolean;

  Procedure init;
  { read command line                                                        }
    Var t : string;
  Begin                                                               { init }
    ieee := False;
    t := ParamStr(1);
    If t <> '' Then
    Begin
      If (Length(t) = 2) And (t[1] In ['/','-']) And (t[2] In ['2','3']) Then
                                                           ieee := t[2] = '3'
      Else
      Begin
        writeln('Usage: trigcalc [/2 | /3] to produce TRIG2.BIN or TRIG3.BIN');
        writeln('       (TurboPascal 6-byte reals or IEEE 4-byte reals)');
        writeln('       Default is /2.');
        writeln('       See MAPVIEW.DOC for details.');
        Halt(1);
      End;
    End;
    If ieee Then outname := out3name Else outname := out2name;
  End;                                                                { init }

Begin                                                                 { main }
  init;
writeln('TRIGCALC 1.1  --  Freeware by TapirSoft Gisbert W.Selke, 19 Dec 1988');
  If ieee Then
  Begin
    Assign(trigf3,outname);
    Rewrite(trigf3);
  End Else
  Begin
    Assign(trigf2,outname);
    Rewrite(trigf2);
  End;
  If IOResult <> 0 Then
  Begin
    writeln('Cannot open ',outname);
    Halt(2);
  End;
  write('          Calculating Ln(Tan(x))',#13);
  p1 := Pi / 4.0;
  p2 := Pi / 36000.0;
  For i := 0 To max1merc Do
  Begin
    x := i*p2 + p1;
    If ieee Then y3[i] := Ln(Sin(x)/Cos(x))
            Else y2[i] := Ln(Sin(x)/Cos(x));
    If Lo(i) = 0 Then write(i,#13);
  End;
  If ieee Then For i := Succ(max1merc) To maxangle Do y3[i] := i*0.01
          Else For i := Succ(max1merc) To maxangle Do y2[i] := i*0.01;
  writeln(maxangle);
  If ieee Then write(trigf3,y3) Else write(trigf2,y2);
  If IOResult <> 0 Then
  Begin
    writeln('Cannot write to ',outname);
    Halt(3);
  End;
  write('          Calculating Sin(x)',#13);
  p2 := Pi / 18000.0;
  For i := 0 To maxangle Do
  Begin
    If ieee Then y3[i] := Sin(i*p2)
            Else y2[i] := Sin(i*p2);
    If Lo(i) = 0 Then write(i,#13);
  End;
  writeln(maxangle);
  If ieee Then write(trigf3,y3) Else write(trigf2,y2);
  If ieee Then Close(trigf3) Else Close(trigf2);
  If IOResult <> 0 Then
  Begin
    writeln('Cannot write to ',outname);
    Halt(3);
  End;
  writeln('Done.');
End.                                                                  { main }
