/* -----------------------------------------------------------------------
   wfsauth.c -- WFS sample authorization exit

   wfsauth interprets argv[1] as the requestor's address.

   Yes, the example is simplistic.

   Returns:
      0 -- permit processing of the request
      1 -- Abandon this message. Do not send a session transcript to
           the requestor.

   Compile with Microsoft C6 or C7


Copyright 1992, The Birdsong Company, Sunnyvale CA USA -- All Rights Reserved
-------------- */

#include <string.h>

// --- define return values for the User authorization exit
//
#define AUTHORIZED    0
#define NOTAUTHORIZED 1


/* ---------------------------------------------------------------------
   main() -- The main function

---------- */
int main( int argc, char **argv ) {
   char * user = *(argv +1); // Pointer to requestor


   // -----------------------------------------
   // check the user against something ---
   // if there is some address like this, lock him out!

   if ( stricmp( user, "frobaz@dinkle.dork.gazorchkas.com" ) == 0 ) 
      return NOTAUTHORIZED;

   // ----------------------------------------
   // return AUTHORIZED to permit processing
   
   return AUTHORIZED;

} // --- end main() ---

