/*
 *  WAFDB.C
 *  Generate Q&A ASCII Database Form
 *
 *  (C) Copyright 1989 Darkside International
 *  PO Box 4436 Mountain View CA 94040
 *
 *  Distributed with permission from Author
 *
 *  Creates a "standard ASCII" file from /waffle/admin/password.  Excellent
 *  for importing into your standard database (dBASE?) or flat-file manager
 *  (Q&A?) for generating all kinds of (meaningless?) statistics.  For
 *  more information, write to "rabbit@darkside.com" and wait patiently.
 *
 */

#include <stdio.h>

#define NFIELDS 25
#define RECLEN 256L
#define INDEXLEN 16L

char *tag();

main (argc, argv)
  int argc; char *argv[];
  {
  FILE *fp, *out;

  long num;
  char buf [BUFSIZ];

  if (argc != 3)
    {
    printf ("Usage: wafdb password-file ascii-report-file\n");
    exit (1);
    }

  if ((fp = fopen (argv [1], "r")) == NULL)
    {
    printf ("wafdb: Can't open %s\n", argv[1]);
    exit (2);
    }

  if ((out = fopen (argv [2], "w")) == NULL)
    {
    printf ("wafdb: Can't open output file %s\n", argv[2]);
    exit (3);
    }

  for (num = 1 ;; num++)
    {
    fseek (fp, num * RECLEN, 0);

    if (fgets (buf, BUFSIZ, fp))
      {
      int i;

      fprintf (out, "\"%s\"", tag (buf));

      for (i = 1; i <= NFIELDS; i++)
	{
	if (fgets (buf, BUFSIZ, fp))
	  {
	  tag (buf);
	  fprintf (out, ",\"%s\"", tag (buf));
	  }
	else
	  break;
	}

      fprintf (out, "\n");
      }
    else
      break;
    }

  fclose (fp);
  fclose (out);
  }

/*
 *  t a g		(waffle.c)
 *
 *  Strip the trailing carriage return or
 *  linefeeds from the line given. To fix fgets.
 *
 */

char *tag (s)
  char *s;
  {
  char *save = s;
  while (*s && *s != '\n' && *s != '\r') s++;
  *s = 0;
  return save;
  }