/*===========================================================================
SOLAR v0.95.2 slrnews :: Module ..\slrnews\cnews.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed into the public domain.
===========================================================================*/

#include <stdio.h>
#include <string.h>
#include "cnews.h"

/*
Function: partial_cnews()
Purpose : Scan message file and create a partial C-news format index record.
Return  : 0 on success, non-zero on error.
*/

int partial_cnews(FILE *message_file, FILE *index_file, long message_size, long offset, char *file_name)
{
  char *extract_header(char *buf);

  char buf[1024];

  int  lines = 0;
  char subject[1024];
  char author[1024];
  char date[1024];

  subject[0] = '\0';
  author[0]  = '\0';
  date[0]    = '\0';

  while (fgets(buf,1024,message_file) != NULL)
  {
    if ((strnicmp(buf,"Subject:",8)) == 0)
      strcpy(subject,extract_header(buf));

    if ((strnicmp(buf,"From:",5)) == 0)
      strcpy(author,extract_header(buf));

    if ((strnicmp(buf,"Date:",5)) == 0)
      strcpy(date,extract_header(buf));

    if (strlen(buf) < 4)
    {
      while (fgets(buf,1024,message_file) != NULL) lines++;
      break;
    }
  }

  /* If we are not doing summaries, drop the selector (file_name) */

  if (keyword != 's')
  {
    fprintf(index_file,"%lu\t%s\t%s\t%s\t%lu\t%u\n",offset,subject,author, \
          date,message_size,lines);
  }
  else
  {
    fprintf(index_file,"%lu\t%s\t%s\t%s\t%lu\t%u\t%s\n",offset,subject,author, \
          date,message_size,lines,file_name);
  }
  return 0;
}

int full_cnews(FILE *message_file, FILE *index_file, long message_size, long offset, char *file_name)
{
  char *extract_header(char *buf);

  char buf[1024];

  int  lines = 0;
  char subject[1024];
  char author[1024];
  char date[1024];
  char msgid[1024];
  char refs[1024];

  subject[0] = '\0';
  author[0]  = '\0';
  date[0]    = '\0';
  msgid[0]   = '\0';
  refs[0]    = '\0';

  while (fgets(buf,1024,message_file) != NULL)
  {
    if ((strnicmp(buf,"Subject:",8)) == 0)
      strcpy(subject,extract_header(buf));

    if ((strnicmp(buf,"From:",5)) == 0)
      strcpy(author,extract_header(buf));

    if ((strnicmp(buf,"Date:",5)) == 0)
      strcpy(date,extract_header(buf));

    if ((strnicmp(buf,"Message-ID:",11)) == 0)
      strcpy(msgid,extract_header(buf));

    if ((strnicmp(buf,"References:",11)) == 0)
      strcpy(refs,extract_header(buf));

    if (strlen(buf) < 4)
    {
      while (fgets(buf,1024,message_file) != NULL) lines++;
      break;
    }
  }

  if (keyword != 's')
  {
    fprintf(index_file,"%lu\t%s\t%s\t%s\t%s\t%s\t%lu\t%u\n",offset,subject, \
          author,date,msgid,refs,message_size,lines);
  }
  else
  {
    fprintf(index_file,"%lu\t%s\t%s\t%s\t%s\t%s\t%lu\t%u\t%s\n",offset,subject, \
          author,date,msgid,refs,message_size,lines,file_name);
  }
  return 0;
}

char *extract_header(char *buf)
{
  int x = 0;
  int y = 0;
  static char new_header[1024];

  for (x = strlen(buf) - 2; buf[x] == ' '; x--);
  buf[++x] = '\0';

  x = 0;
  while (buf[x++] != ':');
  while (buf[x++] != ' ');
  while (buf[x] != '\0')
  {
    if (buf[x] == '\t')
    {
      new_header[y++] = ' ';
      x++;
    }
    else
    {
      new_header[y++] = buf[x++];
    }
  }
  new_header[y] = '\0';
  return new_header;
}
